/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.pathfinding;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.me.cache.PathGridCache;
import appeng.me.pathfinding.IPathItem;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PathSegment {
    public boolean isDead;
    PathGridCache pgc;
    List<IPathItem> open;
    Set<IPathItem> semiopen;
    Set<IPathItem> closed;

    public PathSegment(PathGridCache myPGC, List open, Set semiopen, Set closed) {
        this.open = open;
        this.semiopen = semiopen;
        this.closed = closed;
        this.pgc = myPGC;
        this.isDead = false;
    }

    public boolean step() {
        List<IPathItem> oldOpen = this.open;
        this.open = new LinkedList<IPathItem>();
        for (IPathItem i : oldOpen) {
            for (IPathItem pi : i.getPossibleOptions()) {
                EnumSet<GridFlags> flags = pi.getFlags();
                if (this.closed.contains(pi)) continue;
                pi.setControllerRoute(i, true);
                if (flags.contains((Object)GridFlags.REQUIRE_CHANNEL)) {
                    if (!this.semiopen.contains(pi)) {
                        boolean worked = false;
                        worked = flags.contains((Object)GridFlags.COMPRESSED_CHANNEL) ? this.useDenseChannel(pi) : this.useChannel(pi);
                        if (worked && flags.contains((Object)GridFlags.MULTIBLOCK)) {
                            Iterator<IGridNode> oni = ((IGridMultiblock)((IGridNode)((Object)pi)).getGridBlock()).getMultiblockNodes();
                            while (oni.hasNext()) {
                                IGridNode otherNodes = oni.next();
                                if (otherNodes == pi) continue;
                                this.semiopen.add((IPathItem)((Object)otherNodes));
                            }
                        }
                    } else {
                        pi.incrementChannelCount(1);
                        this.semiopen.remove(pi);
                    }
                }
                this.closed.add(pi);
                this.open.add(pi);
            }
        }
        return this.open.isEmpty();
    }

    private boolean useChannel(IPathItem start) {
        IPathItem pi;
        for (pi = start; pi != null; pi = pi.getControllerRoute()) {
            if (pi.canSupportMoreChannels()) continue;
            return false;
        }
        for (pi = start; pi != null; pi = pi.getControllerRoute()) {
            ++this.pgc.channelsByBlocks;
            pi.incrementChannelCount(1);
        }
        return true;
    }

    private boolean useDenseChannel(IPathItem start) {
        IPathItem pi;
        for (pi = start; pi != null; pi = pi.getControllerRoute()) {
            if (pi.canSupportMoreChannels() && !pi.getFlags().contains((Object)GridFlags.CANNOT_CARRY_COMPRESSED)) continue;
            return false;
        }
        for (pi = start; pi != null; pi = pi.getControllerRoute()) {
            ++this.pgc.channelsByBlocks;
            pi.incrementChannelCount(1);
        }
        return true;
    }

    static class RouteComplete
    extends Exception {
        private static final long serialVersionUID = 810456465120286110L;

        RouteComplete() {
        }
    }
}

