/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.MEPassthru;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.FuzzyPriorityList;
import appeng.util.prioitylist.PrecisePriorityList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CellInventoryHandler
extends MEInventoryHandler<IAEItemStack>
implements ICellInventoryHandler {
    NBTTagCompound openNbtData() {
        return Platform.openNbtData(this.getCellInv().getItemStack());
    }

    @Override
    public ICellInventory getCellInv() {
        IMEInventory<Object> o = this.internal;
        if (o instanceof MEPassthru) {
            o = ((MEPassthru)o).getInternal();
        }
        return (ICellInventory)((Object)(o instanceof ICellInventory ? o : null));
    }

    CellInventoryHandler(IMEInventory c) {
        super(c, StorageChannel.ITEMS);
        ICellInventory ci = this.getCellInv();
        if (ci != null) {
            ItemStack is;
            int x;
            IItemList<IAEItemStack> priorityList = AEApi.instance().storage().createItemList();
            IInventory upgrades = ci.getUpgradesInventory();
            IInventory config = ci.getConfigInventory();
            FuzzyMode fzMode = ci.getFuzzyMode();
            boolean hasInverter = false;
            boolean hasFuzzy = false;
            block4: for (x = 0; x < upgrades.func_70302_i_(); ++x) {
                Upgrades u;
                is = upgrades.func_70301_a(x);
                if (is == null || !(is.func_77973_b() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.func_77973_b()).getType(is)) == null) continue;
                switch (u) {
                    case FUZZY: {
                        hasFuzzy = true;
                        continue block4;
                    }
                    case INVERTER: {
                        hasInverter = true;
                        continue block4;
                    }
                }
            }
            for (x = 0; x < config.func_70302_i_(); ++x) {
                is = config.func_70301_a(x);
                if (is == null) continue;
                priorityList.add(AEItemStack.create(is));
            }
            IncludeExclude includeExclude = this.myWhitelist = hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
            if (!priorityList.isEmpty()) {
                this.myPartitionList = hasFuzzy ? new FuzzyPriorityList<IAEItemStack>(priorityList, fzMode) : new PrecisePriorityList<IAEItemStack>(priorityList);
            }
        }
    }

    @Override
    public boolean isPreformatted() {
        return !this.myPartitionList.isEmpty();
    }

    @Override
    public boolean isFuzzy() {
        return this.myPartitionList instanceof FuzzyPriorityList;
    }

    @Override
    public IncludeExclude getIncludeExcludeMode() {
        return this.myWhitelist;
    }

    public int getStatusForCell() {
        int val = this.getCellInv().getStatusForCell();
        if (val == 1 && this.isPreformatted()) {
            val = 2;
        }
        return val;
    }
}

