/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.storage.data.IAEStack;
import appeng.me.cache.GridStorageCache;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ItemWatcher
implements IStackWatcher {
    GridStorageCache gsc;
    IStackWatcherHost myObject;
    HashSet<IAEStack> myInterests = new HashSet();

    public ItemWatcher(GridStorageCache cache, IStackWatcherHost host) {
        this.gsc = cache;
        this.myObject = host;
    }

    public IStackWatcherHost getHost() {
        return this.myObject;
    }

    @Override
    public boolean add(IAEStack e) {
        if (this.myInterests.contains(e)) {
            return false;
        }
        return this.myInterests.add((IAEStack)e.copy()) && this.gsc.interestManager.put(e, this);
    }

    @Override
    public boolean addAll(Collection<? extends IAEStack> c) {
        boolean didChange = false;
        for (IAEStack iAEStack : c) {
            didChange = this.add(iAEStack) || didChange;
        }
        return didChange;
    }

    @Override
    public void clear() {
        Iterator<IAEStack> i = this.myInterests.iterator();
        while (i.hasNext()) {
            this.gsc.interestManager.remove(i.next(), this);
            i.remove();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.myInterests.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.myInterests.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.myInterests.isEmpty();
    }

    @Override
    public Iterator<IAEStack> iterator() {
        return new ItemWatcherIterator(this, this.myInterests.iterator());
    }

    @Override
    public boolean remove(Object o) {
        return this.myInterests.remove(o) && this.gsc.interestManager.remove((IAEStack)o, this);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean didSomething = false;
        for (Object o : c) {
            didSomething = this.remove(o) || didSomething;
        }
        return didSomething;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<IAEStack> i = this.iterator();
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.myInterests.size();
    }

    @Override
    public Object[] toArray() {
        return this.myInterests.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.myInterests.toArray(a);
    }

    class ItemWatcherIterator
    implements Iterator<IAEStack> {
        final ItemWatcher watcher;
        final Iterator<IAEStack> interestIterator;
        IAEStack myLast;

        public ItemWatcherIterator(ItemWatcher parent, Iterator<IAEStack> i) {
            this.watcher = parent;
            this.interestIterator = i;
        }

        @Override
        public boolean hasNext() {
            return this.interestIterator.hasNext();
        }

        @Override
        public IAEStack next() {
            this.myLast = this.interestIterator.next();
            return this.myLast;
        }

        @Override
        public void remove() {
            ItemWatcher.this.gsc.interestManager.remove(this.myLast, this.watcher);
            this.interestIterator.remove();
        }
    }
}

