/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.cache.SecurityCache;
import appeng.util.ItemSorters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class NetworkInventoryHandler<T extends IAEStack<T>>
implements IMEInventoryHandler<T> {
    private static final Comparator prioritySorter = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return ItemSorters.compareInt(o2, o1);
        }
    };
    final StorageChannel myChannel;
    final SecurityCache security;
    final TreeMap<Integer, List<IMEInventoryHandler<T>>> prorityInventory;
    static int currentPass = 0;
    int myPass = 0;
    static final ThreadLocal<LinkedList> depthMod = new ThreadLocal();
    static final ThreadLocal<LinkedList> depthSim = new ThreadLocal();

    public NetworkInventoryHandler(StorageChannel chan, SecurityCache security) {
        this.myChannel = chan;
        this.security = security;
        this.prorityInventory = new TreeMap(prioritySorter);
    }

    public void addNewStorage(IMEInventoryHandler<T> h) {
        int priority = h.getPriority();
        List<IMEInventoryHandler<T>> list = this.prorityInventory.get(priority);
        if (list == null) {
            list = new ArrayList<IMEInventoryHandler<T>>();
            this.prorityInventory.put(priority, list);
        }
        list.add(h);
    }

    private LinkedList getDepth(Actionable type) {
        ThreadLocal<LinkedList> depth = type == Actionable.MODULATE ? depthMod : depthSim;
        LinkedList s = depth.get();
        if (s == null) {
            s = new LinkedList();
            depth.set(s);
        }
        return s;
    }

    private boolean diveList(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type) {
        LinkedList cDepth = this.getDepth(type);
        if (cDepth.contains(networkInventoryHandler)) {
            return true;
        }
        cDepth.push(this);
        return false;
    }

    private boolean diveIteration(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type) {
        LinkedList cDepth = this.getDepth(type);
        if (cDepth.isEmpty()) {
            this.myPass = ++currentPass;
        } else {
            if (currentPass == this.myPass) {
                return true;
            }
            this.myPass = currentPass;
        }
        cDepth.push(this);
        return false;
    }

    private void surface(NetworkInventoryHandler<T> networkInventoryHandler, Actionable type) {
        if (this.getDepth(type).pop() != this) {
            throw new RuntimeException("Invalid Access to Networked Storage API detected.");
        }
    }

    private boolean testPermission(BaseActionSource src, SecurityPermissions permission) {
        if (src.isPlayer()) {
            if (!this.security.hasPermission(((PlayerSource)src).player, permission)) {
                return true;
            }
        } else if (src.isMachine() && this.security.isAvailable()) {
            IGridNode n = ((MachineSource)src).via.getActionableNode();
            if (n == null) {
                return true;
            }
            IGrid gn = n.getGrid();
            if (gn != this.security.myGrid) {
                int playerID = -1;
                ISecurityGrid sg = (ISecurityGrid)gn.getCache(ISecurityGrid.class);
                playerID = sg.getOwner();
                if (!this.security.hasPermission(playerID, permission)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public T injectItems(T input, Actionable type, BaseActionSource src) {
        if (this.diveList(this, type)) {
            return input;
        }
        if (this.testPermission(src, SecurityPermissions.INJECT)) {
            this.surface(this, type);
            return input;
        }
        for (List<IMEInventoryHandler<T>> invList : this.prorityInventory.values()) {
            IMEInventoryHandler<T> inv;
            Iterator<IMEInventoryHandler<T>> ii = invList.iterator();
            while (ii.hasNext() && input != null) {
                inv = ii.next();
                if (!inv.validForPass(1) || !inv.canAccept(input) || !inv.isPrioritized(input) && inv.extractItems(input, Actionable.SIMULATE, src) == null) continue;
                input = inv.injectItems(input, type, src);
            }
            ii = invList.iterator();
            while (ii.hasNext() && input != null) {
                inv = ii.next();
                if (!inv.validForPass(2) || !inv.canAccept(input)) continue;
                input = inv.injectItems(input, type, src);
            }
        }
        this.surface(this, type);
        return input;
    }

    @Override
    public T extractItems(T request, Actionable mode, BaseActionSource src) {
        if (this.diveList(this, mode)) {
            return null;
        }
        if (this.testPermission(src, SecurityPermissions.EXTRACT)) {
            this.surface(this, mode);
            return null;
        }
        Iterator i = this.prorityInventory.descendingMap().values().iterator();
        Object output = request.copy();
        request = request.copy();
        output.setStackSize(0L);
        long req = request.getStackSize();
        while (i.hasNext()) {
            List invList = (List)i.next();
            Iterator ii = invList.iterator();
            while (ii.hasNext() && output.getStackSize() < req) {
                IMEInventoryHandler inv = (IMEInventoryHandler)ii.next();
                request.setStackSize(req - output.getStackSize());
                output.add((Object)inv.extractItems(request, mode, src));
            }
        }
        this.surface(this, mode);
        if (output.getStackSize() <= 0L) {
            return null;
        }
        return (T)output;
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList out) {
        if (this.diveIteration(this, Actionable.SIMULATE)) {
            return out;
        }
        for (List<IMEInventoryHandler<T>> i : this.prorityInventory.values()) {
            for (IMEInventoryHandler<T> j : i) {
                out = j.getAvailableItems(out);
            }
        }
        this.surface(this, Actionable.SIMULATE);
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return this.myChannel;
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(T input) {
        return false;
    }

    @Override
    public boolean canAccept(T input) {
        return true;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }
}

