/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.parts.IPartCollsionHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class BusCollisionHelper
implements IPartCollsionHelper {
    final List<AxisAlignedBB> boxes;
    private final ForgeDirection x;
    private final ForgeDirection y;
    private final ForgeDirection z;
    private final Entity entity;
    private final boolean isVisual;

    public BusCollisionHelper(List<AxisAlignedBB> boxes, ForgeDirection x, ForgeDirection y, ForgeDirection z, Entity e, boolean visual) {
        this.boxes = boxes;
        this.x = x;
        this.y = y;
        this.z = z;
        this.entity = e;
        this.isVisual = visual;
    }

    public BusCollisionHelper(List<AxisAlignedBB> boxes, ForgeDirection s, Entity e, boolean visual) {
        this.boxes = boxes;
        this.entity = e;
        this.isVisual = visual;
        switch (s) {
            case DOWN: {
                this.x = ForgeDirection.EAST;
                this.y = ForgeDirection.NORTH;
                this.z = ForgeDirection.DOWN;
                break;
            }
            case UP: {
                this.x = ForgeDirection.EAST;
                this.y = ForgeDirection.SOUTH;
                this.z = ForgeDirection.UP;
                break;
            }
            case EAST: {
                this.x = ForgeDirection.SOUTH;
                this.y = ForgeDirection.UP;
                this.z = ForgeDirection.EAST;
                break;
            }
            case WEST: {
                this.x = ForgeDirection.NORTH;
                this.y = ForgeDirection.UP;
                this.z = ForgeDirection.WEST;
                break;
            }
            case NORTH: {
                this.x = ForgeDirection.WEST;
                this.y = ForgeDirection.UP;
                this.z = ForgeDirection.NORTH;
                break;
            }
            case SOUTH: {
                this.x = ForgeDirection.EAST;
                this.y = ForgeDirection.UP;
                this.z = ForgeDirection.SOUTH;
                break;
            }
            default: {
                this.x = ForgeDirection.EAST;
                this.y = ForgeDirection.UP;
                this.z = ForgeDirection.SOUTH;
            }
        }
    }

    @Override
    public boolean isBBCollision() {
        return !this.isVisual;
    }

    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public void addBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        double aX = (minX /= 16.0) * (double)this.x.offsetX + (minY /= 16.0) * (double)this.y.offsetX + (minZ /= 16.0) * (double)this.z.offsetX;
        double aY = minX * (double)this.x.offsetY + minY * (double)this.y.offsetY + minZ * (double)this.z.offsetY;
        double aZ = minX * (double)this.x.offsetZ + minY * (double)this.y.offsetZ + minZ * (double)this.z.offsetZ;
        double bX = (maxX /= 16.0) * (double)this.x.offsetX + (maxY /= 16.0) * (double)this.y.offsetX + (maxZ /= 16.0) * (double)this.z.offsetX;
        double bY = maxX * (double)this.x.offsetY + maxY * (double)this.y.offsetY + maxZ * (double)this.z.offsetY;
        double bZ = maxX * (double)this.x.offsetZ + maxY * (double)this.y.offsetZ + maxZ * (double)this.z.offsetZ;
        if (this.x.offsetX + this.y.offsetX + this.z.offsetX < 0) {
            aX += 1.0;
            bX += 1.0;
        }
        if (this.x.offsetY + this.y.offsetY + this.z.offsetY < 0) {
            aY += 1.0;
            bY += 1.0;
        }
        if (this.x.offsetZ + this.y.offsetZ + this.z.offsetZ < 0) {
            aZ += 1.0;
            bZ += 1.0;
        }
        minX = Math.min(aX, bX);
        minY = Math.min(aY, bY);
        minZ = Math.min(aZ, bZ);
        maxX = Math.max(aX, bX);
        maxY = Math.max(aY, bY);
        maxZ = Math.max(aZ, bZ);
        this.boxes.add(AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
    }

    @Override
    public ForgeDirection getWorldX() {
        return this.x;
    }

    @Override
    public ForgeDirection getWorldY() {
        return this.y;
    }

    @Override
    public ForgeDirection getWorldZ() {
        return this.z;
    }
}

