/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollsionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.settings.TickRates;
import appeng.core.sync.GuiBridge;
import appeng.me.GridAccessException;
import appeng.parts.automation.PartSharedItemBus;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;

public class PartImportBus
extends PartSharedItemBus
implements IGridTickable,
IInventoryDestination {
    BaseActionSource mySrc;
    IMEInventory<IAEItemStack> destination = null;
    IAEItemStack lastItemChecked = null;
    private int itemToSend;
    private boolean worked;

    public PartImportBus(ItemStack is) {
        super(PartImportBus.class, is);
        this.settings.registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.settings.registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.mySrc = new MachineSource(this);
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.side, GuiBridge.GUI_BUS);
            return true;
        }
        return false;
    }

    @Override
    public boolean canInsert(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        this.lastItemChecked = AEApi.instance().storage().createItemStack(stack);
        IAEItemStack out = this.destination.injectItems(this.lastItemChecked, Actionable.SIMULATE, this.mySrc);
        if (out == null) {
            return true;
        }
        return out.getStackSize() != (long)stack.field_77994_a;
    }

    private IInventoryDestination configDest(IMEMonitor<IAEItemStack> itemInventory) {
        this.destination = itemInventory;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon());
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.renderCache = rh.useSimpliedRendering(x, y, z, this, this.renderCache);
        rh.setTexture(CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon());
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(6.0f, 6.0f, 12.0f, 10.0f, 10.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public void getBoxes(IPartCollsionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ImportBus.min, TickRates.ImportBus.max, this.getHandler() == null, false);
    }

    @Override
    TickRateModulation doBusWork() {
        if (!this.proxy.isActive()) {
            return TickRateModulation.IDLE;
        }
        this.worked = false;
        InventoryAdaptor myAdaptor = this.getHandler();
        FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
        if (myAdaptor != null) {
            try {
                switch (this.getInstalledUpgrades(Upgrades.SPEED)) {
                    default: {
                        this.itemToSend = 1;
                        break;
                    }
                    case 1: {
                        this.itemToSend = 8;
                        break;
                    }
                    case 2: {
                        this.itemToSend = 32;
                        break;
                    }
                    case 3: {
                        this.itemToSend = 64;
                        break;
                    }
                    case 4: {
                        this.itemToSend = 96;
                    }
                }
                this.itemToSend = Math.min(this.itemToSend, (int)(0.01 + this.proxy.getEnergy().extractAEPower((double)this.itemToSend, Actionable.SIMULATE, PowerMultiplier.CONFIG)));
                IMEMonitor<IAEItemStack> inv = this.proxy.getStorage().getItemInventory();
                IEnergyGrid energy = this.proxy.getEnergy();
                boolean Configured = false;
                for (int x = 0; x < this.availableSlots(); ++x) {
                    IAEItemStack ais = this.config.getAEStackInSlot(x);
                    if (ais == null || this.itemToSend <= 0) continue;
                    Configured = true;
                    while (this.itemToSend > 0 && !this.importStuff(myAdaptor, ais, inv, energy, fzMode)) {
                    }
                }
                if (!Configured) {
                    while (this.itemToSend > 0) {
                        if (!this.importStuff(myAdaptor, null, inv, energy, fzMode)) continue;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            return TickRateModulation.SLEEP;
        }
        return this.worked ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        return this.doBusWork();
    }

    private boolean importStuff(InventoryAdaptor myAdaptor, IAEItemStack whatToImport, IMEMonitor<IAEItemStack> inv, IEnergySource energy, FuzzyMode fzMode) {
        ItemStack newItems;
        int toSend = this.itemToSend;
        if (toSend > 64) {
            toSend = 64;
        }
        if ((newItems = this.getInstalledUpgrades(Upgrades.FUZZY) > 0 ? myAdaptor.removeSimilarItems(toSend, whatToImport == null ? null : whatToImport.getItemStack(), fzMode, this.configDest(inv)) : myAdaptor.removeItems(toSend, whatToImport == null ? null : whatToImport.getItemStack(), this.configDest(inv))) != null) {
            newItems.field_77994_a = (int)(Math.min((double)newItems.field_77994_a, energy.extractAEPower(newItems.field_77994_a, Actionable.SIMULATE, PowerMultiplier.CONFIG)) + 0.01);
            this.itemToSend -= newItems.field_77994_a;
            if (this.lastItemChecked == null || !this.lastItemChecked.isSameType(newItems)) {
                this.lastItemChecked = AEApi.instance().storage().createItemStack(newItems);
            } else {
                this.lastItemChecked.setStackSize(newItems.field_77994_a);
            }
            IAEItemStack failed = Platform.poweredInsert(energy, this.destination, this.lastItemChecked, this.mySrc);
            if (failed != null) {
                myAdaptor.addItems(failed.getItemStack());
                return true;
            }
        } else {
            return true;
        }
        this.worked = true;
        return false;
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.settings.getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Override
    protected boolean isSleeping() {
        return this.getHandler() == null || super.isSleeping();
    }
}

