/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.layers;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.LayerBase;
import appeng.api.parts.LayerFlags;
import appeng.util.Platform;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class LayerIEnergySource
extends LayerBase
implements IEnergySource {
    private boolean isInIC2() {
        return this.getLayerFlags().contains((Object)LayerFlags.IC2_ENET);
    }

    private TileEntity getEnergySourceTile() {
        IPartHost host = (IPartHost)((Object)this);
        return host.getTile();
    }

    private World getEnergySourceWorld() {
        if (this.getEnergySourceTile() == null) {
            return null;
        }
        return this.getEnergySourceTile().func_145831_w();
    }

    private boolean isTileValid() {
        TileEntity te = this.getEnergySourceTile();
        if (te == null) {
            return false;
        }
        return !te.func_145837_r();
    }

    private final void addToENet() {
        if (this.getEnergySourceWorld() == null) {
            return;
        }
        this.removeFromENet();
        if (!this.isInIC2() && Platform.isServer() && this.isTileValid()) {
            this.getLayerFlags().add(LayerFlags.IC2_ENET);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)((IEnergySink)this.getEnergySourceTile())));
        }
    }

    private final void removeFromENet() {
        if (this.getEnergySourceWorld() == null) {
            return;
        }
        if (this.isInIC2() && Platform.isServer()) {
            this.getLayerFlags().remove((Object)LayerFlags.IC2_ENET);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)((IEnergySink)this.getEnergySourceTile())));
        }
    }

    private final boolean interestedInIC2() {
        if (!((IPartHost)((Object)this)).isInWorld()) {
            return false;
        }
        int interested = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergyTile)) continue;
            ++interested;
        }
        return interested == 1;
    }

    @Override
    public void partChanged() {
        super.partChanged();
        if (this.interestedInIC2()) {
            this.addToENet();
        } else {
            this.removeFromENet();
        }
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        if (!this.isInIC2()) {
            return false;
        }
        IPart part = this.getPart(direction);
        if (part instanceof IEnergySink) {
            return ((IEnergyEmitter)part).emitsEnergyTo(receiver, direction);
        }
        return false;
    }

    public double getOfferedEnergy() {
        if (!this.isInIC2()) {
            return 0.0;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergySource)) continue;
            return ((IEnergySource)part).getOfferedEnergy();
        }
        return 0.0;
    }

    public void drawEnergy(double amount) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergySource)) continue;
            ((IEnergySource)part).drawEnergy(amount);
            return;
        }
    }

    public int getSourceTier() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergySource)) continue;
            return ((IEnergySource)part).getSourceTier();
        }
        return 0;
    }
}

