/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.layers;

import appeng.api.parts.IPart;
import appeng.api.parts.LayerBase;
import appeng.parts.layers.InvSot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class LayerISidedInventory
extends LayerBase
implements ISidedInventory {
    private static final int[] nullSides = new int[0];
    private int[][] sides = null;
    private List<ISidedInventory> invs = null;
    private List<InvSot> slots = null;

    @Override
    public void notifyNeighbors() {
        this.invs = new ArrayList<ISidedInventory>();
        int slotCount = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IPart bp = this.getPart(side);
            if (!(bp instanceof ISidedInventory)) continue;
            ISidedInventory part = (ISidedInventory)bp;
            slotCount += part.func_70302_i_();
            this.invs.add(part);
        }
        if (this.invs.isEmpty() || slotCount == 0) {
            this.invs = null;
            this.sides = null;
            this.slots = null;
        } else {
            this.sides = new int[][]{nullSides, nullSides, nullSides, nullSides, nullSides, nullSides};
            this.slots = new ArrayList<InvSot>(Collections.nCopies(slotCount, null));
            int offsetForLayer = 0;
            int offsetForPart = 0;
            for (ISidedInventory sides : this.invs) {
                offsetForPart = 0;
                slotCount = sides.func_70302_i_();
                ForgeDirection currentSide = ForgeDirection.UNKNOWN;
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    if (this.getPart(side) != sides) continue;
                    currentSide = side;
                    break;
                }
                int[] nArray = new int[slotCount];
                this.sides[currentSide.ordinal()] = nArray;
                int[] cSidesList = nArray;
                for (int cSlot = 0; cSlot < slotCount; ++cSlot) {
                    cSidesList[cSlot] = offsetForLayer;
                    this.slots.set(offsetForLayer++, new InvSot(sides, offsetForPart++));
                }
            }
        }
        super.notifyNeighbors();
    }

    boolean isSlotValid(int slot) {
        return this.slots != null && slot >= 0 && slot < this.slots.size();
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.isSlotValid(slot)) {
            return this.slots.get(slot).decrStackSize(amount);
        }
        return null;
    }

    public int func_70302_i_() {
        if (this.slots == null) {
            return 0;
        }
        return this.slots.size();
    }

    public ItemStack func_70301_a(int slot) {
        if (this.isSlotValid(slot)) {
            return this.slots.get(slot).getStackInSlot();
        }
        return null;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (this.isSlotValid(slot)) {
            return this.slots.get(slot).isItemValidForSlot(itemstack);
        }
        return false;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        if (this.isSlotValid(slot)) {
            this.slots.get(slot).setInventorySlotContents(itemstack);
        }
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        if (this.isSlotValid(slot)) {
            return this.slots.get(slot).canExtractItem(itemstack, side);
        }
        return false;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (this.isSlotValid(slot)) {
            return this.slots.get(slot).canInsertItem(itemstack, side);
        }
        return false;
    }

    public void func_70296_d() {
        super.markForSave();
        if (this.invs != null) {
            for (IInventory iInventory : this.invs) {
                iInventory.func_70296_d();
            }
        }
    }

    public int[] func_94128_d(int side) {
        if (this.sides == null || side < 0 || side > 5) {
            return nullSides;
        }
        return this.sides[side];
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_145825_b() {
        return "AEMultiPart";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70305_f() {
    }

    public void func_70295_k_() {
    }
}

