/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.misc;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollsionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IExternalStorageHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.client.texture.CableBusTextures;
import appeng.core.settings.TickRates;
import appeng.core.sync.GuiBridge;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.MEMonitorIInventory;
import appeng.parts.automation.PartUpgradeable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.InvOperation;
import appeng.transformer.annotations.integration;
import appeng.util.Platform;
import appeng.util.prioitylist.FuzzyPriorityList;
import appeng.util.prioitylist.PrecisePriorityList;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

@integration.Interface(iname="BC", iface="buildcraft.api.transport.IPipeConnection")
public class PartStorageBus
extends PartUpgradeable
implements IGridTickable,
ICellContainer,
IMEMonitorHandlerReceiver<IAEItemStack>,
IPipeConnection,
IPriorityHost {
    int priority = 0;
    BaseActionSource mySrc;
    AppEngInternalAEInventory Config = new AppEngInternalAEInventory(this, 63);
    boolean cached = false;
    MEMonitorIInventory monitor = null;
    MEInventoryHandler handler = null;
    int handlerHash = 0;
    boolean wasActive = false;
    private byte resetCacheLogic = 0;

    public PartStorageBus(ItemStack is) {
        super(PartStorageBus.class, is);
        this.getConfigManager().registerSetting(Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.STORAGE_FILTER, StorageFilter.EXTACTABLE_ONLY);
        this.mySrc = new MachineSource(this);
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.updateStatus();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged chann) {
        this.updateStatus();
    }

    private void updateStatus() {
        boolean currentActive = this.proxy.isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.proxy.getGrid().postEvent(new MENetworkCellArrayUpdate());
                this.host.markForUpdate();
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.side, GuiBridge.GUI_STORAGEBUS);
            return true;
        }
        return false;
    }

    @Override
    protected int getUpgradeSlots() {
        return 5;
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return this.handler == verificationToken;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.Config;
        }
        return super.getInventoryByName(name);
    }

    private void resetCache(boolean fullReset) {
        if (this.host == null || this.host.getTile() == null || this.host.getTile().func_145831_w() == null || this.host.getTile().func_145831_w().field_72995_K) {
            return;
        }
        this.resetCacheLogic = fullReset ? (byte)2 : (byte)1;
        try {
            this.proxy.getTick().alertDevice(this.proxy.getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void resetCache() {
        boolean fullReset = this.resetCacheLogic == 2;
        this.resetCacheLogic = 0;
        MEInventoryHandler in = this.getInternalHandler();
        IItemList<IAEItemStack> before = AEApi.instance().storage().createItemList();
        if (in != null) {
            before = in.getAvailableItems(before);
        }
        this.cached = false;
        if (fullReset) {
            this.handlerHash = 0;
        }
        MEInventoryHandler out = this.getInternalHandler();
        if (this.monitor != null) {
            this.monitor.onTick();
        }
        IItemList<IAEItemStack> after = AEApi.instance().storage().createItemList();
        if (out != null) {
            after = out.getAvailableItems(after);
        }
        Platform.postListChanges(before, after, this, this.mySrc);
    }

    @Override
    public void onNeighborChanged() {
        this.resetCache(false);
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.Config) {
            this.resetCache(true);
        }
    }

    @Override
    public void upgradesChanged() {
        super.upgradesChanged();
        this.resetCache(true);
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.resetCache(true);
        this.host.markForSave();
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.host.markForSave();
        this.resetCache(true);
    }

    public MEInventoryHandler getInternalHandler() {
        IExternalStorageHandler esh;
        if (this.cached) {
            return this.handler;
        }
        boolean wasSleeping = this.monitor == null;
        this.cached = true;
        TileEntity self = this.getHost().getTile();
        TileEntity target = self.func_145831_w().func_147438_o(self.field_145851_c + this.side.offsetX, self.field_145848_d + this.side.offsetY, self.field_145849_e + this.side.offsetZ);
        int newHandlerHash = Platform.generateTileHash(target);
        if (this.handlerHash == newHandlerHash && this.handlerHash != 0) {
            return this.handler;
        }
        try {
            this.proxy.getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException e) {
            // empty catch block
        }
        this.handlerHash = newHandlerHash;
        this.handler = null;
        this.monitor = null;
        if (target != null && (esh = AEApi.instance().registries().externalStorage().getHandler(target, this.side.getOpposite(), StorageChannel.ITEMS, this.mySrc)) != null) {
            IMEInventory inv = esh.getInventory(target, this.side.getOpposite(), StorageChannel.ITEMS, this.mySrc);
            if (inv instanceof MEMonitorIInventory) {
                MEMonitorIInventory h = (MEMonitorIInventory)inv;
                h.mode = (StorageFilter)this.getConfigManager().getSetting(Settings.STORAGE_FILTER);
                h.mySource = new MachineSource(this);
            }
            if (inv instanceof MEMonitorIInventory) {
                this.monitor = (MEMonitorIInventory)inv;
            }
            if (inv != null) {
                this.handler = new MEInventoryHandler(inv, StorageChannel.ITEMS);
                this.handler.myAccess = (AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS);
                this.handler.myWhitelist = this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
                this.handler.myPriority = this.priority;
                IItemList<IAEItemStack> priorityList = AEApi.instance().storage().createItemList();
                int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
                for (int x = 0; x < this.Config.func_70302_i_() && x < slotsToUse; ++x) {
                    IAEItemStack is = this.Config.getAEStackInSlot(x);
                    if (is == null) continue;
                    priorityList.add(is);
                }
                this.handler.myPartitionList = this.getInstalledUpgrades(Upgrades.FUZZY) > 0 ? new FuzzyPriorityList<IAEItemStack>(priorityList, (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE)) : new PrecisePriorityList<IAEItemStack>(priorityList);
                if (inv instanceof IMEMonitor) {
                    ((IMEMonitor)inv).addListener(this, this.handler);
                }
            }
        }
        if (wasSleeping != (this.monitor == null)) {
            try {
                ITickManager tm = this.proxy.getTick();
                if (this.monitor == null) {
                    tm.sleepDevice(this.proxy.getNode());
                } else {
                    tm.wakeDevice(this.proxy.getNode());
                }
            }
            catch (GridAccessException e) {
                // empty catch block
            }
        }
        return this.handler;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon());
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.renderCache = rh.useSimpliedRendering(x, y, z, this, this.renderCache);
        rh.setTexture(CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon());
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartStorageSides.getIcon(), CableBusTextures.PartStorageSides.getIcon());
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.is.func_77954_c(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public void getBoxes(IPartCollsionHelper bch) {
        bch.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 4;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.StorageBus.min, TickRates.StorageBus.max, this.monitor == null, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.resetCacheLogic != 0) {
            this.resetCache();
        }
        if (this.monitor != null) {
            return this.monitor.onTick();
        }
        return TickRateModulation.SLEEP;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.Config.writeToNBT(data, "config");
        data.func_74768_a("priority", this.priority);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.Config.readFromNBT(data, "config");
        this.priority = data.func_74762_e("priority");
    }

    @Override
    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (channel == StorageChannel.ITEMS) {
            MEInventoryHandler out;
            MEInventoryHandler mEInventoryHandler = out = this.proxy.isActive() ? this.getInternalHandler() : null;
            if (out != null) {
                return Arrays.asList(out);
            }
        }
        return Arrays.asList(new IMEInventoryHandler[0]);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void blinkCell(int slot) {
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource source) {
        try {
            if (this.proxy.isActive()) {
                this.proxy.getStorage().postAlterationOfStoredItems(StorageChannel.ITEMS, change, this.mySrc);
            }
        }
        catch (GridAccessException e) {
            // empty catch block
        }
    }

    @integration.Method(iname="BC")
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.ITEM && with == this.side ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public void onListUpdate() {
    }

    @Override
    public void saveChanges(IMEInventory cellInventory) {
    }
}

