/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.parts.IPartCable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollsionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.IReadOnlyCollection;
import appeng.block.AEBaseBlock;
import appeng.client.texture.CableBusTextures;
import appeng.client.texture.FlipableIcon;
import appeng.client.texture.TaughtIcon;
import appeng.items.parts.ItemMultiPart;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.EnumSet;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class PartCable
extends AEBasePart
implements IPartCable {
    int[] channelsOnSide = new int[]{0, 0, 0, 0, 0, 0};
    EnumSet<ForgeDirection> connections = EnumSet.noneOf(ForgeDirection.class);
    boolean powered = false;

    public PartCable(Class c, ItemStack is) {
        super(c, is);
        this.proxy.setFlags(GridFlags.PREFERED);
        this.proxy.setIdlePowerUsage(0.0);
        this.proxy.myColor = AEColor.values()[((ItemMultiPart)is.func_77973_b()).varientOf(is.func_77960_j())];
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        return this.connections.contains(side);
    }

    @Override
    public BusSupport supportsBuses() {
        return BusSupport.CABLE;
    }

    public IIcon getGlassTexture(AEColor c) {
        switch (c) {
            case Black: {
                return CableBusTextures.MECable_Black.getIcon();
            }
            case Blue: {
                return CableBusTextures.MECable_Blue.getIcon();
            }
            case Brown: {
                return CableBusTextures.MECable_Brown.getIcon();
            }
            case Cyan: {
                return CableBusTextures.MECable_Cyan.getIcon();
            }
            case Gray: {
                return CableBusTextures.MECable_Grey.getIcon();
            }
            case Green: {
                return CableBusTextures.MECable_Green.getIcon();
            }
            case LightBlue: {
                return CableBusTextures.MECable_LightBlue.getIcon();
            }
            case LightGray: {
                return CableBusTextures.MECable_LightGrey.getIcon();
            }
            case Lime: {
                return CableBusTextures.MECable_Lime.getIcon();
            }
            case Magenta: {
                return CableBusTextures.MECable_Magenta.getIcon();
            }
            case Orange: {
                return CableBusTextures.MECable_Orange.getIcon();
            }
            case Pink: {
                return CableBusTextures.MECable_Pink.getIcon();
            }
            case Purple: {
                return CableBusTextures.MECable_Purple.getIcon();
            }
            case Red: {
                return CableBusTextures.MECable_Red.getIcon();
            }
            case White: {
                return CableBusTextures.MECable_White.getIcon();
            }
            case Yellow: {
                return CableBusTextures.MECable_Yellow.getIcon();
            }
        }
        return AEApi.instance().parts().partCableGlass.item(AEColor.Transparent).func_77650_f(AEApi.instance().parts().partCableGlass.stack(AEColor.Transparent, 1));
    }

    public IIcon getTexture(AEColor c) {
        return this.getGlassTexture(c);
    }

    public IIcon getCoveredTexture(AEColor c) {
        switch (c) {
            case Black: {
                return CableBusTextures.MECovered_Black.getIcon();
            }
            case Blue: {
                return CableBusTextures.MECovered_Blue.getIcon();
            }
            case Brown: {
                return CableBusTextures.MECovered_Brown.getIcon();
            }
            case Cyan: {
                return CableBusTextures.MECovered_Cyan.getIcon();
            }
            case Gray: {
                return CableBusTextures.MECovered_Gray.getIcon();
            }
            case Green: {
                return CableBusTextures.MECovered_Green.getIcon();
            }
            case LightBlue: {
                return CableBusTextures.MECovered_LightBlue.getIcon();
            }
            case LightGray: {
                return CableBusTextures.MECovered_LightGrey.getIcon();
            }
            case Lime: {
                return CableBusTextures.MECovered_Lime.getIcon();
            }
            case Magenta: {
                return CableBusTextures.MECovered_Magenta.getIcon();
            }
            case Orange: {
                return CableBusTextures.MECovered_Orange.getIcon();
            }
            case Pink: {
                return CableBusTextures.MECovered_Pink.getIcon();
            }
            case Purple: {
                return CableBusTextures.MECovered_Purple.getIcon();
            }
            case Red: {
                return CableBusTextures.MECovered_Red.getIcon();
            }
            case White: {
                return CableBusTextures.MECovered_White.getIcon();
            }
            case Yellow: {
                return CableBusTextures.MECovered_Yellow.getIcon();
            }
        }
        return AEApi.instance().parts().partCableCovered.item(AEColor.Transparent).func_77650_f(AEApi.instance().parts().partCableCovered.stack(AEColor.Transparent, 1));
    }

    public IIcon getSmartTexture(AEColor c) {
        switch (c) {
            case Black: {
                return CableBusTextures.MESmart_Black.getIcon();
            }
            case Blue: {
                return CableBusTextures.MESmart_Blue.getIcon();
            }
            case Brown: {
                return CableBusTextures.MESmart_Brown.getIcon();
            }
            case Cyan: {
                return CableBusTextures.MESmart_Cyan.getIcon();
            }
            case Gray: {
                return CableBusTextures.MESmart_Gray.getIcon();
            }
            case Green: {
                return CableBusTextures.MESmart_Green.getIcon();
            }
            case LightBlue: {
                return CableBusTextures.MESmart_LightBlue.getIcon();
            }
            case LightGray: {
                return CableBusTextures.MESmart_LightGrey.getIcon();
            }
            case Lime: {
                return CableBusTextures.MESmart_Lime.getIcon();
            }
            case Magenta: {
                return CableBusTextures.MESmart_Magenta.getIcon();
            }
            case Orange: {
                return CableBusTextures.MESmart_Orange.getIcon();
            }
            case Pink: {
                return CableBusTextures.MESmart_Pink.getIcon();
            }
            case Purple: {
                return CableBusTextures.MESmart_Purple.getIcon();
            }
            case Red: {
                return CableBusTextures.MESmart_Red.getIcon();
            }
            case White: {
                return CableBusTextures.MESmart_White.getIcon();
            }
            case Yellow: {
                return CableBusTextures.MESmart_Yellow.getIcon();
            }
        }
        return AEApi.instance().parts().partCableCovered.item(AEColor.Transparent).func_77650_f(AEApi.instance().parts().partCableSmart.stack(AEColor.Transparent, 1));
    }

    @Override
    public AEColor getCableColor() {
        return this.proxy.myColor;
    }

    @Override
    public AECableType getCableConnectionType() {
        return AECableType.GLASS;
    }

    @Override
    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    public void markForUpdate() {
        this.getHost().markForUpdate();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (Platform.isServer()) {
            IGridNode node = this.getGridNode();
            int howMany = 0;
            if (node != null) {
                for (IGridConnection gc : node.getConnections()) {
                    howMany = Math.max(gc.getUsedChannels(), howMany);
                }
                data.func_74774_a("usedChannels", (byte)howMany);
            }
        }
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        int cs = 0;
        int sideOut = 0;
        IGridNode n = this.getGridNode();
        if (n != null) {
            for (ForgeDirection thisSide : ForgeDirection.VALID_DIRECTIONS) {
                IPart part = this.getHost().getPart(thisSide);
                if (part == null || part.getGridNode() == null) continue;
                IReadOnlyCollection<IGridConnection> set = part.getGridNode().getConnections();
                for (IGridConnection gc : set) {
                    if (this.proxy.getNode().hasFlag(GridFlags.DENSE_CAPACITY) && gc.getOtherSide(this.proxy.getNode()).hasFlag(GridFlags.DENSE_CAPACITY)) {
                        sideOut |= gc.getUsedChannels() / 4 << 4 * thisSide.ordinal();
                        continue;
                    }
                    sideOut |= gc.getUsedChannels() << 4 * thisSide.ordinal();
                }
            }
            for (IGridConnection gc : n.getConnections()) {
                ForgeDirection side = gc.getDirection(n);
                if (side == ForgeDirection.UNKNOWN) continue;
                boolean isTier2a = this.proxy.getNode().hasFlag(GridFlags.DENSE_CAPACITY);
                boolean isTier2b = gc.getOtherSide(this.proxy.getNode()).hasFlag(GridFlags.DENSE_CAPACITY);
                sideOut = isTier2a && isTier2b ? (sideOut |= gc.getUsedChannels() / 4 << 4 * side.ordinal()) : (sideOut |= gc.getUsedChannels() << 4 * side.ordinal());
                cs |= 1 << side.ordinal();
            }
        }
        try {
            if (this.proxy.getEnergy().isNetworkPowered()) {
                cs |= 1 << ForgeDirection.UNKNOWN.ordinal();
            }
        }
        catch (GridAccessException e) {
            // empty catch block
        }
        data.writeByte((int)((byte)cs));
        data.writeInt(sideOut);
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        byte cs = data.readByte();
        int sideOut = data.readInt();
        Object myC = this.connections.clone();
        boolean wasPowered = this.powered;
        this.powered = false;
        boolean chchanged = false;
        for (ForgeDirection d : ForgeDirection.values()) {
            int id;
            int ch;
            if (d != ForgeDirection.UNKNOWN && (ch = sideOut >> d.ordinal() * 4 & 0xF) != this.channelsOnSide[d.ordinal()]) {
                chchanged = true;
                this.channelsOnSide[d.ordinal()] = ch;
            }
            if (d == ForgeDirection.UNKNOWN) {
                id = 1 << d.ordinal();
                if (id != (cs & id)) continue;
                this.powered = true;
                continue;
            }
            id = 1 << d.ordinal();
            if (id == (cs & id)) {
                this.connections.add(d);
                continue;
            }
            this.connections.remove(d);
        }
        return !((AbstractSet)myC).equals(this.connections) || wasPowered != this.powered || chchanged;
    }

    @Override
    public void getBoxes(IPartCollsionHelper bch) {
        IPartHost ph;
        bch.addBox(6.0, 6.0, 6.0, 10.0, 10.0, 10.0);
        if (Platform.isServer()) {
            IGridNode n = this.getGridNode();
            if (n != null) {
                this.connections = n.getConnectedSides();
            } else {
                this.connections.clear();
            }
        }
        if ((ph = this.getHost()) != null) {
            block16: for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                double dist;
                IPart p = ph.getPart(dir);
                if (!(p instanceof IGridHost) || (dist = (double)p.cableConnectionRenderTo()) > 8.0) continue;
                switch (dir) {
                    case DOWN: {
                        bch.addBox(6.0, dist, 6.0, 10.0, 6.0, 10.0);
                        continue block16;
                    }
                    case EAST: {
                        bch.addBox(10.0, 6.0, 6.0, 16.0 - dist, 10.0, 10.0);
                        continue block16;
                    }
                    case NORTH: {
                        bch.addBox(6.0, 6.0, dist, 10.0, 10.0, 6.0);
                        continue block16;
                    }
                    case SOUTH: {
                        bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0 - dist);
                        continue block16;
                    }
                    case UP: {
                        bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0 - dist, 10.0);
                        continue block16;
                    }
                    case WEST: {
                        bch.addBox(dist, 6.0, 6.0, 6.0, 10.0, 10.0);
                        continue block16;
                    }
                    default: {
                        continue block16;
                    }
                }
            }
        }
        block17: for (ForgeDirection of : this.connections) {
            switch (of) {
                case DOWN: {
                    bch.addBox(6.0, 0.0, 6.0, 10.0, 6.0, 10.0);
                    continue block17;
                }
                case EAST: {
                    bch.addBox(10.0, 6.0, 6.0, 16.0, 10.0, 10.0);
                    continue block17;
                }
                case NORTH: {
                    bch.addBox(6.0, 6.0, 0.0, 10.0, 10.0, 6.0);
                    continue block17;
                }
                case SOUTH: {
                    bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0);
                    continue block17;
                }
                case UP: {
                    bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0, 10.0);
                    continue block17;
                }
                case WEST: {
                    bch.addBox(0.0, 6.0, 6.0, 6.0, 10.0, 10.0);
                    continue block17;
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        GL11.glTranslated((double)-0.0, (double)-0.0, (double)0.3);
        rh.setTexture(this.getTexture(this.getCableColor()));
        rh.setBounds(6.0f, 6.0f, 2.0f, 10.0f, 10.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBreakingTexture() {
        return this.getTexture(this.getCableColor());
    }

    @SideOnly(value=Side.CLIENT)
    public void rendereGlassConection(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer, ForgeDirection of) {
        TileEntity te = this.tile.func_145831_w().func_147438_o(x + of.offsetX, y + of.offsetY, z + of.offsetZ);
        IPartHost ccph = te instanceof IPartHost ? (IPartHost)te : null;
        IGridHost gh = te instanceof IGridHost ? (IGridHost)te : null;
        rh.setFacesToRender(EnumSet.complementOf(EnumSet.of(of)));
        if (gh != null && ccph != null && gh.getCableConnectionType(of) == AECableType.GLASS && ccph.getColor() != AEColor.Transparent && ccph.getPart(of.getOpposite()) == null) {
            rh.setTexture(this.getTexture(ccph.getColor()));
        } else if (ccph == null && gh != null && gh.getCableConnectionType(of) != AECableType.GLASS) {
            rh.setTexture(this.getCoveredTexture(this.getCableColor()));
            switch (of) {
                case DOWN: {
                    rh.setBounds(5.0f, 0.0f, 5.0f, 11.0f, 4.0f, 11.0f);
                    break;
                }
                case EAST: {
                    rh.setBounds(12.0f, 5.0f, 5.0f, 16.0f, 11.0f, 11.0f);
                    break;
                }
                case NORTH: {
                    rh.setBounds(5.0f, 5.0f, 0.0f, 11.0f, 11.0f, 4.0f);
                    break;
                }
                case SOUTH: {
                    rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 16.0f);
                    break;
                }
                case UP: {
                    rh.setBounds(5.0f, 12.0f, 5.0f, 11.0f, 16.0f, 11.0f);
                    break;
                }
                case WEST: {
                    rh.setBounds(0.0f, 5.0f, 5.0f, 4.0f, 11.0f, 11.0f);
                    break;
                }
                default: {
                    return;
                }
            }
            rh.renderBlock(x, y, z, renderer);
            rh.setTexture(this.getTexture(this.getCableColor()));
        } else {
            rh.setTexture(this.getTexture(this.getCableColor()));
        }
        switch (of) {
            case DOWN: {
                rh.setBounds(6.0f, 0.0f, 6.0f, 10.0f, 6.0f, 10.0f);
                break;
            }
            case EAST: {
                rh.setBounds(10.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
                break;
            }
            case NORTH: {
                rh.setBounds(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 6.0f);
                break;
            }
            case SOUTH: {
                rh.setBounds(6.0f, 6.0f, 10.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case UP: {
                rh.setBounds(6.0f, 10.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case WEST: {
                rh.setBounds(0.0f, 6.0f, 6.0f, 6.0f, 10.0f, 10.0f);
                break;
            }
            default: {
                return;
            }
        }
        rh.renderBlock(x, y, z, renderer);
        rh.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
    }

    protected CableBusTextures getChannelTex(int i, boolean b) {
        if (!this.powered) {
            i = 0;
        }
        if (b) {
            switch (i) {
                default: {
                    return CableBusTextures.Channels10;
                }
                case 5: {
                    return CableBusTextures.Channels11;
                }
                case 6: {
                    return CableBusTextures.Channels12;
                }
                case 7: {
                    return CableBusTextures.Channels13;
                }
                case 8: 
            }
            return CableBusTextures.Channels14;
        }
        switch (i) {
            case 0: {
                return CableBusTextures.Channels00;
            }
            case 1: {
                return CableBusTextures.Channels01;
            }
            case 2: {
                return CableBusTextures.Channels02;
            }
            case 3: {
                return CableBusTextures.Channels03;
            }
        }
        return CableBusTextures.Channels04;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCoveredConection(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer, int channels, ForgeDirection of) {
        TileEntity te = this.tile.func_145831_w().func_147438_o(x + of.offsetX, y + of.offsetY, z + of.offsetZ);
        IPartHost ccph = te instanceof IPartHost ? (IPartHost)te : null;
        IGridHost ghh = te instanceof IGridHost ? (IGridHost)te : null;
        boolean isSmart = false;
        rh.setFacesToRender(EnumSet.complementOf(EnumSet.of(of)));
        if (ghh != null && ccph != null && ghh.getCableConnectionType(of.getOpposite()) == AECableType.GLASS && ccph.getPart(of.getOpposite()) == null && ccph.getColor() != AEColor.Transparent) {
            rh.setTexture(this.getGlassTexture(ccph.getColor()));
        } else if (ccph == null && ghh != null && ghh.getCableConnectionType(of) != AECableType.GLASS) {
            rh.setTexture(this.getCoveredTexture(this.getCableColor()));
            switch (of) {
                case DOWN: {
                    rh.setBounds(5.0f, 0.0f, 5.0f, 11.0f, 4.0f, 11.0f);
                    break;
                }
                case EAST: {
                    rh.setBounds(12.0f, 5.0f, 5.0f, 16.0f, 11.0f, 11.0f);
                    break;
                }
                case NORTH: {
                    rh.setBounds(5.0f, 5.0f, 0.0f, 11.0f, 11.0f, 4.0f);
                    break;
                }
                case SOUTH: {
                    rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 16.0f);
                    break;
                }
                case UP: {
                    rh.setBounds(5.0f, 12.0f, 5.0f, 11.0f, 16.0f, 11.0f);
                    break;
                }
                case WEST: {
                    rh.setBounds(0.0f, 5.0f, 5.0f, 4.0f, 11.0f, 11.0f);
                    break;
                }
                default: {
                    return;
                }
            }
            rh.renderBlock(x, y, z, renderer);
            rh.setTexture(this.getTexture(this.getCableColor()));
        } else if (ghh != null && ccph != null && ghh.getCableConnectionType(of) == AECableType.COVERED && ccph.getColor() != AEColor.Transparent && ccph.getPart(of.getOpposite()) == null) {
            rh.setTexture(this.getCoveredTexture(ccph.getColor()));
        } else if (ghh != null && ccph != null && ghh.getCableConnectionType(of) == AECableType.SMART && ccph.getPart(of.getOpposite()) == null) {
            isSmart = true;
            rh.setTexture(this.getSmartTexture(this.getCableColor()));
        } else {
            rh.setTexture(this.getCoveredTexture(this.getCableColor()));
        }
        switch (of) {
            case DOWN: {
                rh.setBounds(6.0f, 0.0f, 6.0f, 10.0f, 5.0f, 10.0f);
                break;
            }
            case EAST: {
                rh.setBounds(11.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
                break;
            }
            case NORTH: {
                rh.setBounds(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 5.0f);
                break;
            }
            case SOUTH: {
                rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case UP: {
                rh.setBounds(6.0f, 11.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case WEST: {
                rh.setBounds(0.0f, 6.0f, 6.0f, 5.0f, 10.0f, 10.0f);
                break;
            }
            default: {
                return;
            }
        }
        rh.renderBlock(x, y, z, renderer);
        rh.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
        if (isSmart) {
            this.setSmartConnectionRotations(of, renderer);
            TaughtIcon defa = new TaughtIcon(this.getChannelTex(channels, false).getIcon(), -0.2f);
            TaughtIcon defb = new TaughtIcon(this.getChannelTex(channels, true).getIcon(), -0.2f);
            if (of == ForgeDirection.EAST || of == ForgeDirection.WEST) {
                AEBaseBlock blk = (AEBaseBlock)rh.getBlock();
                FlipableIcon ico = blk.getRendererInstance().getTexture(ForgeDirection.EAST);
                ico.setFlip(false, true);
            }
            Tessellator.field_78398_a.func_78380_c(0xF000F0);
            Tessellator.field_78398_a.func_78378_d(this.getCableColor().blackVariant);
            rh.setTexture(defa, defa, defa, defa, defa, defa);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            Tessellator.field_78398_a.func_78378_d(this.getCableColor().whiteVariant);
            rh.setTexture(defb, defb, defb, defb, defb, defb);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            renderer.field_147873_r = 0;
            renderer.field_147867_u = 0;
            renderer.field_147871_s = 0;
            renderer.field_147869_t = 0;
            renderer.field_147875_q = 0;
            renderer.field_147865_v = 0;
        }
        rh.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSmartConection(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer, int channels, ForgeDirection of) {
        TaughtIcon defb;
        TaughtIcon defa;
        TileEntity te = this.tile.func_145831_w().func_147438_o(x + of.offsetX, y + of.offsetY, z + of.offsetZ);
        IPartHost ccph = te instanceof IPartHost ? (IPartHost)te : null;
        IGridHost ghh = te instanceof IGridHost ? (IGridHost)te : null;
        boolean isGlass = false;
        AEColor myColor = this.getCableColor();
        rh.setFacesToRender(EnumSet.complementOf(EnumSet.of(of)));
        if (ghh != null && ccph != null && ghh.getCableConnectionType(of.getOpposite()) == AECableType.GLASS && ccph.getPart(of.getOpposite()) == null && ccph.getColor() != AEColor.Transparent) {
            isGlass = true;
            myColor = ccph.getColor();
            rh.setTexture(this.getGlassTexture(myColor));
        } else if (ccph == null && ghh != null && ghh.getCableConnectionType(of.getOpposite()) != AECableType.GLASS) {
            rh.setTexture(this.getSmartTexture(myColor));
            switch (of) {
                case DOWN: {
                    rh.setBounds(5.0f, 0.0f, 5.0f, 11.0f, 4.0f, 11.0f);
                    break;
                }
                case EAST: {
                    rh.setBounds(12.0f, 5.0f, 5.0f, 16.0f, 11.0f, 11.0f);
                    break;
                }
                case NORTH: {
                    rh.setBounds(5.0f, 5.0f, 0.0f, 11.0f, 11.0f, 4.0f);
                    break;
                }
                case SOUTH: {
                    rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 16.0f);
                    break;
                }
                case UP: {
                    rh.setBounds(5.0f, 12.0f, 5.0f, 11.0f, 16.0f, 11.0f);
                    break;
                }
                case WEST: {
                    rh.setBounds(0.0f, 5.0f, 5.0f, 4.0f, 11.0f, 11.0f);
                    break;
                }
                default: {
                    return;
                }
            }
            rh.renderBlock(x, y, z, renderer);
            this.setSmartConnectionRotations(of, renderer);
            defa = new TaughtIcon(this.getChannelTex(channels, false).getIcon(), -0.2f);
            defb = new TaughtIcon(this.getChannelTex(channels, true).getIcon(), -0.2f);
            if (of == ForgeDirection.EAST || of == ForgeDirection.WEST) {
                AEBaseBlock blk = (AEBaseBlock)rh.getBlock();
                FlipableIcon ico = blk.getRendererInstance().getTexture(ForgeDirection.EAST);
                ico.setFlip(false, true);
            }
            Tessellator.field_78398_a.func_78380_c(0xF000F0);
            Tessellator.field_78398_a.func_78378_d(myColor.blackVariant);
            rh.setTexture(defa, defa, defa, defa, defa, defa);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            Tessellator.field_78398_a.func_78378_d(myColor.whiteVariant);
            rh.setTexture(defb, defb, defb, defb, defb, defb);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            renderer.field_147873_r = 0;
            renderer.field_147867_u = 0;
            renderer.field_147871_s = 0;
            renderer.field_147869_t = 0;
            renderer.field_147875_q = 0;
            renderer.field_147865_v = 0;
            rh.setTexture(this.getTexture(this.getCableColor()));
        } else if (ghh != null && ccph != null && ghh.getCableConnectionType(of) != AECableType.GLASS && ccph.getColor() != AEColor.Transparent && ccph.getPart(of.getOpposite()) == null) {
            myColor = ccph.getColor();
            rh.setTexture(this.getSmartTexture(myColor));
        } else {
            rh.setTexture(this.getSmartTexture(this.getCableColor()));
        }
        switch (of) {
            case DOWN: {
                rh.setBounds(6.0f, 0.0f, 6.0f, 10.0f, 5.0f, 10.0f);
                break;
            }
            case EAST: {
                rh.setBounds(11.0f, 6.0f, 6.0f, 16.0f, 10.0f, 10.0f);
                break;
            }
            case NORTH: {
                rh.setBounds(6.0f, 6.0f, 0.0f, 10.0f, 10.0f, 5.0f);
                break;
            }
            case SOUTH: {
                rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 16.0f);
                break;
            }
            case UP: {
                rh.setBounds(6.0f, 11.0f, 6.0f, 10.0f, 16.0f, 10.0f);
                break;
            }
            case WEST: {
                rh.setBounds(0.0f, 6.0f, 6.0f, 5.0f, 10.0f, 10.0f);
                break;
            }
            default: {
                return;
            }
        }
        rh.renderBlock(x, y, z, renderer);
        rh.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
        if (!isGlass) {
            this.setSmartConnectionRotations(of, renderer);
            defa = new TaughtIcon(this.getChannelTex(channels, false).getIcon(), -0.2f);
            defb = new TaughtIcon(this.getChannelTex(channels, true).getIcon(), -0.2f);
            Tessellator.field_78398_a.func_78380_c(0xF000F0);
            Tessellator.field_78398_a.func_78378_d(myColor.blackVariant);
            rh.setTexture(defa, defa, defa, defa, defa, defa);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            Tessellator.field_78398_a.func_78378_d(myColor.whiteVariant);
            rh.setTexture(defb, defb, defb, defb, defb, defb);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            renderer.field_147873_r = 0;
            renderer.field_147867_u = 0;
            renderer.field_147871_s = 0;
            renderer.field_147869_t = 0;
            renderer.field_147875_q = 0;
            renderer.field_147865_v = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void setSmartConnectionRotations(ForgeDirection of, RenderBlocks renderer) {
        switch (of) {
            case DOWN: 
            case UP: {
                renderer.field_147867_u = 0;
                renderer.field_147865_v = 0;
                renderer.field_147871_s = 3;
                renderer.field_147875_q = 3;
                break;
            }
            case NORTH: 
            case SOUTH: {
                renderer.field_147867_u = 3;
                renderer.field_147865_v = 3;
                renderer.field_147869_t = 1;
                renderer.field_147871_s = 2;
                renderer.field_147873_r = 1;
                break;
            }
            case EAST: 
            case WEST: {
                renderer.field_147875_q = 2;
                renderer.field_147873_r = 1;
                renderer.field_147865_v = 2;
                renderer.field_147867_u = 1;
                renderer.field_147871_s = 3;
                renderer.field_147869_t = 0;
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderAllFaces(AEBaseBlock blk, int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setBounds((float)renderer.field_147859_h * 16.0f, (float)renderer.field_147855_j * 16.0f, (float)renderer.field_147851_l * 16.0f, (float)renderer.field_147861_i * 16.0f, (float)renderer.field_147857_k * 16.0f, (float)renderer.field_147853_m * 16.0f);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.WEST), ForgeDirection.WEST, renderer);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.EAST), ForgeDirection.EAST, renderer);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.NORTH), ForgeDirection.NORTH, renderer);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.SOUTH), ForgeDirection.SOUTH, renderer);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.DOWN), ForgeDirection.DOWN, renderer);
        rh.renderFace(x, y, z, blk.getRendererInstance().getTexture(ForgeDirection.UP), ForgeDirection.UP, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.renderCache = rh.useSimpliedRendering(x, y, z, this, this.renderCache);
        boolean useCovered = false;
        boolean requireDetailed = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IGridHost gh;
            IPart p = this.getHost().getPart(dir);
            if (p != null && p instanceof IGridHost) {
                IGridHost igh = (IGridHost)((Object)p);
                AECableType type = igh.getCableConnectionType(dir.getOpposite());
                if (type != AECableType.COVERED && type != AECableType.SMART) continue;
                useCovered = true;
                break;
            }
            if (!this.connections.contains(dir)) continue;
            TileEntity te = this.tile.func_145831_w().func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            IPartHost ccph = te instanceof IPartHost ? (IPartHost)te : null;
            IGridHost iGridHost = gh = te instanceof IGridHost ? (IGridHost)te : null;
            if (ccph != null || gh == null || gh.getCableConnectionType(dir) == AECableType.GLASS) continue;
            requireDetailed = true;
        }
        if (useCovered) {
            rh.setTexture(this.getCoveredTexture(this.getCableColor()));
        } else {
            rh.setTexture(this.getTexture(this.getCableColor()));
        }
        IPartHost ph = this.getHost();
        block14: for (ForgeDirection of : EnumSet.complementOf(this.connections)) {
            int len;
            IPart bp = ph.getPart(of);
            if (!(bp instanceof IGridHost) || (len = bp.cableConnectionRenderTo()) >= 8) continue;
            switch (of) {
                case DOWN: {
                    rh.setBounds(6.0f, len, 6.0f, 10.0f, 6.0f, 10.0f);
                    break;
                }
                case EAST: {
                    rh.setBounds(10.0f, 6.0f, 6.0f, 16 - len, 10.0f, 10.0f);
                    break;
                }
                case NORTH: {
                    rh.setBounds(6.0f, 6.0f, len, 10.0f, 10.0f, 6.0f);
                    break;
                }
                case SOUTH: {
                    rh.setBounds(6.0f, 6.0f, 10.0f, 10.0f, 10.0f, 16 - len);
                    break;
                }
                case UP: {
                    rh.setBounds(6.0f, 10.0f, 6.0f, 10.0f, 16 - len, 10.0f);
                    break;
                }
                case WEST: {
                    rh.setBounds(len, 6.0f, 6.0f, 6.0f, 10.0f, 10.0f);
                    break;
                }
                default: {
                    continue block14;
                }
            }
            rh.renderBlock(x, y, z, renderer);
        }
        if (this.connections.size() != 2 || !this.nonLinear(this.connections) || useCovered || requireDetailed) {
            if (useCovered) {
                rh.setBounds(5.0f, 5.0f, 5.0f, 11.0f, 11.0f, 11.0f);
                rh.renderBlock(x, y, z, renderer);
            } else {
                rh.setBounds(6.0f, 6.0f, 6.0f, 10.0f, 10.0f, 10.0f);
                rh.renderBlock(x, y, z, renderer);
            }
            for (ForgeDirection of : this.connections) {
                this.rendereGlassConection(x, y, z, rh, renderer, of);
            }
        } else {
            IIcon def = this.getTexture(this.getCableColor());
            rh.setTexture(def);
            block16: for (ForgeDirection of : this.connections) {
                rh.setFacesToRender(EnumSet.complementOf(EnumSet.of(of, of.getOpposite())));
                switch (of) {
                    case DOWN: 
                    case UP: {
                        renderer.func_147782_a(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
                        continue block16;
                    }
                    case EAST: 
                    case WEST: {
                        renderer.field_147873_r = 1;
                        renderer.field_147875_q = 1;
                        renderer.field_147867_u = 1;
                        renderer.field_147865_v = 1;
                        renderer.func_147782_a(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
                        continue block16;
                    }
                    case NORTH: 
                    case SOUTH: {
                        renderer.field_147871_s = 1;
                        renderer.field_147869_t = 1;
                        renderer.func_147782_a(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
                        continue block16;
                    }
                }
            }
            rh.renderBlockCurrentBounds(x, y, z, renderer);
        }
        rh.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
        rh.setTexture(null);
    }

    @Override
    public boolean changeColor(AEColor newColor, EntityPlayer who) {
        if (this.getCableColor() != newColor) {
            ItemStack newPart = null;
            if (this.getCableConnectionType() == AECableType.GLASS) {
                newPart = AEApi.instance().parts().partCableGlass.stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.COVERED) {
                newPart = AEApi.instance().parts().partCableCovered.stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.SMART) {
                newPart = AEApi.instance().parts().partCableSmart.stack(newColor, 1);
            } else if (this.getCableConnectionType() == AECableType.DENSE) {
                newPart = AEApi.instance().parts().partCableDense.stack(newColor, 1);
            }
            boolean hasPermission = true;
            try {
                hasPermission = this.proxy.getSecurity().hasPermission(who, SecurityPermissions.BUILD);
            }
            catch (GridAccessException e) {
                // empty catch block
            }
            if (newPart != null && hasPermission) {
                if (Platform.isClient()) {
                    return true;
                }
                this.getHost().removePart(ForgeDirection.UNKNOWN, true);
                this.getHost().addPart(newPart, ForgeDirection.UNKNOWN, who);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValidSides(EnumSet<ForgeDirection> sides) {
        this.proxy.setValidSides(sides);
    }

    protected boolean nonLinear(EnumSet<ForgeDirection> sides) {
        return sides.contains(ForgeDirection.EAST) && sides.contains(ForgeDirection.WEST) || sides.contains(ForgeDirection.NORTH) && sides.contains(ForgeDirection.SOUTH) || sides.contains(ForgeDirection.UP) && sides.contains(ForgeDirection.DOWN);
    }
}

