/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.config.TunnelType;
import appeng.core.AppEng;
import appeng.integration.IntegrationType;
import appeng.integration.modules.helpers.NullRFHandler;
import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.transformer.annotations.integration;
import appeng.util.Platform;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Stack;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@integration.InterfaceList(value={@integration.Interface(iface="cofh.api.energy.IEnergyHandler", iname="RF")})
public class PartP2PRFPower
extends PartP2PTunnel<PartP2PRFPower>
implements IEnergyHandler {
    private static final IEnergyHandler myNullHandler = new NullRFHandler();
    boolean cachedTarget = false;
    IEnergyHandler outputTarget;
    static final ThreadLocal<Stack<PartP2PRFPower>> depth = new ThreadLocal();

    @Override
    public TunnelType getTunnelType() {
        return TunnelType.RF_POWER;
    }

    public PartP2PRFPower(ItemStack is) {
        super(is);
        if (!AppEng.instance.isIntegrationEnabled(IntegrationType.RF)) {
            throw new RuntimeException("RF Not installed!");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.cachedTarget = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.field_150339_S.func_149733_h(0);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.getHost().notifyNeighbors();
    }

    public float getPowerDrainPerTick() {
        return 0.5f;
    }

    private Stack<PartP2PRFPower> getDepth() {
        Stack<PartP2PRFPower> s = depth.get();
        if (s == null) {
            s = new Stack();
            depth.set(s);
        }
        return s;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.output) {
            return 0;
        }
        if (this.isActive()) {
            Stack<PartP2PRFPower> stack = this.getDepth();
            for (PartP2PRFPower t : stack) {
                if (t != this) continue;
                return 0;
            }
            stack.push(this);
            int total = 0;
            try {
                int recv;
                for (PartP2PRFPower t : this.getOutputs()) {
                    if (Platform.getRandomInt() % 2 <= 0) continue;
                    recv = t.getOutput().receiveEnergy(t.side.getOpposite(), maxReceive, simulate);
                    total += recv;
                    if ((maxReceive -= recv) > 0) continue;
                    break;
                }
                if (maxReceive > 0) {
                    for (PartP2PRFPower t : this.getOutputs()) {
                        recv = t.getOutput().receiveEnergy(t.side.getOpposite(), maxReceive, simulate);
                        total += recv;
                        if ((maxReceive -= recv) > 0) continue;
                        break;
                    }
                }
                this.QueueTunnelDrain(PowerUnits.RF, total);
            }
            catch (GridAccessException e) {
                // empty catch block
            }
            if (stack.pop() != this) {
                throw new RuntimeException("Invalid Recursion detected.");
            }
            return total;
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.output || !this.isActive()) {
            return 0;
        }
        int total = 0;
        Stack<PartP2PRFPower> stack = this.getDepth();
        for (PartP2PRFPower t : stack) {
            if (t != this) continue;
            return 0;
        }
        stack.push(this);
        try {
            for (PartP2PRFPower t : this.getOutputs()) {
                total += t.getOutput().getEnergyStored(t.side.getOpposite());
            }
        }
        catch (GridAccessException e) {
            return 0;
        }
        if (stack.pop() != this) {
            throw new RuntimeException("Invalid Recursion detected.");
        }
        return total;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.output || !this.isActive()) {
            return 0;
        }
        int total = 0;
        Stack<PartP2PRFPower> stack = this.getDepth();
        for (PartP2PRFPower t : stack) {
            if (t != this) continue;
            return 0;
        }
        stack.push(this);
        try {
            for (PartP2PRFPower t : this.getOutputs()) {
                total += t.getOutput().getMaxEnergyStored(t.side.getOpposite());
            }
        }
        catch (GridAccessException e) {
            return 0;
        }
        if (stack.pop() != this) {
            throw new RuntimeException("Invalid Recursion detected.");
        }
        return total;
    }

    private IEnergyHandler getOutput() {
        if (this.output) {
            if (!this.cachedTarget) {
                TileEntity self = this.getTile();
                TileEntity te = self.func_145831_w().func_147438_o(self.field_145851_c + this.side.offsetX, self.field_145848_d + this.side.offsetY, self.field_145849_e + this.side.offsetZ);
                this.outputTarget = te instanceof IEnergyHandler ? (IEnergyHandler)te : null;
                this.cachedTarget = true;
            }
            if (this.outputTarget == null || !this.outputTarget.canConnectEnergy(this.side.getOpposite())) {
                return myNullHandler;
            }
            return this.outputTarget;
        }
        return myNullHandler;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

