/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.AEApi;
import appeng.api.config.TunnelType;
import appeng.api.exceptions.FailedConnection;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartHost;
import appeng.api.util.AECableType;
import appeng.core.AELog;
import appeng.core.settings.TickRates;
import appeng.hooks.TickHandler;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.Connections;
import appeng.me.cache.helpers.TunnelConnection;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.p2p.PartP2PTunnel;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PartP2PTunnelME
extends PartP2PTunnel<PartP2PTunnelME>
implements IGridTickable {
    AENetworkProxy outerProxy = new AENetworkProxy(this, "outer", null, true);
    public Connections connection = new Connections(this);

    @Override
    public TunnelType getTunnelType() {
        return TunnelType.ME;
    }

    public PartP2PTunnelME(ItemStack is) {
        super(is);
        this.proxy.setFlags(GridFlags.REQUIRE_CHANNEL, GridFlags.COMPRESSED_CHANNEL);
        this.outerProxy.setFlags(GridFlags.DENSE_CAPACITY, GridFlags.CANNOT_CARRY_COMPRESSED);
    }

    @Override
    public void setPartHostInfo(ForgeDirection side, IPartHost host, TileEntity tile) {
        super.setPartHostInfo(side, host, tile);
        this.outerProxy.setValidSides(EnumSet.of(side));
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.outerProxy.readFromNBT(extra);
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.outerProxy.writeToNBT(extra);
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.outerProxy.onReady();
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.outerProxy.invalidate();
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return this.outerProxy.getNode();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    @Override
    public void onTunnelNetworkChange() {
        super.onTunnelNetworkChange();
        if (!this.output) {
            try {
                this.proxy.getTick().wakeDevice(this.proxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.METunnel.min, TickRates.METunnel.max, true, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        try {
            if (!this.proxy.getPath().isNetworkBooting()) {
                if (!this.proxy.getEnergy().isNetworkPowered()) {
                    this.connection.markDestroy();
                    TickHandler.instance.addCallable(this.tile.func_145831_w(), this.connection);
                } else if (this.proxy.isActive()) {
                    this.connection.markCreate();
                    TickHandler.instance.addCallable(this.tile.func_145831_w(), this.connection);
                } else {
                    this.connection.markDestroy();
                    TickHandler.instance.addCallable(this.tile.func_145831_w(), this.connection);
                }
                return TickRateModulation.SLEEP;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return TickRateModulation.IDLE;
    }

    @Override
    public void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        super.onPlacement(player, held, side);
        this.outerProxy.setOwner(player);
    }

    public void updateConnections(Connections connections) {
        if (connections.destroy) {
            for (TunnelConnection cw : this.connection.connections.values()) {
                cw.c.destroy();
            }
            this.connection.connections.clear();
        } else if (connections.create) {
            Iterator<TunnelConnection> i = this.connection.connections.values().iterator();
            while (i.hasNext()) {
                TunnelConnection cw = i.next();
                try {
                    if (cw.tunnel.proxy.getGrid() != this.proxy.getGrid()) {
                        cw.c.destroy();
                        i.remove();
                        continue;
                    }
                    if (cw.tunnel.proxy.isActive()) continue;
                    cw.c.destroy();
                    i.remove();
                }
                catch (GridAccessException e) {}
            }
            LinkedList<PartP2PTunnelME> newSides = new LinkedList<PartP2PTunnelME>();
            try {
                for (PartP2PTunnelME me : this.getOutputs()) {
                    if (!me.proxy.isActive() || connections.connections.get(me.getGridNode()) != null) continue;
                    newSides.add(me);
                }
                for (PartP2PTunnelME me : newSides) {
                    try {
                        connections.connections.put(me.getGridNode(), new TunnelConnection(me, AEApi.instance().createGridConnection(this.outerProxy.getNode(), me.outerProxy.getNode())));
                    }
                    catch (FailedConnection e) {
                        AELog.error(e);
                    }
                }
            }
            catch (GridAccessException e) {
                AELog.error(e);
            }
        }
    }
}

