/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RecipeError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.recipes.RecipeHandler;
import appeng.recipes.handlers.IWebsiteSeralizer;
import appeng.util.Platform;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class Inscribe
implements ICraftHandler,
IWebsiteSeralizer {
    public boolean usePlates = false;
    public static HashSet<ItemStack> plates = new HashSet();
    public static HashSet<ItemStack> inputs = new HashSet();
    public static LinkedList<InscriberRecipe> recipes = new LinkedList();
    IIngredient imprintable;
    IIngredient plateA;
    IIngredient plateB;
    IIngredient output;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setup(List<List<IIngredient>> input, List<List<IIngredient>> output) throws RecipeError {
        if (output.size() != 1 || output.get(0).size() != 1) throw new RecipeError("Inscriber recipes must produce a single output.");
        if (input.size() != 1 || input.get(0).size() <= 1) throw new RecipeError("Inscriber recipes cannot have rows, and must have more then one input.");
        this.imprintable = input.get(0).get(0);
        this.plateA = input.get(0).get(1);
        if (input.get(0).size() > 2) {
            this.plateB = input.get(0).get(2);
        }
        this.output = output.get(0).get(0);
    }

    @Override
    public void register() throws RegistrationError, MissingIngredientError {
        if (this.imprintable != null) {
            for (ItemStack s : this.imprintable.getItemStackSet()) {
                inputs.add(s);
            }
        }
        if (this.plateA != null) {
            for (ItemStack s : this.plateA.getItemStackSet()) {
                plates.add(s);
            }
        }
        if (this.plateB != null) {
            for (ItemStack s : this.plateB.getItemStackSet()) {
                plates.add(s);
            }
        }
        InscriberRecipe ir = new InscriberRecipe(this.imprintable.getItemStackSet(), this.plateA == null ? null : this.plateA.getItemStack(), this.plateB == null ? null : this.plateB.getItemStack(), this.output.getItemStack(), this.usePlates);
        recipes.add(ir);
    }

    @Override
    public boolean canCraft(ItemStack reqOutput) throws RegistrationError, MissingIngredientError {
        return Platform.isSameItemPrecise(this.output.getItemStack(), reqOutput);
    }

    @Override
    public String getPattern(RecipeHandler h) {
        String o = "inscriber " + this.output.getQty() + "\n";
        o = o + h.getName(this.output) + "\n";
        if (this.plateA != null) {
            o = o + h.getName(this.plateA) + "\n";
        }
        o = o + h.getName(this.imprintable);
        if (this.plateB != null) {
            o = o + "\n" + h.getName(this.plateB);
        }
        return o;
    }

    public static class InscriberRecipe {
        public final boolean usePlates;
        public final ItemStack plateA;
        public final ItemStack[] imprintable;
        public final ItemStack plateB;
        public final ItemStack output;

        public InscriberRecipe(ItemStack[] imprintable, ItemStack plateA, ItemStack plateB, ItemStack out, boolean usePlates) {
            this.imprintable = imprintable;
            this.usePlates = usePlates;
            this.plateA = plateA;
            this.plateB = plateB;
            this.output = out;
        }
    }
}

