/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RecipeError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.core.AELog;
import appeng.recipes.RecipeHandler;
import appeng.recipes.game.ShapedRecipe;
import appeng.recipes.handlers.IWebsiteSeralizer;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class Shaped
implements ICraftHandler,
IWebsiteSeralizer {
    private int rows;
    private int cols;
    List<List<IIngredient>> inputs;
    IIngredient output;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setup(List<List<IIngredient>> input, List<List<IIngredient>> output) throws RecipeError {
        if (output.size() != 1 || output.get(0).size() != 1) throw new RecipeError("Crafting must produce a single output.");
        this.rows = input.size();
        if (this.rows <= 0 || input.size() > 3) throw new RecipeError("shaped crafting recpies must have 1-3 rows.");
        this.cols = input.get(0).size();
        if (this.cols > 3 || this.cols < 1) throw new RecipeError("Crafting recipes must have 1-3 columns.");
        for (int x = 0; x < input.size(); ++x) {
            if (input.get(x).size() == this.cols) continue;
            throw new RecipeError("all rows in a shaped crafting recipe must contain the same number of ingredients.");
        }
        this.inputs = input;
        this.output = output.get(0).get(0);
    }

    @Override
    public void register() throws RegistrationError, MissingIngredientError {
        char first = 'A';
        ArrayList<Object> args = new ArrayList<Object>();
        for (int y = 0; y < this.rows; ++y) {
            String row = "";
            for (int x = 0; x < this.cols; ++x) {
                if (this.inputs.get(y).get(x).isAir()) {
                    row = row + " ";
                    continue;
                }
                row = row + first;
                args.add(Character.valueOf(first));
                args.add(this.inputs.get(y).get(x));
                first = (char)(first + '\u0001');
            }
            args.add(y, new String(row));
        }
        ItemStack outIS = this.output.getItemStack();
        try {
            GameRegistry.addRecipe((IRecipe)new ShapedRecipe(outIS, args.toArray(new Object[args.size()])));
        }
        catch (Throwable e) {
            AELog.error(e);
            throw new RegistrationError("Error while adding shaped recipe.");
        }
    }

    @Override
    public boolean canCraft(ItemStack reqOutput) throws RegistrationError, MissingIngredientError {
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                IIngredient i = this.inputs.get(y).get(x);
                if (i.isAir()) continue;
                for (ItemStack r : i.getItemStackSet()) {
                    if (!Platform.isSameItemPrecise(r, reqOutput)) continue;
                    return false;
                }
            }
        }
        return Platform.isSameItemPrecise(this.output.getItemStack(), reqOutput);
    }

    @Override
    public String getPattern(RecipeHandler h) {
        String o = "shaped " + this.output.getQty() + " " + this.cols + "x" + this.rows + "\n";
        o = o + h.getName(this.output) + "\n";
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                IIngredient i = this.inputs.get(y).get(x);
                o = i.isAir() ? o + "air" + (x + 1 == this.cols ? "\n" : " ") : o + h.getName(i) + (x + 1 == this.cols ? "\n" : " ");
            }
        }
        return o.trim();
    }
}

