/*
 * Decompiled with CFR 0.152.
 */
package appeng.services;

import appeng.api.AEApi;
import appeng.api.util.DimensionalCoord;
import appeng.services.helpers.CompassReader;
import appeng.services.helpers.ICompassCallback;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class CompassService
implements ThreadFactory {
    int jobSize = 0;
    HashMap<World, CompassReader> worldSet = new HashMap();
    ExecutorService executor;
    final File rootFolder;

    public Future<?> getCompassDirection(DimensionalCoord coord, int maxRange, ICompassCallback cc) {
        ++this.jobSize;
        return this.executor.submit(new CMDirectionRequest(coord, maxRange, cc));
    }

    public int jobSize() {
        return this.jobSize;
    }

    public void cleanUp() {
        for (CompassReader cr : this.worldSet.values()) {
            cr.close();
        }
    }

    public void updateArea(World w, int chunkX, int chunkZ) {
        int x = chunkX << 4;
        int z = chunkZ << 4;
        this.updateArea(w, x, 16, z);
        this.updateArea(w, x, 48, z);
        this.updateArea(w, x, 80, z);
        this.updateArea(w, x, 112, z);
        this.updateArea(w, x, 144, z);
        this.updateArea(w, x, 176, z);
        this.updateArea(w, x, 208, z);
        this.updateArea(w, x, 240, z);
    }

    public Future<?> updateArea(World w, int x, int y, int z) {
        ++this.jobSize;
        int cx = x >> 4;
        int cdy = y >> 5;
        int cz = z >> 4;
        int low_y = cdy << 5;
        int hi_y = low_y + 32;
        Block skystone = AEApi.instance().blocks().blockSkyStone.block();
        Chunk c = w.func_72938_d(x, z);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = low_y; k < hi_y; ++k) {
                    Block blk = c.func_150810_a(i, k, j);
                    if (blk != skystone || c.func_76628_c(i, k, j) != 0) continue;
                    return this.executor.submit(new CMUpdatePost(w, cx, cz, cdy, true));
                }
            }
        }
        return this.executor.submit(new CMUpdatePost(w, cx, cz, cdy, false));
    }

    public CompassService(File aEFolder) {
        this.rootFolder = aEFolder;
        this.executor = Executors.newSingleThreadExecutor(this);
        this.jobSize = 0;
    }

    private CompassReader getReader(World w) {
        CompassReader cr = this.worldSet.get(w);
        if (cr == null) {
            cr = new CompassReader(w, this.rootFolder);
            this.worldSet.put(w, cr);
        }
        return cr;
    }

    private int dist(int ax, int az, int bx, int bz) {
        int up = (bz - az) * 16;
        int side = (bx - ax) * 16;
        return up * up + side * side;
    }

    private double rad(int ax, int az, int bx, int bz) {
        int up = bz - az;
        int side = bx - ax;
        return Math.atan2(-up, side) - 1.5707963267948966;
    }

    public void kill() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(6L, TimeUnit.MINUTES);
            this.jobSize = 0;
            for (CompassReader cr : this.worldSet.values()) {
                cr.close();
            }
            this.worldSet.clear();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Thread newThread(Runnable job) {
        return new Thread(job, "AE Compass Service");
    }

    private class CMDirectionRequest
    implements Runnable {
        public final int maxRange;
        public final DimensionalCoord coord;
        public final ICompassCallback callback;

        public CMDirectionRequest(DimensionalCoord coord, int getMaxRange, ICompassCallback cc) {
            this.coord = coord;
            this.maxRange = getMaxRange;
            this.callback = cc;
        }

        @Override
        public void run() {
            --CompassService.this.jobSize;
            int cx = this.coord.x >> 4;
            int cz = this.coord.z >> 4;
            CompassReader cr = CompassService.this.getReader(this.coord.getWorld());
            if (cr.hasBeacon(cx, cz)) {
                this.callback.calculatedDirection(true, true, -999.0, 0.0);
                if (CompassService.this.jobSize() < 2) {
                    CompassService.this.cleanUp();
                }
                return;
            }
            for (int offset = 1; offset < this.maxRange; ++offset) {
                int closness;
                int minx = cx - offset;
                int minz = cz - offset;
                int maxx = cx + offset;
                int maxz = cz + offset;
                int closest = Integer.MAX_VALUE;
                int chosen_x = cx;
                int chosen_z = cz;
                for (int z = minz; z <= maxz; ++z) {
                    if (cr.hasBeacon(minx, z) && (closness = CompassService.this.dist(cx, cz, minx, z)) < closest) {
                        closest = closness;
                        chosen_x = minx;
                        chosen_z = z;
                    }
                    if (!cr.hasBeacon(maxx, z) || (closness = CompassService.this.dist(cx, cz, maxx, z)) >= closest) continue;
                    closest = closness;
                    chosen_x = maxx;
                    chosen_z = z;
                }
                for (int x = minx + 1; x < maxx; ++x) {
                    if (cr.hasBeacon(x, minz) && (closness = CompassService.this.dist(cx, cz, x, minz)) < closest) {
                        closest = closness;
                        chosen_x = x;
                        chosen_z = minz;
                    }
                    if (!cr.hasBeacon(x, maxz) || (closness = CompassService.this.dist(cx, cz, x, maxz)) >= closest) continue;
                    closest = closness;
                    chosen_x = x;
                    chosen_z = maxz;
                }
                if (closest >= Integer.MAX_VALUE) continue;
                this.callback.calculatedDirection(true, false, CompassService.this.rad(cx, cz, chosen_x, chosen_z), CompassService.this.dist(cx, cz, chosen_x, chosen_z));
                if (CompassService.this.jobSize() < 2) {
                    CompassService.this.cleanUp();
                }
                return;
            }
            this.callback.calculatedDirection(false, true, -999.0, 999.0);
            if (CompassService.this.jobSize() < 2) {
                CompassService.this.cleanUp();
            }
        }
    }

    private class CMUpdatePost
    implements Runnable {
        public final World world;
        public final int chunkX;
        public final int chunkZ;
        public final int doubleChunkY;
        public final boolean value;

        public CMUpdatePost(World w, int cx, int cz, int dcy, boolean val) {
            this.world = w;
            this.chunkX = cx;
            this.doubleChunkY = dcy;
            this.chunkZ = cz;
            this.value = val;
        }

        @Override
        public void run() {
            --CompassService.this.jobSize;
            CompassReader cr = CompassService.this.getReader(this.world);
            cr.setHasBeacon(this.chunkX, this.chunkZ, this.doubleChunkY, this.value);
            if (CompassService.this.jobSize() < 2) {
                CompassService.this.cleanUp();
            }
        }
    }
}

