/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.AEApi;
import appeng.api.movable.IMovableHandler;
import appeng.api.movable.IMovableRegistry;
import appeng.api.util.WorldCoord;
import appeng.core.AELog;
import appeng.core.WorldSettings;
import appeng.util.Platform;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.ForgeDirection;

public class CachedPlane {
    int verticalBits;
    int x_size;
    int z_size;
    int cx_size;
    int cz_size;
    int x_offset;
    int y_offset;
    int z_offset;
    int y_size;
    Chunk[][] myChunks;
    Column[][] myColumns;
    LinkedList<TileEntity> tiles = new LinkedList();
    LinkedList<NextTickListEntry> ticks = new LinkedList();
    World wrld;
    Block matrixFrame;
    IMovableRegistry reg;
    LinkedList<WorldCoord> updates;

    public CachedPlane(World w, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        this.matrixFrame = AEApi.instance().blocks().blockMatrixFrame.block();
        this.reg = AEApi.instance().registries().moveable();
        this.updates = new LinkedList();
        this.wrld = w;
        this.x_size = maxx - minx + 1;
        this.y_size = maxy - miny + 1;
        this.z_size = maxz - minz + 1;
        this.x_offset = minx;
        this.y_offset = miny;
        this.z_offset = minz;
        int minCX = minx >> 4;
        int minCY = miny >> 4;
        int minCZ = minz >> 4;
        int maxCX = maxx >> 4;
        int maxCY = maxy >> 4;
        int maxCZ = maxz >> 4;
        this.cx_size = maxCX - minCX + 1;
        int cy_size = maxCY - minCY + 1;
        this.cz_size = maxCZ - minCZ + 1;
        this.myChunks = new Chunk[this.cx_size][this.cz_size];
        this.myColumns = new Column[this.x_size][this.z_size];
        this.verticalBits = 0;
        for (int cy = 0; cy < cy_size; ++cy) {
            this.verticalBits |= 1 << minCY + cy;
        }
        for (int x = 0; x < this.x_size; ++x) {
            for (int z = 0; z < this.z_size; ++z) {
                this.myColumns[x][z] = new Column(w.func_72964_e(minx + x >> 4, minz + z >> 4), minx + x & 0xF, minz + z & 0xF, minCY, cy_size);
            }
        }
        IMovableRegistry mr = AEApi.instance().registries().moveable();
        for (int cx = 0; cx < this.cx_size; ++cx) {
            for (int cz = 0; cz < this.cz_size; ++cz) {
                Chunk c;
                LinkedList rwarTiles = new LinkedList();
                LinkedList<ChunkPosition> deadTiles = new LinkedList<ChunkPosition>();
                this.myChunks[cx][cz] = c = w.func_72964_e(minCX + cx, minCZ + cz);
                rwarTiles.addAll(((HashMap)c.field_150816_i).entrySet());
                for (Map.Entry entry : rwarTiles) {
                    ChunkPosition cp = (ChunkPosition)entry.getKey();
                    TileEntity te = (TileEntity)entry.getValue();
                    if (te.field_145851_c < minx || te.field_145851_c > maxx || te.field_145848_d < miny || te.field_145848_d > maxy || te.field_145849_e < minz || te.field_145849_e > maxz) continue;
                    if (mr.askToMove(te)) {
                        this.tiles.add(te);
                        deadTiles.add(cp);
                        continue;
                    }
                    Object[] details = this.myColumns[te.field_145851_c - minx][te.field_145849_e - minz].getDetails(te.field_145848_d);
                    Block blk = (Block)details[0];
                    if (blk != null && blk.isAir((IBlockAccess)c.field_76637_e, te.field_145851_c, te.field_145848_d, te.field_145849_e) && blk.isReplaceable((IBlockAccess)c.field_76637_e, te.field_145851_c, te.field_145848_d, te.field_145849_e)) {
                        c.field_76637_e.func_147449_b(te.field_145851_c, te.field_145848_d, te.field_145849_e, Platform.air);
                        c.field_76637_e.func_147459_d(te.field_145851_c, te.field_145848_d, te.field_145849_e, Platform.air);
                        continue;
                    }
                    this.myColumns[te.field_145851_c - minx][te.field_145849_e - minz].setSkip(te.field_145848_d);
                }
                for (ChunkPosition chunkPosition : deadTiles) {
                    c.field_150816_i.remove(chunkPosition);
                }
                long k = this.wrld.func_82737_E();
                List list = this.wrld.func_72920_a(c, false);
                if (list == null) continue;
                for (Object o : list) {
                    NextTickListEntry ntle = (NextTickListEntry)o;
                    if (ntle.field_77183_a < minx || ntle.field_77183_a > maxx || ntle.field_77181_b < miny || ntle.field_77181_b > maxy || ntle.field_77182_c < minz || ntle.field_77182_c > maxz) continue;
                    NextTickListEntry newEntry = new NextTickListEntry(ntle.field_77183_a, ntle.field_77181_b, ntle.field_77182_c, ntle.func_151351_a());
                    newEntry.field_77180_e = ntle.field_77180_e - k;
                    this.ticks.add(newEntry);
                }
            }
        }
        for (TileEntity te : this.tiles) {
            try {
                this.wrld.field_147482_g.remove(te);
            }
            catch (Exception e) {
                AELog.error(e);
            }
        }
    }

    private IMovableHandler getHandler(TileEntity te) {
        IMovableRegistry mr = AEApi.instance().registries().moveable();
        return mr.getHandler(te);
    }

    void Swap(CachedPlane dst) {
        IMovableRegistry mr = AEApi.instance().registries().moveable();
        if (dst.x_size == this.x_size && dst.y_size == this.y_size && dst.z_size == this.z_size) {
            AELog.info("Block Copy Scale: " + this.x_size + ", " + this.y_size + ", " + this.z_size, new Object[0]);
            long startTime = System.nanoTime();
            for (int x = 0; x < this.x_size; ++x) {
                for (int z = 0; z < this.z_size; ++z) {
                    Column a = this.myColumns[x][z];
                    Column b = dst.myColumns[x][z];
                    for (int y = 0; y < this.y_size; ++y) {
                        int src_y = y + this.y_offset;
                        int dst_y = y + dst.y_offset;
                        if (a.dontSkip(src_y) && b.dontSkip(dst_y)) {
                            Object[] aD = a.getDetails(src_y);
                            Object[] bD = b.getDetails(dst_y);
                            a.setBlockIDWithMetadata(src_y, bD);
                            b.setBlockIDWithMetadata(dst_y, aD);
                            continue;
                        }
                        this.markForUpdate(x + this.x_offset, src_y, z + this.z_offset);
                        dst.markForUpdate(x + dst.x_offset, dst_y, z + dst.z_offset);
                    }
                }
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            AELog.info("Block Copy Time: " + duration, new Object[0]);
            for (TileEntity te : this.tiles) {
                dst.addTile(te.field_145851_c - this.x_offset, te.field_145848_d - this.y_offset, te.field_145849_e - this.z_offset, te, this, mr);
            }
            for (TileEntity te : dst.tiles) {
                this.addTile(te.field_145851_c - dst.x_offset, te.field_145848_d - dst.y_offset, te.field_145849_e - dst.z_offset, te, dst, mr);
            }
            for (NextTickListEntry ntle : this.ticks) {
                dst.addTick(ntle.field_77183_a - this.x_offset, ntle.field_77181_b - this.y_offset, ntle.field_77182_c - this.z_offset, ntle);
            }
            for (NextTickListEntry ntle : dst.ticks) {
                this.addTick(ntle.field_77183_a - dst.x_offset, ntle.field_77181_b - dst.y_offset, ntle.field_77182_c - dst.z_offset, ntle);
            }
            startTime = System.nanoTime();
            this.updateChunks();
            dst.updateChunks();
            endTime = System.nanoTime();
            duration = endTime - startTime;
            AELog.info("Update Time: " + duration, new Object[0]);
        }
    }

    private void markForUpdate(int src_x, int src_y, int src_z) {
        this.updates.add(new WorldCoord(src_x, src_y, src_z));
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            this.updates.add(new WorldCoord(src_x + d.offsetX, src_y + d.offsetY, src_z + d.offsetZ));
        }
    }

    private void addTick(int x, int y, int z, NextTickListEntry ntle) {
        this.wrld.func_147464_a(x + this.x_offset, y + this.y_offset, z + this.z_offset, ntle.func_151351_a(), (int)ntle.field_77180_e);
    }

    private void addTile(int x, int y, int z, TileEntity te, CachedPlane alernateDest, IMovableRegistry mr) {
        block6: {
            try {
                Column c = this.myColumns[x][z];
                if (c.dontSkip(y + this.y_offset) || alernateDest == null) {
                    block5: {
                        IMovableHandler handler = this.getHandler(te);
                        try {
                            handler.moveTile(te, this.wrld, x + this.x_offset, y + this.y_offset, z + this.z_offset);
                        }
                        catch (Throwable e) {
                            AELog.error(e);
                            te.func_145834_a(this.wrld);
                            te.field_145851_c = x;
                            te.field_145848_d = y;
                            te.field_145849_e = z;
                            c.c.func_150812_a(c.x, y + y, c.z, te);
                            if (!((Column)c).c.field_76636_d) break block5;
                            this.wrld.addTileEntity(te);
                            this.wrld.func_147471_g(x, y, z);
                        }
                    }
                    mr.doneMoving(te);
                    break block6;
                }
                alernateDest.addTile(x, y, z, te, null, mr);
            }
            catch (Throwable e) {
                AELog.error(e);
            }
        }
    }

    private void updateChunks() {
        Chunk c;
        int z;
        int x;
        for (x = 0; x < this.cx_size; ++x) {
            for (z = 0; z < this.cz_size; ++z) {
                c = this.myChunks[x][z];
                c.func_76613_n();
                c.func_76603_b();
                c.field_76643_l = true;
            }
        }
        for (x = 0; x < this.cx_size; ++x) {
            for (z = 0; z < this.cz_size; ++z) {
                c = this.myChunks[x][z];
                for (int y = 1; y < 255; y += 32) {
                    WorldSettings.getInstance().getCompass().updateArea(this.wrld, c.field_76635_g << 4, y, c.field_76647_h << 4);
                }
                Platform.sendChunk(c, this.verticalBits);
            }
        }
    }

    class Column {
        private final int x;
        private final int z;
        private final Chunk c;
        private final Object[] ch = new Object[]{0, 0, 0};
        private List<Integer> skipThese = null;
        private ExtendedBlockStorage[] storage;

        public Column(Chunk _c, int _x, int _z, int cy, int y_clen) {
            this.x = _x;
            this.z = _z;
            this.c = _c;
            this.storage = this.c.func_76587_i();
            for (int ay = 0; ay < y_clen; ++ay) {
                int by = ay + cy;
                ExtendedBlockStorage extendedblockstorage = this.storage[by];
                if (extendedblockstorage != null) continue;
                extendedblockstorage = this.storage[by] = new ExtendedBlockStorage(by << 4, !this.c.field_76637_e.field_73011_w.field_76576_e);
            }
        }

        public void setBlockIDWithMetadata(int y, Object[] blk) {
            if (blk[0] == CachedPlane.this.matrixFrame) {
                blk[0] = Platform.air;
            }
            ExtendedBlockStorage extendedblockstorage = this.storage[y >> 4];
            extendedblockstorage.func_150818_a(this.x, y & 0xF, this.z, (Block)blk[0]);
            extendedblockstorage.func_76654_b(this.x, y & 0xF, this.z, ((Integer)blk[1]).intValue());
            extendedblockstorage.func_76677_d(this.x, y & 0xF, this.z, ((Integer)blk[2]).intValue());
        }

        public Object[] getDetails(int y) {
            ExtendedBlockStorage extendedblockstorage = this.storage[y >> 4];
            this.ch[0] = extendedblockstorage.func_150819_a(this.x, y & 0xF, this.z);
            this.ch[1] = extendedblockstorage.func_76665_b(this.x, y & 0xF, this.z);
            this.ch[2] = extendedblockstorage.func_76674_d(this.x, y & 0xF, this.z);
            return this.ch;
        }

        public boolean dontSkip(int y) {
            ExtendedBlockStorage extendedblockstorage = this.storage[y >> 4];
            if (CachedPlane.this.reg.isBlacklisted(extendedblockstorage.func_150819_a(this.x, y & 0xF, this.z))) {
                return false;
            }
            return this.skipThese == null ? true : !this.skipThese.contains(y);
        }

        public void setSkip(int yCoord) {
            if (this.skipThese == null) {
                this.skipThese = new LinkedList<Integer>();
            }
            this.skipThese.add(yCoord);
        }
    }
}

