/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEColor;
import appeng.tile.crafting.TileCraftingTile;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.util.item.AEItemStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCraftingMonitorTile
extends TileCraftingTile
implements IColorableTile {
    @SideOnly(value=Side.CLIENT)
    public Integer dspList;
    @SideOnly(value=Side.CLIENT)
    public boolean updateList;
    IAEItemStack dspPlay;
    AEColor paintedColor = AEColor.Transparent;

    public TileCraftingMonitorTile() {
        this.addNewHandler(new CraftingMonitorHandler());
    }

    @Override
    public boolean isAccelerator() {
        return false;
    }

    @Override
    public boolean isStatus() {
        return true;
    }

    public void setJob(IAEItemStack is) {
        if (is == null != (this.dspPlay == null)) {
            this.dspPlay = is == null ? null : is.copy();
            this.markForUpdate();
        } else if (is != null && this.dspPlay != null && is.getStackSize() != this.dspPlay.getStackSize()) {
            this.dspPlay = is == null ? null : is.copy();
            this.markForUpdate();
        }
    }

    public IAEItemStack getJobProgress() {
        return this.dspPlay;
    }

    @Override
    public boolean requiresTESR() {
        return this.getJobProgress() != null;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(ForgeDirection side, AEColor newPaintedColor, EntityPlayer who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.func_70296_d();
        this.markForUpdate();
        return true;
    }

    class CraftingMonitorHandler
    extends AETileEventHandler {
        public CraftingMonitorHandler() {
            super(TileEventType.NETWORK, TileEventType.WORLD_NBT);
        }

        @Override
        public boolean readFromStream(ByteBuf data) throws IOException {
            AEColor oldPaintedColor = TileCraftingMonitorTile.this.paintedColor;
            TileCraftingMonitorTile.this.paintedColor = AEColor.values()[data.readByte()];
            boolean hasItem = data.readBoolean();
            TileCraftingMonitorTile.this.dspPlay = hasItem ? AEItemStack.loadItemStackFromPacket(data) : null;
            TileCraftingMonitorTile.this.updateList = true;
            return oldPaintedColor != TileCraftingMonitorTile.this.paintedColor;
        }

        @Override
        public void writeToStream(ByteBuf data) throws IOException {
            data.writeByte(TileCraftingMonitorTile.this.paintedColor.ordinal());
            if (TileCraftingMonitorTile.this.dspPlay == null) {
                data.writeBoolean(false);
            } else {
                data.writeBoolean(true);
                TileCraftingMonitorTile.this.dspPlay.writeToPacket(data);
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound data) {
            if (data.func_74764_b("paintedColor")) {
                TileCraftingMonitorTile.this.paintedColor = AEColor.values()[data.func_74771_c("paintedColor")];
            }
        }

        @Override
        public void writeToNBT(NBTTagCompound data) {
            data.func_74774_a("paintedColor", (byte)TileCraftingMonitorTile.this.paintedColor.ordinal());
        }
    }
}

