/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridHost;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.ISimplifiedBundle;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.WorldCoord;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.CraftingCPUCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.AENetworkProxyMultiblock;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.util.Platform;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCraftingTile
extends AENetworkTile
implements IAEMultiBlock,
IPowerChannelState {
    CraftingCPUCluster clust;
    final CraftingCPUCalculator calc = new CraftingCPUCalculator(this);
    public ISimplifiedBundle lightCache;
    public NBTTagCompound previousState = null;
    public boolean isCoreBlock = false;
    static final ItemStack coProcessorStack = AEApi.instance().blocks().blockCraftingAccelerator.stack(1);

    @Override
    protected AENetworkProxy createProxy() {
        return new AENetworkProxyMultiblock(this, "proxy", this.getItemFromTile(this), true);
    }

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        if (((TileCraftingTile)obj).isAccelerator()) {
            return coProcessorStack;
        }
        return super.getItemFromTile(obj);
    }

    public void updateStatus(CraftingCPUCluster c) {
        if (this.clust != null && this.clust != c) {
            this.clust.breakCluster();
        }
        this.clust = c;
        this.updateMeta(true);
    }

    public void updateMultiBlock() {
        this.calc.calculateMultiblock(this.field_145850_b, this.getLocation());
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.clust != null) {
            this.clust.updateName();
        }
    }

    public TileCraftingTile() {
        this.addNewHandler(new CraftingHandler());
        this.gridProxy.setFlags(GridFlags.MULTIBLOCK, GridFlags.REQUIRE_CHANNEL);
        this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
    }

    @Override
    public void onReady() {
        super.onReady();
        this.gridProxy.setVisualRepresentation(this.getItemFromTile(this));
        this.updateMultiBlock();
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public void disconnect(boolean update) {
        if (this.clust != null) {
            this.clust.destroy();
            if (update) {
                this.updateMeta(true);
            }
        }
    }

    @MENetworkEventSubscribe
    public void onPowerStateChage(MENetworkChannelsChanged ev) {
        this.updateMeta(false);
    }

    @MENetworkEventSubscribe
    public void onPowerStateChage(MENetworkPowerStatusChange ev) {
        this.updateMeta(false);
    }

    public void updateMeta(boolean updateFormed) {
        int newmeta;
        int current;
        if (this.field_145850_b == null || this.notLoaded()) {
            return;
        }
        boolean formed = this.isFormed();
        boolean power = false;
        if (this.gridProxy.isReady()) {
            power = this.gridProxy.isActive();
        }
        if ((current = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)) != (newmeta = current & 3 | (formed ? 8 : 0) | (power ? 4 : 0))) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newmeta, 2);
        }
        if (updateFormed) {
            if (formed) {
                this.gridProxy.setValidSides(EnumSet.allOf(ForgeDirection.class));
            } else {
                this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
            }
        }
    }

    @Override
    public IAECluster getCluster() {
        return this.clust;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 4) == 4;
        }
        return this.gridProxy.isActive();
    }

    public boolean isFormed() {
        if (Platform.isClient()) {
            return (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 8) == 8;
        }
        return this.clust != null;
    }

    public boolean isAccelerator() {
        if (this.field_145850_b == null) {
            return false;
        }
        return (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 3) == 1;
    }

    public boolean isStatus() {
        return false;
    }

    public boolean isStorage() {
        return false;
    }

    public int getStorageBytes() {
        return 0;
    }

    @Override
    public boolean isActive() {
        if (Platform.isServer()) {
            return this.gridProxy.isActive();
        }
        return this.isPowered() && this.isFormed();
    }

    public void breakCluster() {
        if (this.clust != null) {
            this.clust.cancel();
            IMEInventory<IAEItemStack> inv = this.clust.getInventory();
            LinkedList<WorldCoord> places = new LinkedList<WorldCoord>();
            Iterator<IGridHost> i = this.clust.getTiles();
            while (i.hasNext()) {
                IGridHost h = i.next();
                if (h == this) {
                    places.add(new WorldCoord(this));
                    continue;
                }
                TileEntity te = (TileEntity)h;
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    WorldCoord wc = new WorldCoord(te);
                    wc.add(d, 1);
                    if (!this.field_145850_b.func_147437_c(wc.x, wc.y, wc.z)) continue;
                    places.add(wc);
                }
            }
            Collections.shuffle(places);
            if (places.isEmpty()) {
                throw new RuntimeException("No air or even the tile hat was destroyed?!?!");
            }
            for (IAEItemStack ais : inv.getAvailableItems(AEApi.instance().storage().createItemList())) {
                IAEItemStack g;
                ais = ais.copy();
                ais.setStackSize(ais.getItemStack().func_77976_d());
                while ((g = inv.extractItems(ais.copy(), Actionable.MODULATE, this.clust.getActionSource())) != null) {
                    WorldCoord wc = (WorldCoord)places.poll();
                    places.add(wc);
                    Platform.spawnDrops(this.field_145850_b, wc.x, wc.y, wc.z, Arrays.asList(g.getItemStack()));
                }
            }
            this.clust.destroy();
        }
    }

    private class CraftingHandler
    extends AETileEventHandler {
        public CraftingHandler() {
            super(TileEventType.WORLD_NBT);
        }

        @Override
        public void writeToNBT(NBTTagCompound data) {
            data.func_74757_a("core", TileCraftingTile.this.isCoreBlock);
            if (TileCraftingTile.this.isCoreBlock && TileCraftingTile.this.clust != null) {
                TileCraftingTile.this.clust.writeToNBT(data);
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound data) {
            TileCraftingTile.this.isCoreBlock = data.func_74767_n("core");
            if (TileCraftingTile.this.isCoreBlock) {
                if (TileCraftingTile.this.clust != null) {
                    TileCraftingTile.this.clust.readFromNBT(data);
                } else {
                    TileCraftingTile.this.previousState = (NBTTagCompound)data.func_74737_b();
                }
            }
        }
    }
}

