/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.grid;

import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.tile.AEBaseTile;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class AENetworkTile
extends AEBaseTile
implements IActionHost,
IGridProxyable {
    protected final AENetworkProxy gridProxy = this.createProxy();

    public AENetworkTile() {
        this.addNewHandler(new AENetworkTileHandler());
    }

    protected AENetworkProxy createProxy() {
        return new AENetworkProxy(this, "proxy", this.getItemFromTile(this), true);
    }

    @Override
    public IGridNode getGridNode(ForgeDirection dir) {
        return this.gridProxy.getNode();
    }

    @Override
    public void onReady() {
        super.onReady();
        this.gridProxy.onReady();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.gridProxy.onChunkUnload();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.gridProxy.validate();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.gridProxy.invalidate();
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    @Override
    public void gridChanged() {
    }

    @Override
    public AENetworkProxy getProxy() {
        return this.gridProxy;
    }

    @Override
    public IGridNode getActionableNode() {
        return this.gridProxy.getNode();
    }

    class AENetworkTileHandler
    extends AETileEventHandler {
        public AENetworkTileHandler() {
            super(TileEventType.WORLD_NBT);
        }

        @Override
        public void readFromNBT(NBTTagCompound data) {
            AENetworkTile.this.gridProxy.readFromNBT(data);
        }

        @Override
        public void writeToNBT(NBTTagCompound data) {
            AENetworkTile.this.gridProxy.writeToNBT(data);
        }
    }
}

