/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.CopyMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigureableObject;
import appeng.tile.AEBaseTile;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileCellWorkbench
extends AEBaseTile
implements IUpgradeableHost,
IAEAppEngInventory,
IConfigureableObject,
IConfigManagerHost {
    AppEngInternalInventory cell = new AppEngInternalInventory(this, 1);
    AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 63);
    ConfigManager cm = new ConfigManager(this);
    IInventory cacheUpgrades = null;
    IInventory cacheConfig = null;
    private boolean locked = false;

    public IInventory getCellUpgradeInventory() {
        if (this.cacheUpgrades == null) {
            ICellWorkbenchItem cwbi = this.getCell();
            if (cwbi == null) {
                return null;
            }
            ItemStack is = this.cell.func_70301_a(0);
            if (is == null) {
                return null;
            }
            IInventory inv = cwbi.getUpgradesInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheUpgrades = inv;
            return this.cacheUpgrades;
        }
        return this.cacheUpgrades;
    }

    public IInventory getCellConfigInventory() {
        if (this.cacheConfig == null) {
            ICellWorkbenchItem cwbi = this.getCell();
            if (cwbi == null) {
                return null;
            }
            ItemStack is = this.cell.func_70301_a(0);
            if (is == null) {
                return null;
            }
            IInventory inv = cwbi.getConfigInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheConfig = inv;
            return this.cacheConfig;
        }
        return this.cacheConfig;
    }

    public TileCellWorkbench() {
        this.addNewHandler(new TileCellWorkbenchHandler());
        this.cm.registerSetting(Settings.COPY_MODE, CopyMode.CLEAR_ON_REMOVE);
        this.cell.enableClientEvents = true;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        if (name.equals("cell")) {
            return this.cell;
        }
        return null;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return 0;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        IInventory c;
        if (inv == this.cell && !this.locked) {
            this.locked = true;
            this.cacheUpgrades = null;
            this.cacheConfig = null;
            IInventory c2 = this.getCellConfigInventory();
            if (c2 != null) {
                int x;
                boolean cellHasConfig = false;
                for (x = 0; x < c2.func_70302_i_(); ++x) {
                    if (c2.func_70301_a(x) == null) continue;
                    cellHasConfig = true;
                    break;
                }
                if (cellHasConfig) {
                    for (x = 0; x < this.config.func_70302_i_(); ++x) {
                        this.config.func_70299_a(x, c2.func_70301_a(x));
                    }
                } else {
                    for (x = 0; x < this.config.func_70302_i_(); ++x) {
                        c2.func_70299_a(x, this.config.func_70301_a(x));
                    }
                    c2.func_70296_d();
                }
            } else if (this.cm.getSetting(Settings.COPY_MODE) == CopyMode.CLEAR_ON_REMOVE) {
                for (int x = 0; x < this.config.func_70302_i_(); ++x) {
                    this.config.func_70299_a(x, null);
                }
                this.func_70296_d();
            }
            this.locked = false;
        } else if (inv == this.config && !this.locked && (c = this.getCellConfigInventory()) != null) {
            for (int x = 0; x < this.config.func_70302_i_(); ++x) {
                c.func_70299_a(x, this.config.func_70301_a(x));
            }
            c.func_70296_d();
        }
    }

    @Override
    public void getDrops(World w, int x, int y, int z, ArrayList<ItemStack> drops) {
        super.getDrops(w, x, y, z, drops);
        if (this.cell.func_70301_a(0) != null) {
            drops.add(this.cell.func_70301_a(0));
        }
    }

    public ICellWorkbenchItem getCell() {
        if (this.cell.func_70301_a(0) == null) {
            return null;
        }
        if (this.cell.func_70301_a(0).func_77973_b() instanceof ICellWorkbenchItem) {
            return (ICellWorkbenchItem)this.cell.func_70301_a(0).func_77973_b();
        }
        return null;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    class TileCellWorkbenchHandler
    extends AETileEventHandler {
        public TileCellWorkbenchHandler() {
            super(TileEventType.WORLD_NBT);
        }

        @Override
        public void writeToNBT(NBTTagCompound data) {
            TileCellWorkbench.this.cell.writeToNBT(data, "cell");
            TileCellWorkbench.this.config.writeToNBT(data, "config");
            TileCellWorkbench.this.cm.writeToNBT(data);
        }

        @Override
        public void readFromNBT(NBTTagCompound data) {
            TileCellWorkbench.this.cell.readFromNBT(data, "cell");
            TileCellWorkbench.this.config.readFromNBT(data, "config");
            TileCellWorkbench.this.cm.readFromNBT(data);
        }
    }
}

