/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.tiles.ICrankable;
import appeng.api.networking.GridFlags;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCharger
extends AENetworkPowerTile
implements ICrankable {
    final int[] sides = new int[]{0};
    AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    int tickTickTimer = 0;
    int lastUpdate = 0;
    boolean requiresUpdate = false;

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    public TileCharger() {
        this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        this.gridProxy.setFlags(new GridFlags[0]);
        this.internalMaxPower = 1500.0;
        this.gridProxy.setIdlePowerUsage(0.0);
        this.addNewHandler(new TileChargerHandler());
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        super.setOrientation(inForward, inUp);
        this.gridProxy.setValidSides(EnumSet.of(this.getUp(), this.getUp().getOpposite()));
        this.setPowerSides(EnumSet.of(this.getUp(), this.getUp().getOpposite()));
    }

    @Override
    public boolean canTurn() {
        return this.internalCurrentPower < this.internalMaxPower;
    }

    @Override
    public void applyTurn() {
        this.injectExternalPower(PowerUnits.AE, 150.0);
        ItemStack myItem = this.func_70301_a(0);
        if (this.internalCurrentPower > 1499.0 && AEApi.instance().materials().materialCertusQuartzCrystal.sameAsStack(myItem)) {
            this.extractAEPower(this.internalMaxPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.func_70299_a(0, AEApi.instance().materials().materialCertusQuartzCrystalCharged.stack(myItem.field_77994_a));
        }
    }

    @Override
    public boolean canCrankAttach(ForgeDirection directionToCrank) {
        return this.getUp().equals((Object)directionToCrank) || this.getUp().getOpposite().equals((Object)directionToCrank);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        this.markForUpdate();
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return this.sides;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return Platform.isChargeable(itemstack) || AEApi.instance().materials().materialCertusQuartzCrystal.sameAsStack(itemstack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        IAEItemPowerStorage ips;
        if (Platform.isChargeable(itemstack) && (ips = (IAEItemPowerStorage)itemstack.func_77973_b()).getAECurrentPower(itemstack) >= ips.getAEMaxPower(itemstack)) {
            return true;
        }
        return AEApi.instance().materials().materialCertusQuartzCrystalCharged.sameAsStack(itemstack);
    }

    public void activate(EntityPlayer player) {
        if (!Platform.hasPermissions(new DimensionalCoord(this), player)) {
            return;
        }
        ItemStack myItem = this.func_70301_a(0);
        if (myItem == null) {
            ItemStack held = player.field_71071_by.func_70448_g();
            if (AEApi.instance().materials().materialCertusQuartzCrystal.sameAsStack(held) || Platform.isChargeable(held)) {
                held = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                this.func_70299_a(0, held);
            }
        } else {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(myItem);
            this.func_70299_a(0, null);
            Platform.spawnDrops(this.field_145850_b, this.field_145851_c + this.getForward().offsetX, this.field_145848_d + this.getForward().offsetY, this.field_145849_e + this.getForward().offsetZ, drops);
        }
    }

    @Override
    public boolean requiresTESR() {
        return true;
    }

    private class TileChargerHandler
    extends AETileEventHandler {
        public TileChargerHandler() {
            super(TileEventType.TICK, TileEventType.NETWORK);
        }

        @Override
        public boolean readFromStream(ByteBuf data) throws IOException {
            try {
                IAEItemStack item = AEItemStack.loadItemStackFromPacket(data);
                ItemStack is = item.getItemStack();
                TileCharger.this.inv.func_70299_a(0, is);
            }
            catch (Throwable t) {
                TileCharger.this.inv.func_70299_a(0, null);
            }
            return false;
        }

        @Override
        public void writeToStream(ByteBuf data) throws IOException {
            AEItemStack is = AEItemStack.create(TileCharger.this.func_70301_a(0));
            if (is != null) {
                is.writeToPacket(data);
            }
        }

        @Override
        public void Tick() {
            if (TileCharger.this.lastUpdate > 60 && TileCharger.this.requiresUpdate) {
                TileCharger.this.requiresUpdate = false;
                TileCharger.this.markForUpdate();
                TileCharger.this.lastUpdate = 0;
            }
            ++TileCharger.this.lastUpdate;
            ++TileCharger.this.tickTickTimer;
            if (TileCharger.this.tickTickTimer < 20) {
                return;
            }
            TileCharger.this.tickTickTimer = 0;
            ItemStack myItem = TileCharger.this.func_70301_a(0);
            if (TileCharger.this.internalCurrentPower < 1499.0) {
                try {
                    TileCharger.this.injectExternalPower(PowerUnits.AE, TileCharger.this.gridProxy.getEnergy().extractAEPower(Math.min(150.0, 1500.0 - TileCharger.this.internalCurrentPower), Actionable.MODULATE, PowerMultiplier.ONE));
                    TileCharger.this.tickTickTimer = 20;
                }
                catch (GridAccessException e) {
                    // empty catch block
                }
            }
            if (myItem == null) {
                return;
            }
            if (TileCharger.this.internalCurrentPower > 149.0 && Platform.isChargeable(myItem)) {
                IAEItemPowerStorage ps = (IAEItemPowerStorage)myItem.func_77973_b();
                if (ps.getAEMaxPower(myItem) > ps.getAECurrentPower(myItem)) {
                    double oldPower = TileCharger.this.internalCurrentPower;
                    double adjustment = ps.injectAEPower(myItem, TileCharger.this.extractAEPower(150.0, Actionable.MODULATE, PowerMultiplier.CONFIG));
                    TileCharger.this.internalCurrentPower += adjustment;
                    if (oldPower > TileCharger.this.internalCurrentPower) {
                        TileCharger.this.requiresUpdate = true;
                    }
                    TileCharger.this.tickTickTimer = 20;
                }
            } else if (TileCharger.this.internalCurrentPower > 1499.0 && AEApi.instance().materials().materialCertusQuartzCrystal.sameAsStack(myItem) && Platform.getRandomFloat() > 0.8f) {
                TileCharger.this.extractAEPower(TileCharger.this.internalMaxPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
                TileCharger.this.func_70299_a(0, AEApi.instance().materials().materialCertusQuartzCrystalCharged.stack(myItem.field_77994_a));
            }
        }
    }
}

