/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;

public class TileVibrationChamber
extends AENetworkInvTile
implements IGridTickable {
    final double powerPerTick = 5.0;
    final int[] sides = new int[]{0};
    AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    public int burnSpeed = 100;
    public double burnTime = 0.0;
    public double maxBurnTime = 0.0;
    public boolean isOn;

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    public TileVibrationChamber() {
        this.gridProxy.setIdlePowerUsage(0.0);
        this.gridProxy.setFlags(new GridFlags[0]);
        this.addNewHandler(new TileVibrationChamberHandler());
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.burnTime <= 0.0 && this.canEatFuel()) {
            try {
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException e) {
                // empty catch block
            }
        }
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack) > 0;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        if (this.burnTime <= 0.0) {
            this.eatFuel();
        }
        return new TickingRequest(TickRates.VibrationChamber.min, TickRates.VibrationChamber.max, this.burnTime <= 0.0, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.burnTime <= 0.0) {
            this.eatFuel();
            if (this.burnTime > 0.0) {
                return TickRateModulation.URGENT;
            }
            this.burnSpeed = 100;
            return TickRateModulation.SLEEP;
        }
        this.burnSpeed = Math.max(20, Math.min(this.burnSpeed, 200));
        double dialiation = (double)this.burnSpeed / 100.0;
        double timePassed = (double)TicksSinceLastCall * dialiation;
        this.burnTime -= timePassed;
        if (this.burnTime < 0.0) {
            timePassed += this.burnTime;
            this.burnTime = 0.0;
        }
        try {
            IEnergyGrid grid = this.gridProxy.getEnergy();
            double newPower = timePassed * 5.0;
            double overFlow = grid.injectPower(newPower, Actionable.SIMULATE);
            grid.injectPower(Math.max(0.0, newPower - overFlow), Actionable.MODULATE);
            this.burnSpeed = overFlow > 0.0 ? (this.burnSpeed -= TicksSinceLastCall) : (this.burnSpeed += TicksSinceLastCall);
            this.burnSpeed = Math.max(20, Math.min(this.burnSpeed, 200));
            return overFlow > 0.0 ? TickRateModulation.SLOWER : TickRateModulation.FASTER;
        }
        catch (GridAccessException e) {
            this.burnSpeed -= TicksSinceLastCall;
            this.burnSpeed = Math.max(20, Math.min(this.burnSpeed, 200));
            return TickRateModulation.SLOWER;
        }
    }

    private boolean canEatFuel() {
        int newBurnTime;
        ItemStack is = this.func_70301_a(0);
        return is != null && (newBurnTime = TileEntityFurnace.func_145952_a((ItemStack)is)) > 0 && is.field_77994_a > 0;
    }

    private void eatFuel() {
        int newBurnTime;
        ItemStack is = this.func_70301_a(0);
        if (is != null && (newBurnTime = TileEntityFurnace.func_145952_a((ItemStack)is)) > 0 && is.field_77994_a > 0) {
            this.burnTime += (double)newBurnTime;
            this.maxBurnTime = this.burnTime;
            --is.field_77994_a;
            if (is.field_77994_a <= 0) {
                ItemStack container = null;
                if (is.func_77973_b().hasContainerItem(is)) {
                    container = is.func_77973_b().getContainerItem(is);
                }
                this.func_70299_a(0, container);
            } else {
                this.func_70299_a(0, is);
            }
        }
        if (this.burnTime > 0.0) {
            try {
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (!this.isOn && this.burnTime > 0.0 || this.isOn && this.burnTime <= 0.0) {
            this.isOn = this.burnTime > 0.0;
            this.markForUpdate();
        }
    }

    private class TileVibrationChamberHandler
    extends AETileEventHandler {
        public TileVibrationChamberHandler() {
            super(TileEventType.NETWORK, TileEventType.WORLD_NBT);
        }

        @Override
        public boolean readFromStream(ByteBuf data) throws IOException {
            boolean wasOn = TileVibrationChamber.this.isOn;
            TileVibrationChamber.this.isOn = data.readBoolean();
            return wasOn != TileVibrationChamber.this.isOn;
        }

        @Override
        public void writeToStream(ByteBuf data) throws IOException {
            data.writeBoolean(TileVibrationChamber.this.burnTime > 0.0);
        }

        @Override
        public void writeToNBT(NBTTagCompound data) {
            data.func_74780_a("burnTime", TileVibrationChamber.this.burnTime);
            data.func_74780_a("maxBurnTime", TileVibrationChamber.this.maxBurnTime);
            data.func_74768_a("burnSpeed", TileVibrationChamber.this.burnSpeed);
        }

        @Override
        public void readFromNBT(NBTTagCompound data) {
            TileVibrationChamber.this.burnTime = data.func_74769_h("burnTime");
            TileVibrationChamber.this.maxBurnTime = data.func_74769_h("maxBurnTime");
            TileVibrationChamber.this.burnSpeed = data.func_74762_e("burnSpeed");
        }
    }
}

