/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkControllerChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import java.util.EnumSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileController
extends AENetworkPowerTile
implements IAEPowerStorage {
    boolean isValid = false;
    final int[] sides = new int[0];
    static final AppEngInternalInventory inv = new AppEngInternalInventory(null, 0);

    public TileController() {
        this.internalMaxPower = 8000.0;
        this.internalPublicPowerStorage = true;
        this.gridProxy.setIdlePowerUsage(3.0);
        this.gridProxy.setFlags(GridFlags.CANNOT_CARRY, GridFlags.DENSE_CAPACITY);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    @Override
    protected double getFunnelPowerDemand(double maxRecived) {
        try {
            return this.gridProxy.getEnergy().getEnergyDemand(8000.0);
        }
        catch (GridAccessException e) {
            return super.getFunnelPowerDemand(maxRecived);
        }
    }

    @Override
    protected double funnelPowerIntoStorage(double AEUnits, Actionable mode) {
        try {
            double ret = this.gridProxy.getEnergy().injectPower(AEUnits, mode);
            if (mode == Actionable.SIMULATE) {
                return ret;
            }
            return 0.0;
        }
        catch (GridAccessException e) {
            return super.funnelPowerIntoStorage(AEUnits, mode);
        }
    }

    @Override
    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
        try {
            this.gridProxy.getGrid().postEvent(new MENetworkPowerStorage(this, x));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @MENetworkEventSubscribe
    public void onControllerChange(MENetworkControllerChange status) {
        this.updateMeta();
    }

    @MENetworkEventSubscribe
    public void onPowerChange(MENetworkPowerStatusChange status) {
        this.updateMeta();
    }

    @Override
    public void onReady() {
        this.onNeighborChange(true);
        super.onReady();
    }

    public void onNeighborChange(boolean force) {
        boolean xx = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileController && this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileController;
        boolean yy = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileController && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileController;
        boolean zz = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileController && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileController;
        boolean oldValid = this.isValid;
        boolean bl = xx && !yy && !zz || !xx && yy && !zz || !xx && !yy && zz || (xx ? 1 : 0) + (yy ? 1 : 0) + (zz ? 1 : 0) <= 1 ? true : (this.isValid = false);
        if (oldValid != this.isValid || force) {
            if (this.isValid) {
                this.gridProxy.setValidSides(EnumSet.allOf(ForgeDirection.class));
            } else {
                this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
            }
        }
        this.updateMeta();
    }

    private void updateMeta() {
        if (!this.gridProxy.isReady()) {
            return;
        }
        int meta = 0;
        try {
            if (this.gridProxy.getEnergy().isNetworkPowered()) {
                meta = 1;
                if (this.gridProxy.getPath().getControllerState() == ControllerState.CONTROLLER_CONFLICT) {
                    meta = 2;
                }
            }
        }
        catch (GridAccessException e) {
            meta = 0;
        }
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 2);
    }

    @Override
    public IInventory getInternalInventory() {
        return inv;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }
}

