/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.util.SettingsFrom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyCell
extends AENetworkTile
implements IAEPowerStorage {
    protected double internalCurrentPower = 0.0;
    protected double internalMaxPower = 200000.0;
    private byte currentMeta = (byte)-1;

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    private void changePowerLevel() {
        if (this.notLoaded()) {
            return;
        }
        byte leel = (byte)(8.0 * (this.internalCurrentPower / this.internalMaxPower));
        if (leel > 7) {
            leel = 7;
        }
        if (leel < 0) {
            leel = 0;
        }
        if (this.currentMeta != leel) {
            this.currentMeta = leel;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)this.currentMeta, 2);
        }
    }

    public TileEnergyCell() {
        this.gridProxy.setIdlePowerUsage(0.0);
        this.addNewHandler(new TileEnergyCellHandler());
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            double fakeBattery = this.internalCurrentPower + amt;
            if (fakeBattery > this.internalMaxPower) {
                return fakeBattery - this.internalMaxPower;
            }
            return 0.0;
        }
        if (this.internalCurrentPower < 0.01 && amt > 0.01) {
            this.gridProxy.getNode().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.PROVIDE_POWER));
        }
        this.internalCurrentPower += amt;
        if (this.internalCurrentPower > this.internalMaxPower) {
            amt = this.internalCurrentPower - this.internalMaxPower;
            this.internalCurrentPower = this.internalMaxPower;
            this.changePowerLevel();
            return amt;
        }
        this.changePowerLevel();
        return 0.0;
    }

    private final double extractAEPower(double amt, Actionable mode) {
        boolean wasFull;
        if (mode == Actionable.SIMULATE) {
            if (this.internalCurrentPower > amt) {
                return amt;
            }
            return this.internalCurrentPower;
        }
        boolean bl = wasFull = this.internalCurrentPower >= this.internalMaxPower - 0.001;
        if (wasFull && amt > 0.001) {
            try {
                this.gridProxy.getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            catch (GridAccessException e) {
                // empty catch block
            }
        }
        if (this.internalCurrentPower > amt) {
            this.internalCurrentPower -= amt;
            this.changePowerLevel();
            return amt;
        }
        amt = this.internalCurrentPower;
        this.internalCurrentPower = 0.0;
        this.changePowerLevel();
        return amt;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        return pm.divide(this.extractAEPower(pm.multiply(amt), mode));
    }

    @Override
    public double getAEMaxPower() {
        return this.internalMaxPower;
    }

    @Override
    public double getAECurrentPower() {
        return this.internalCurrentPower;
    }

    @Override
    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public void onReady() {
        super.onReady();
        this.currentMeta = (byte)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.changePowerLevel();
    }

    @Override
    public NBTTagCompound downloadSettings(SettingsFrom from) {
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("internalCurrentPower", this.internalCurrentPower);
            tag.func_74780_a("internalMaxPower", this.internalMaxPower);
            return tag;
        }
        return null;
    }

    @Override
    public void uploadSettings(SettingsFrom from, NBTTagCompound compound) {
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            this.internalCurrentPower = compound.func_74769_h("internalCurrentPower");
        }
    }

    private class TileEnergyCellHandler
    extends AETileEventHandler {
        public TileEnergyCellHandler() {
            super(TileEventType.WORLD_NBT);
        }

        @Override
        public void writeToNBT(NBTTagCompound data) {
            if (!((TileEnergyCell)TileEnergyCell.this).field_145850_b.field_72995_K) {
                data.func_74780_a("internalCurrentPower", TileEnergyCell.this.internalCurrentPower);
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound data) {
            TileEnergyCell.this.internalCurrentPower = data.func_74769_h("internalCurrentPower");
        }
    }
}

