/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.me.GridAccessException;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileWireless
extends AENetworkInvTile
implements IWirelessAccessPoint,
IPowerChannelState {
    public static final int POWERED_FLAG = 1;
    public static final int CHANNEL_FLAG = 2;
    final int[] sides = new int[]{0};
    AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    public int clientFlags = 0;

    public TileWireless() {
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
        this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        this.addNewHandler(new TileWirelessHandler());
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        super.setOrientation(inForward, inUp);
        this.gridProxy.setValidSides(EnumSet.of(this.getForward().getOpposite()));
    }

    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.markForUpdate();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onReady() {
        this.updatePower();
        super.onReady();
    }

    public void func_70296_d() {
        this.updatePower();
    }

    private void updatePower() {
        this.gridProxy.setIdlePowerUsage(AEConfig.instance.wireless_getPowerDrain(this.getBoosters()));
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }

    @Override
    public double getRange() {
        return AEConfig.instance.wireless_getMaxRange(this.getBoosters());
    }

    @Override
    public boolean isActive() {
        if (Platform.isClient()) {
            return this.isPowered() && 2 == (this.clientFlags & 2);
        }
        return this.gridProxy.isActive();
    }

    @Override
    public IGrid getGrid() {
        try {
            return this.gridProxy.getGrid();
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    private int getBoosters() {
        ItemStack boosters = this.inv.func_70301_a(0);
        return boosters == null ? 0 : boosters.field_77994_a;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public boolean isPowered() {
        return 1 == (this.clientFlags & 1);
    }

    class TileWirelessHandler
    extends AETileEventHandler {
        public TileWirelessHandler() {
            super(TileEventType.NETWORK);
        }

        @Override
        public boolean readFromStream(ByteBuf data) throws IOException {
            boolean eh = super.readFromStream(data);
            int old = TileWireless.this.clientFlags;
            TileWireless.this.clientFlags = data.readByte();
            return eh || old != TileWireless.this.clientFlags;
        }

        @Override
        public void writeToStream(ByteBuf data) throws IOException {
            TileWireless.this.clientFlags = 0;
            try {
                if (TileWireless.this.gridProxy.getEnergy().isNetworkPowered()) {
                    TileWireless.this.clientFlags |= 1;
                }
                if (TileWireless.this.gridProxy.getNode().meetsChannelRequirements()) {
                    TileWireless.this.clientFlags |= 2;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            data.writeByte((int)((byte)TileWireless.this.clientFlags));
        }
    }
}

