/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.tile.AEBaseInvTile;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import java.util.EnumSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AERootPoweredTile
extends AEBaseInvTile
implements IAEPowerStorage {
    protected double internalMaxPower = 10000.0;
    protected boolean internalCanAcceptPower = true;
    protected boolean internalPublicPowerStorage = false;
    private EnumSet<ForgeDirection> internalPowerSides = EnumSet.allOf(ForgeDirection.class);
    protected AccessRestriction internalPowerFlow = AccessRestriction.READ_WRITE;
    protected double internalCurrentPower = 0.0;

    protected void setPowerSides(EnumSet<ForgeDirection> sides) {
        this.internalPowerSides = sides;
    }

    protected EnumSet<ForgeDirection> getPowerSides() {
        return this.internalPowerSides.clone();
    }

    public AERootPoweredTile() {
        this.addNewHandler(new AEPoweredRootHandler());
    }

    protected final double getExternalPowerDemand(PowerUnits externalUnit, double maxPowerRequired) {
        return PowerUnits.AE.convertTo(externalUnit, Math.max(0.0, this.getFunnelPowerDemand(externalUnit.convertTo(PowerUnits.AE, maxPowerRequired))));
    }

    protected double getFunnelPowerDemand(double maxRequired) {
        return this.internalMaxPower - this.internalCurrentPower;
    }

    public final double injectExternalPower(PowerUnits input, double amt) {
        return PowerUnits.AE.convertTo(input, this.funnelPowerIntoStorage(input.convertTo(PowerUnits.AE, amt), Actionable.MODULATE));
    }

    protected double funnelPowerIntoStorage(double AEUnits, Actionable mode) {
        return this.injectAEPower(AEUnits, mode);
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        if (amt < 1.0E-6) {
            return 0.0;
        }
        if (mode == Actionable.SIMULATE) {
            double fakeBattery = this.internalCurrentPower + amt;
            if (fakeBattery > this.internalMaxPower) {
                return fakeBattery - this.internalMaxPower;
            }
            return 0.0;
        }
        if (this.internalCurrentPower < 0.01 && amt > 0.01) {
            this.PowerEvent(MENetworkPowerStorage.PowerEventType.PROVIDE_POWER);
        }
        this.internalCurrentPower += amt;
        if (this.internalCurrentPower > this.internalMaxPower) {
            amt = this.internalCurrentPower - this.internalMaxPower;
            this.internalCurrentPower = this.internalMaxPower;
            return amt;
        }
        return 0.0;
    }

    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
    }

    protected double extractAEPower(double amt, Actionable mode) {
        boolean wasFull;
        if (mode == Actionable.SIMULATE) {
            if (this.internalCurrentPower > amt) {
                return amt;
            }
            return this.internalCurrentPower;
        }
        boolean bl = wasFull = this.internalCurrentPower >= this.internalMaxPower - 0.001;
        if (wasFull && amt > 0.001) {
            this.PowerEvent(MENetworkPowerStorage.PowerEventType.REQUEST_POWER);
        }
        if (this.internalCurrentPower > amt) {
            this.internalCurrentPower -= amt;
            return amt;
        }
        amt = this.internalCurrentPower;
        this.internalCurrentPower = 0.0;
        return amt;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier multiplier) {
        return multiplier.divide(this.extractAEPower(multiplier.multiply(amt), mode));
    }

    @Override
    public final double getAEMaxPower() {
        return this.internalMaxPower;
    }

    @Override
    public final double getAECurrentPower() {
        return this.internalCurrentPower;
    }

    @Override
    public final boolean isAEPublicPowerStorage() {
        return this.internalPublicPowerStorage;
    }

    @Override
    public final AccessRestriction getPowerFlow() {
        return this.internalPowerFlow;
    }

    private class AEPoweredRootHandler
    extends AETileEventHandler {
        public AEPoweredRootHandler() {
            super(TileEventType.WORLD_NBT);
        }

        @Override
        public void writeToNBT(NBTTagCompound data) {
            data.func_74780_a("internalCurrentPower", AERootPoweredTile.this.internalCurrentPower);
        }

        @Override
        public void readFromNBT(NBTTagCompound data) {
            AERootPoweredTile.this.internalCurrentPower = data.func_74769_h("internalCurrentPower");
        }
    }
}

