/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.PowerUnits;
import appeng.tile.powersink.RotaryCraft;
import appeng.transformer.annotations.integration;
import cofh.api.energy.IEnergyHandler;
import net.minecraftforge.common.util.ForgeDirection;

@integration.Interface(iname="RF", iface="cofh.api.energy.IEnergyHandler")
public abstract class RedstoneFlux
extends RotaryCraft
implements IEnergyHandler {
    public final int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (simulate) {
            double demand = this.getExternalPowerDemand(PowerUnits.RF, maxReceive);
            if (demand > (double)maxReceive) {
                return maxReceive;
            }
            return (int)Math.floor((double)maxReceive - demand);
        }
        int demand = (int)Math.floor(this.getExternalPowerDemand(PowerUnits.RF, maxReceive));
        int ignored = 0;
        int insertAmt = maxReceive;
        if (insertAmt > demand) {
            ignored = insertAmt - demand;
            insertAmt = demand;
        }
        double overFlow = this.injectExternalPower(PowerUnits.RF, insertAmt);
        double ox = Math.floor(overFlow);
        this.internalCurrentPower += PowerUnits.RF.convertTo(PowerUnits.AE, overFlow - ox);
        return maxReceive - ((int)ox + ignored);
    }

    public final int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public final boolean canConnectEnergy(ForgeDirection from) {
        return this.internalCanAcceptPower && this.getPowerSides().contains(from);
    }

    public final int getEnergyStored(ForgeDirection from) {
        return (int)Math.floor(PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower()));
    }

    public final int getMaxEnergyStored(ForgeDirection from) {
        return (int)Math.floor(PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower()));
    }
}

