/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.qnb;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.QuantumCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileQuantumBridge
extends AENetworkInvTile
implements IAEMultiBlock {
    private static final ItemStack ring = AEApi.instance().blocks().blockQuantumRing.stack(1);
    final int[] sidesRing = new int[0];
    final int[] sidesLink = new int[]{0};
    AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    public final byte corner = (byte)16;
    final byte hasSingularity = (byte)32;
    final byte powered = (byte)64;
    private QuantumCalculator calc = new QuantumCalculator(this);
    byte xdex = (byte)-1;
    QuantumCluster clust;
    public boolean bridgePowered;
    private boolean updateStatus = false;

    public TileQuantumBridge() {
        this.addNewHandler(new QBridgeHandler());
        this.gridProxy.setFlags(GridFlags.DENSE_CAPACITY);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @MENetworkEventSubscribe
    public void PowerSwitch(MENetworkPowerStatusChange c) {
        this.updateStatus = true;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.clust != null) {
            this.clust.updateStatus(true);
        }
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        if (this.isCenter()) {
            return this.sidesLink;
        }
        return this.sidesRing;
    }

    @Override
    public void disconnect(boolean affectWorld) {
        if (this.clust != null) {
            if (!affectWorld) {
                this.clust.updateStatus = false;
            }
            this.clust.destroy();
        }
        this.clust = null;
        if (affectWorld) {
            this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        }
    }

    @Override
    public IAECluster getCluster() {
        return this.clust;
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Override
    public void onReady() {
        super.onReady();
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) == AEApi.instance().blocks().blockQuantumRing.block()) {
            this.gridProxy.setVisualRepresentation(ring);
        }
    }

    @Override
    public void func_145843_s() {
        this.disconnect(false);
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        this.disconnect(false);
        super.onChunkUnload();
    }

    public void updateStatus(QuantumCluster c, byte flags, boolean affectWorld) {
        this.clust = c;
        if (affectWorld) {
            if (this.xdex != flags) {
                this.xdex = flags;
                this.markForUpdate();
            }
            if (this.isCorner() || this.isCenter()) {
                this.gridProxy.setValidSides(this.getConnections());
            } else {
                this.gridProxy.setValidSides(EnumSet.allOf(ForgeDirection.class));
            }
        }
    }

    public long getQEDest() {
        NBTTagCompound c;
        ItemStack is = this.inv.func_70301_a(0);
        if (is != null && (c = is.func_77978_p()) != null) {
            return c.func_74763_f("freq");
        }
        return 0L;
    }

    public boolean isCenter() {
        return this.func_145838_q() == AEApi.instance().blocks().blockQuantumLink.block();
    }

    public boolean isCorner() {
        return (this.xdex & 0x10) == 16 && this.xdex != -1;
    }

    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.xdex & 0x40) == 64 && this.xdex != -1;
        }
        try {
            return this.gridProxy.getEnergy().isNetworkPowered();
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    public boolean isFormed() {
        return this.xdex != -1;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    public void neighborUpdate() {
        this.calc.calculateMultiblock(this.field_145850_b, this.getLocation());
    }

    public EnumSet<ForgeDirection> getConnections() {
        EnumSet<ForgeDirection> set = EnumSet.noneOf(ForgeDirection.class);
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + d.offsetX, this.field_145848_d + d.offsetY, this.field_145849_e + d.offsetZ);
            if (!(te instanceof TileQuantumBridge)) continue;
            set.add(d);
        }
        return set;
    }

    public boolean hasQES() {
        if (this.xdex == -1) {
            return false;
        }
        return (this.xdex & 0x20) == 32;
    }

    public void breakCluster() {
        if (this.clust != null) {
            this.clust.destroy();
        }
    }

    class QBridgeHandler
    extends AETileEventHandler {
        public QBridgeHandler() {
            super(TileEventType.NETWORK, TileEventType.TICK);
            TileQuantumBridge.this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
            TileQuantumBridge.this.gridProxy.setFlags(GridFlags.DENSE_CAPACITY);
            TileQuantumBridge.this.gridProxy.setIdlePowerUsage(22.0);
            TileQuantumBridge.this.inv.setMaxStackSize(1);
        }

        @Override
        public void Tick() {
            if (TileQuantumBridge.this.updateStatus) {
                TileQuantumBridge.this.updateStatus = false;
                if (TileQuantumBridge.this.clust != null) {
                    TileQuantumBridge.this.clust.updateStatus(true);
                }
                TileQuantumBridge.this.markForUpdate();
            }
        }

        @Override
        public void writeToStream(ByteBuf data) throws IOException {
            int out = TileQuantumBridge.this.xdex;
            if (TileQuantumBridge.this.func_70301_a(0) != null && TileQuantumBridge.this.xdex != -1) {
                out |= 0x20;
            }
            if (TileQuantumBridge.this.gridProxy.isActive() && TileQuantumBridge.this.xdex != -1) {
                out |= 0x40;
            }
            data.writeByte((int)((byte)out));
        }

        @Override
        public boolean readFromStream(ByteBuf data) throws IOException {
            byte oldValue = TileQuantumBridge.this.xdex;
            TileQuantumBridge.this.xdex = data.readByte();
            TileQuantumBridge.this.bridgePowered = (TileQuantumBridge.this.xdex | 0x40) == 64;
            return TileQuantumBridge.this.xdex != oldValue;
        }
    }
}

