/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.spatial;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.YesNo;
import appeng.api.implementations.TransitionResult;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkSpatialEvent;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.hooks.TickHandler;
import appeng.items.storage.ItemSpatialStorageCell;
import appeng.me.cache.SpatialPylonCache;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import java.util.concurrent.Callable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSpatialIOPort
extends AENetworkInvTile
implements Callable {
    final int[] sides = new int[]{0, 1};
    AppEngInternalInventory inv = new AppEngInternalInventory(this, 2);
    YesNo lastRedstoneState = YesNo.UNDECIDED;

    public TileSpatialIOPort() {
        this.addNewHandler(new SpatialTileIOPortHandler());
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL);
    }

    public void updateRedstoneState() {
        YesNo currentState;
        YesNo yesNo = currentState = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) ? YesNo.YES : YesNo.NO;
        if (this.lastRedstoneState != currentState) {
            this.lastRedstoneState = currentState;
            if (this.lastRedstoneState == YesNo.YES) {
                this.triggerTransition();
            }
        }
    }

    public boolean getRedstoneState() {
        if (this.lastRedstoneState == YesNo.UNDECIDED) {
            this.updateRedstoneState();
        }
        return this.lastRedstoneState == YesNo.YES;
    }

    private void triggerTransition() {
        ItemStack cell;
        if (Platform.isServer() && this.isSpatialCell(cell = this.func_70301_a(0))) {
            TickHandler.instance.addCallable(null, this);
        }
    }

    public Object call() throws Exception {
        ItemStack cell = this.func_70301_a(0);
        if (this.isSpatialCell(cell) && this.func_70301_a(1) == null) {
            MENetworkEvent res;
            double req;
            double pr;
            IGrid gi = this.gridProxy.getGrid();
            IEnergyGrid energy = this.gridProxy.getEnergy();
            ItemSpatialStorageCell sc = (ItemSpatialStorageCell)cell.func_77973_b();
            SpatialPylonCache spc = (SpatialPylonCache)gi.getCache(ISpatialCache.class);
            if (spc.hasRegion() && spc.isValidRegion() && Math.abs((pr = energy.extractAEPower(req = (double)spc.requiredPower(), Actionable.SIMULATE, PowerMultiplier.CONFIG)) - req) < req * 0.001 && !(res = gi.postEvent(new MENetworkSpatialEvent(this, req))).isCanceled()) {
                TransitionResult tr = sc.doSpatialTransition(cell, this.field_145850_b, spc.getMin(), spc.getMax(), true);
                if (tr.success) {
                    energy.extractAEPower(req, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.func_70299_a(0, null);
                    this.func_70299_a(1, cell);
                }
            }
        }
        return null;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 ? this.isSpatialCell(itemstack) : false;
    }

    private boolean isSpatialCell(ItemStack cell) {
        if (cell != null && cell.func_77973_b() instanceof ISpatialStorageCell) {
            ISpatialStorageCell sc = (ISpatialStorageCell)cell.func_77973_b();
            return sc != null && sc.isSpatialStorage(cell);
        }
        return false;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }

    class SpatialTileIOPortHandler
    extends AETileEventHandler {
        public SpatialTileIOPortHandler() {
            super(TileEventType.WORLD_NBT);
        }

        @Override
        public void writeToNBT(NBTTagCompound data) {
            data.func_74768_a("lastRedstoneState", TileSpatialIOPort.this.lastRedstoneState.ordinal());
        }

        @Override
        public void readFromNBT(NBTTagCompound data) {
            if (data.func_74764_b("lastRedstoneState")) {
                TileSpatialIOPort.this.lastRedstoneState = YesNo.values()[data.func_74762_e("lastRedstoneState")];
            }
        }
    }
}

