/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.spatial;

import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.me.GridAccessException;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.SpatialPylonCalculator;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.AENetworkProxyMultiblock;
import appeng.tile.events.AETileEventHandler;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumSet;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSpatialPylon
extends AENetworkTile
implements IAEMultiBlock {
    public final int DISPLAY_ENDMIN = 1;
    public final int DISPLAY_ENDMAX = 2;
    public final int DISPLAY_MIDDLE = 3;
    public final int DISPLAY_X = 4;
    public final int DISPLAY_Y = 8;
    public final int DISPLAY_Z = 12;
    public final int MB_STATUS = 15;
    public final int DISPLAY_ENABLED = 16;
    public final int DISPLAY_POWEREDENABLED = 32;
    public final int NET_STATUS = 48;
    int displayBits = 0;
    SpatialPylonCluster clust;
    final SpatialPylonCalculator calc = new SpatialPylonCalculator(this);
    boolean didHaveLight = false;

    @Override
    protected AENetworkProxy createProxy() {
        return new AENetworkProxyMultiblock(this, "proxy", this.getItemFromTile(this), true);
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    public TileSpatialPylon() {
        this.gridProxy.setFlags(GridFlags.REQUIRE_CHANNEL, GridFlags.MULTIBLOCK);
        this.gridProxy.setIdlePowerUsage(0.5);
        this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        this.addNewHandler(new TileSpatialPylonHandler());
    }

    @Override
    public void onReady() {
        super.onReady();
        this.onNeighborBlockChange();
    }

    @Override
    public void markForUpdate() {
        boolean hasLight;
        super.markForUpdate();
        boolean bl = hasLight = this.getLightValue() > 0;
        if (hasLight != this.didHaveLight) {
            this.didHaveLight = hasLight;
            this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getLightValue() {
        if ((this.displayBits & 0x20) == 32) {
            return 8;
        }
        return 0;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    @MENetworkEventSubscribe
    public void activeRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    @Override
    public void func_145843_s() {
        this.disconnect(false);
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        this.disconnect(false);
        super.onChunkUnload();
    }

    public void onNeighborBlockChange() {
        this.calc.calculateMultiblock(this.field_145850_b, this.getLocation());
    }

    @Override
    public SpatialPylonCluster getCluster() {
        return this.clust;
    }

    public void recalculateDisplay() {
        int oldBits = this.displayBits;
        this.displayBits = 0;
        if (this.clust != null) {
            this.displayBits = this.clust.min.equals(this.getLocation()) ? 1 : (this.clust.max.equals(this.getLocation()) ? 2 : 3);
            switch (this.clust.currentAxis) {
                case X: {
                    this.displayBits |= 4;
                    break;
                }
                case Y: {
                    this.displayBits |= 8;
                    break;
                }
                case Z: {
                    this.displayBits |= 0xC;
                    break;
                }
                default: {
                    this.displayBits = 0;
                }
            }
            try {
                if (this.gridProxy.getEnergy().isNetworkPowered()) {
                    this.displayBits |= 0x20;
                }
                if (this.clust.isValid && this.gridProxy.isActive()) {
                    this.displayBits |= 0x10;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (oldBits != this.displayBits) {
            this.markForUpdate();
        }
    }

    public void updateStatus(SpatialPylonCluster c) {
        this.clust = c;
        this.gridProxy.setValidSides(c == null ? EnumSet.noneOf(ForgeDirection.class) : EnumSet.allOf(ForgeDirection.class));
        this.recalculateDisplay();
    }

    @Override
    public void disconnect(boolean b) {
        if (this.clust != null) {
            this.clust.destroy();
            this.updateStatus(null);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public int getDisplayBits() {
        return this.displayBits;
    }

    private class TileSpatialPylonHandler
    extends AETileEventHandler {
        public TileSpatialPylonHandler() {
            super(TileEventType.NETWORK);
        }

        @Override
        public boolean readFromStream(ByteBuf data) throws IOException {
            int old = TileSpatialPylon.this.displayBits;
            TileSpatialPylon.this.displayBits = data.readByte();
            return old != TileSpatialPylon.this.displayBits;
        }

        @Override
        public void writeToStream(ByteBuf data) throws IOException {
            data.writeByte(TileSpatialPylon.this.displayBits);
        }
    }
}

