/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.util.IConfigManager;
import appeng.core.AELog;
import appeng.util.IConfigManagerHost;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;

public class ConfigManager
implements IConfigManager {
    HashMap<Enum, Enum> Settings = new HashMap();
    IConfigManagerHost target;

    public ConfigManager(IConfigManagerHost tile) {
        this.target = tile;
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        for (Enum key : this.Settings.keySet()) {
            try {
                if (!tagCompound.func_74764_b(key.name())) continue;
                String value = tagCompound.func_74779_i(key.name());
                Enum oldValue = this.Settings.get(key);
                Object newValue = Enum.valueOf(oldValue.getClass(), value);
                this.putSetting(key, (Enum)newValue);
            }
            catch (IllegalArgumentException e) {
                AELog.error(e);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        for (Enum e : this.Settings.keySet()) {
            tagCompound.func_74778_a(e.name(), this.Settings.get(e).toString());
        }
    }

    @Override
    public Set<Enum> getSettings() {
        return this.Settings.keySet();
    }

    @Override
    public void registerSetting(Enum settingName, Enum defaultValue) {
        this.Settings.put(settingName, defaultValue);
    }

    @Override
    public Enum getSetting(Enum settingName) {
        Enum oldValue = this.Settings.get(settingName);
        if (oldValue != null) {
            return oldValue;
        }
        throw new RuntimeException("Invalid Config setting");
    }

    @Override
    public Enum putSetting(Enum settingName, Enum newValue) {
        Enum oldValue = this.getSetting(settingName);
        this.Settings.put(settingName, newValue);
        this.target.updateSetting(this, settingName, newValue);
        return oldValue;
    }
}

