/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class SortedList<T>
implements Iterable<T>,
List<T>,
Cloneable {
    private boolean sorted = true;
    private final Comparator<T> comp;
    private final LinkedList<T> storage = new LinkedList();

    private void makeSorted() {
        if (!this.sorted) {
            this.sorted = true;
            Collections.sort(this.storage, this.comp);
        }
    }

    public SortedList(Comparator<T> comp) {
        this.comp = comp;
    }

    @Override
    public boolean add(T input) {
        this.sorted = false;
        return this.storage.add(input);
    }

    @Override
    public boolean addAll(Collection<? extends T> input) {
        if (!input.isEmpty()) {
            this.sorted = false;
        }
        return this.storage.addAll(input);
    }

    @Override
    public void clear() {
        this.sorted = true;
        this.storage.clear();
    }

    @Override
    public boolean contains(Object input) {
        return this.storage.contains(input);
    }

    @Override
    public boolean containsAll(Collection<?> input) {
        return this.storage.containsAll(input);
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        this.makeSorted();
        return this.storage.iterator();
    }

    public Iterator<T> reverseIterator() {
        this.makeSorted();
        final ListIterator<T> listIterator = this.listIterator(this.size());
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return listIterator.hasPrevious();
            }

            @Override
            public T next() {
                return listIterator.previous();
            }

            @Override
            public void remove() {
                listIterator.remove();
            }
        };
    }

    @Override
    public boolean remove(Object input) {
        return this.storage.remove(input);
    }

    @Override
    public boolean removeAll(Collection<?> input) {
        return this.storage.removeAll(input);
    }

    @Override
    public boolean retainAll(Collection<?> input) {
        return this.storage.retainAll(input);
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    @Override
    public Object[] toArray() {
        return this.storage.toArray();
    }

    @Override
    public <X> X[] toArray(X[] input) {
        return this.storage.toArray(input);
    }

    public Comparator<? super T> comparator() {
        return this.comp;
    }

    public T first() {
        this.makeSorted();
        return this.storage.peekFirst();
    }

    public T last() {
        this.makeSorted();
        return this.storage.peekLast();
    }

    @Override
    public void add(int index, T element) {
        this.makeSorted();
        this.sorted = false;
        this.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.sorted = false;
        return this.addAll(index, c);
    }

    @Override
    public T get(int index) {
        this.makeSorted();
        return this.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.makeSorted();
        return this.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.makeSorted();
        return this.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        this.makeSorted();
        return this.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        this.makeSorted();
        return this.listIterator(index);
    }

    @Override
    public T remove(int index) {
        this.makeSorted();
        return this.remove(index);
    }

    @Override
    public T set(int index, T element) {
        this.makeSorted();
        this.sorted = false;
        return this.set(index, element);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        this.makeSorted();
        return this.storage.subList(fromIndex, toIndex);
    }
}

