/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.IInventoryWrapper;
import appeng.util.inv.ItemSlot;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class AdaptorIInventory
extends InventoryAdaptor {
    private IInventory i;
    private boolean wrapperEnabled;

    public AdaptorIInventory(IInventory s) {
        this.i = s;
        this.wrapperEnabled = s instanceof IInventoryWrapper;
    }

    boolean canRemoveStackFromSlot(int x, ItemStack is) {
        if (this.wrapperEnabled) {
            return ((IInventoryWrapper)this.i).canRemoveItemFromSlot(x, is);
        }
        return true;
    }

    @Override
    public boolean containsItems() {
        int s = this.i.func_70302_i_();
        for (int x = 0; x < s; ++x) {
            if (this.i.func_70301_a(x) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack removeSimilarItems(int how_many, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        for (int x = 0; x < s; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is == null || !this.canRemoveStackFromSlot(x, is) || filter != null && !Platform.isSameItemFuzzy(is, filter, fuzzyMode)) continue;
            int lhow_many = how_many;
            if (lhow_many > is.field_77994_a) {
                lhow_many = is.field_77994_a;
            }
            if (destination != null && !destination.canInsert(is)) {
                lhow_many = 0;
            }
            ItemStack rv = null;
            if (lhow_many > 0) {
                rv = is.func_77946_l();
                rv.field_77994_a = lhow_many;
                if (is.field_77994_a == rv.field_77994_a) {
                    this.i.func_70299_a(x, null);
                    this.i.func_70296_d();
                } else {
                    ItemStack po = is.func_77946_l();
                    po.field_77994_a -= rv.field_77994_a;
                    this.i.func_70299_a(x, po);
                    this.i.func_70296_d();
                }
            }
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    @Override
    public ItemStack simulateSimilarRemove(int how_many, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        for (int x = 0; x < s; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is == null || !this.canRemoveStackFromSlot(x, is) || filter != null && !Platform.isSameItemFuzzy(is, filter, fuzzyMode)) continue;
            int lhow_many = how_many;
            if (lhow_many > is.field_77994_a) {
                lhow_many = is.field_77994_a;
            }
            if (destination != null && !destination.canInsert(is)) {
                lhow_many = 0;
            }
            if (lhow_many <= 0) continue;
            ItemStack rv = is.func_77946_l();
            rv.field_77994_a = lhow_many;
            return rv;
        }
        return null;
    }

    @Override
    public ItemStack removeItems(int how_many, ItemStack filter, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        ItemStack rv = null;
        for (int x = 0; x < s && how_many > 0; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is == null || !this.canRemoveStackFromSlot(x, is) || filter != null && !Platform.isSameItemPrecise(is, filter)) continue;
            int lhow_many = how_many;
            if (lhow_many > is.field_77994_a) {
                lhow_many = is.field_77994_a;
            }
            if (destination != null && !destination.canInsert(is)) {
                lhow_many = 0;
            }
            if (lhow_many <= 0) continue;
            if (rv == null) {
                filter = rv = is.func_77946_l();
                rv.field_77994_a = lhow_many;
                how_many -= lhow_many;
            } else {
                rv.field_77994_a += lhow_many;
                how_many -= lhow_many;
            }
            if (is.field_77994_a == lhow_many) {
                this.i.func_70299_a(x, null);
                this.i.func_70296_d();
                continue;
            }
            ItemStack po = is.func_77946_l();
            po.field_77994_a -= lhow_many;
            this.i.func_70299_a(x, po);
            this.i.func_70296_d();
        }
        return rv;
    }

    @Override
    public ItemStack simulateRemove(int how_many, ItemStack filter, IInventoryDestination destination) {
        int s = this.i.func_70302_i_();
        ItemStack rv = null;
        for (int x = 0; x < s && how_many > 0; ++x) {
            ItemStack is = this.i.func_70301_a(x);
            if (is == null || !this.canRemoveStackFromSlot(x, is) || filter != null && !Platform.isSameItemPrecise(is, filter)) continue;
            int lhow_many = how_many;
            if (lhow_many > is.field_77994_a) {
                lhow_many = is.field_77994_a;
            }
            if (destination != null && !destination.canInsert(is)) {
                lhow_many = 0;
            }
            if (lhow_many <= 0) continue;
            if (rv == null) {
                rv = is.func_77946_l();
                rv.field_77994_a = lhow_many;
                how_many -= lhow_many;
                continue;
            }
            rv.field_77994_a += lhow_many;
            how_many -= lhow_many;
        }
        return rv;
    }

    @Override
    public ItemStack addItems(ItemStack A) {
        if (A == null) {
            return null;
        }
        if (A.field_77994_a == 0) {
            return null;
        }
        ItemStack left = A.func_77946_l();
        int stack_limit = A.func_77976_d();
        if (stack_limit > this.i.func_70297_j_()) {
            stack_limit = this.i.func_70297_j_();
        }
        int s = this.i.func_70302_i_();
        for (int pass = 0; pass < 2; ++pass) {
            for (int x = 0; x < s; ++x) {
                if (!this.i.func_94041_b(x, A)) continue;
                ItemStack is = this.i.func_70301_a(x);
                if (is == null && pass != 0) {
                    ItemStack thisSlot = left.func_77946_l();
                    if (thisSlot.field_77994_a > stack_limit) {
                        thisSlot.field_77994_a = stack_limit;
                    }
                    left.field_77994_a -= thisSlot.field_77994_a;
                    this.i.func_70299_a(x, thisSlot);
                    if (left.field_77994_a > 0) continue;
                    return null;
                }
                if (is == null || !Platform.isSameItemPrecise(is, left) || is.field_77994_a >= stack_limit) continue;
                int used = left.field_77994_a;
                int room = stack_limit - is.field_77994_a;
                if (used > room) {
                    used = room;
                }
                is.field_77994_a += used;
                this.i.func_70299_a(x, is);
                this.i.func_70296_d();
                left.field_77994_a -= used;
                if (left.field_77994_a > 0) continue;
                return null;
            }
        }
        return left;
    }

    @Override
    public ItemStack simulateAdd(ItemStack A) {
        if (A == null) {
            return A;
        }
        ItemStack left = A.func_77946_l();
        int stack_limit = A.func_77976_d();
        if (stack_limit > this.i.func_70297_j_()) {
            stack_limit = this.i.func_70297_j_();
        }
        int s = this.i.func_70302_i_();
        for (int x = 0; x < s; ++x) {
            if (!this.i.func_94041_b(x, A)) continue;
            ItemStack is = this.i.func_70301_a(x);
            if (is == null) {
                ItemStack thisSlot = left.func_77946_l();
                if (thisSlot.field_77994_a > stack_limit) {
                    thisSlot.field_77994_a = stack_limit;
                }
                left.field_77994_a -= thisSlot.field_77994_a;
                if (left.field_77994_a > 0) continue;
                return null;
            }
            if (!Platform.isSameItemPrecise(is, left) || is.field_77994_a >= stack_limit) continue;
            int used = left.field_77994_a;
            int room = stack_limit - is.field_77994_a;
            if (used > room) {
                used = room;
            }
            left.field_77994_a -= used;
            if (left.field_77994_a > 0) continue;
            return null;
        }
        return left;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new InvIterator();
    }

    class InvIterator
    implements Iterator<ItemSlot> {
        final ItemSlot is = new ItemSlot();
        int x = 0;

        InvIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.x < AdaptorIInventory.this.i.func_70302_i_();
        }

        @Override
        public ItemSlot next() {
            ItemStack iss = AdaptorIInventory.this.i.func_70301_a(this.x);
            this.is.isExtractable = AdaptorIInventory.this.canRemoveStackFromSlot(this.x, iss);
            this.is.setItemStack(iss);
            this.is.slot = this.x++;
            return this.is;
        }

        @Override
        public void remove() {
        }
    }
}

