/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAETagCompound;
import appeng.util.Platform;
import appeng.util.item.AEItemDef;
import appeng.util.item.AESharedNBT;
import appeng.util.item.AEStack;
import appeng.util.item.OreHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class AEItemStack
extends AEStack<IAEItemStack>
implements IAEItemStack,
Comparable<AEItemStack> {
    AEItemDef def;

    public String toString() {
        return this.getItemStack().toString();
    }

    @Override
    public void add(IAEItemStack option) {
        if (option == null) {
            return;
        }
        this.incStackSize(option.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + option.getCountRequestable());
        this.setCraftable(this.isCraftable() || option.isCraftable());
    }

    private AEItemStack(AEItemStack is) {
        this.def = is.def;
        this.stackSize = is.stackSize;
        this.setCraftable(is.isCraftable());
        this.setCountRequestable(is.getCountRequestable());
    }

    protected AEItemStack(ItemStack is) {
        if (is == null) {
            throw new RuntimeException("Invalid Itemstack.");
        }
        this.def = new AEItemDef(is.func_77973_b());
        if (this.def.item == null) {
            throw new RuntimeException("This ItemStack is bad, it has a null item.");
        }
        this.def.damageValue = this.def.getDamageValueHack(is);
        this.def.dspDamage = is.func_77952_i();
        this.def.maxDamage = is.func_77958_k();
        NBTTagCompound tagCompound = is.func_77978_p();
        if (tagCompound != null) {
            this.def.tagCompound = (AESharedNBT)AESharedNBT.getSharedTagCompound(tagCompound, is);
        }
        this.stackSize = is.field_77994_a;
        this.setCraftable(false);
        this.setCountRequestable(0L);
        this.def.reHash();
        this.def.isOre = OreHelper.instance.isOre(is);
    }

    public static AEItemStack create(Object a) {
        if (a instanceof ItemStack) {
            return new AEItemStack((ItemStack)a);
        }
        if (a instanceof IAEItemStack) {
            ((IAEItemStack)a).copy();
        }
        return null;
    }

    @Override
    public Item getItem() {
        return this.def.item;
    }

    @Override
    public boolean equals(Object ia) {
        ItemStack is;
        if (ia instanceof AEItemStack) {
            return ((AEItemStack)ia).def.equals(this.def);
        }
        if (ia instanceof ItemStack && (is = (ItemStack)ia).func_77973_b() == this.def.item && is.func_77960_j() == this.def.damageValue) {
            AESharedNBT ta = this.def.tagCompound;
            NBTTagCompound tb = is.func_77978_p();
            if (ta == tb) {
                return true;
            }
            if (ta == null && tb == null || ta != null && ta.func_82582_d() && tb == null || tb != null && tb.func_82582_d() && ta == null || ta != null && ta.func_82582_d() && tb != null && tb.func_82582_d()) {
                return true;
            }
            if (ta == null && tb != null || ta != null && tb == null) {
                return false;
            }
            if (AESharedNBT.isShared(tb)) {
                return ta == tb;
            }
            return Platform.NBTEqualityTest((NBTBase)ta, (NBTBase)tb);
        }
        return false;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack is = new ItemStack(this.def.item, (int)Math.min(Integer.MAX_VALUE, this.stackSize), this.def.damageValue);
        if (this.def.tagCompound != null) {
            is.func_77982_d(this.def.tagCompound.getNBTTagCompoundCopy());
        }
        return is;
    }

    @Override
    public IAEItemStack copy() {
        return new AEItemStack(this);
    }

    @Override
    public void writeToNBT(NBTTagCompound i) {
        i.func_74777_a("id", (short)Item.field_150901_e.func_148757_b((Object)this.def.item));
        i.func_74774_a("Count", (byte)0);
        i.func_74772_a("Cnt", this.stackSize);
        i.func_74772_a("Req", this.getCountRequestable());
        i.func_74757_a("Craft", this.isCraftable());
        i.func_74777_a("Damage", (short)this.def.damageValue);
        if (this.def.tagCompound != null) {
            i.func_74782_a("tag", (NBTBase)this.def.tagCompound);
        } else {
            i.func_82580_o("tag");
        }
    }

    public static IAEItemStack loadItemStackFromNBT(NBTTagCompound i) {
        if (i == null) {
            return null;
        }
        ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)i);
        if (itemstack == null) {
            return null;
        }
        AEItemStack aeis = AEItemStack.create(itemstack);
        aeis.stackSize = i.func_74763_f("Cnt");
        aeis.setCountRequestable(i.func_74763_f("Req"));
        aeis.setCraftable(i.func_74767_n("Craft"));
        return aeis;
    }

    @Override
    public boolean hasTagCompound() {
        return this.def.tagCompound != null;
    }

    public int hashCode() {
        return this.def.myHash;
    }

    @Override
    public int compareTo(AEItemStack b) {
        int id = this.compare(this.def.item.hashCode(), b.def.item.hashCode());
        int dv = this.compare(this.def.damageValue, b.def.damageValue);
        int dspv = this.compare(this.def.dspDamage, b.def.dspDamage);
        return id == 0 ? (dv == 0 ? (dspv == 0 ? this.compareNBT(b.def) : dspv) : dv) : id;
    }

    private int compareNBT(AEItemDef b) {
        int nbt = this.compare(this.def.tagCompound == null ? 0 : this.def.tagCompound.getHash(), b.tagCompound == null ? 0 : b.tagCompound.getHash());
        if (nbt == 0) {
            return this.compare(System.identityHashCode(this.def.tagCompound), System.identityHashCode(b.tagCompound));
        }
        return nbt;
    }

    private int compare(int l, long m) {
        return (long)l < m ? -1 : ((long)l > m ? 1 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public List getToolTip() {
        if (this.def.tooltip != null) {
            return this.def.tooltip;
        }
        this.def.tooltip = Platform.getTooltip(this.getItemStack());
        return this.def.tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        if (this.def.displayName != null) {
            return this.def.displayName;
        }
        this.def.displayName = Platform.getItemDisplayName(this.getItemStack());
        return this.def.displayName;
    }

    @SideOnly(value=Side.CLIENT)
    public String getModID() {
        if (this.def.uniqueID != null) {
            return this.getModName(this.def.uniqueID);
        }
        this.def.uniqueID = GameRegistry.findUniqueIdentifierFor((Item)this.def.item);
        return this.getModName(this.def.uniqueID);
    }

    private String getModName(GameRegistry.UniqueIdentifier uniqueIdentifier) {
        if (uniqueIdentifier == null) {
            return "** Null";
        }
        return uniqueIdentifier.modId == null ? "** Null" : uniqueIdentifier.modId;
    }

    @Override
    public IAEItemStack empty() {
        IAEItemStack dup = this.copy();
        dup.reset();
        return dup;
    }

    @Override
    public int getItemDamage() {
        return this.def.damageValue;
    }

    @Override
    void writeIdentity(ByteBuf i) throws IOException {
        i.writeShort(Item.field_150901_e.func_148757_b((Object)this.def.item));
        i.writeShort(this.getItemDamage());
    }

    @Override
    void readNBT(ByteBuf i) throws IOException {
        if (this.hasTagCompound()) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)this.getTagCompound()), (DataOutput)data);
            byte[] tagBytes = bytes.toByteArray();
            int size = tagBytes.length;
            i.writeInt(size);
            i.writeBytes(tagBytes);
        }
    }

    public static IAEItemStack loadItemStackFromPacket(ByteBuf data) throws IOException {
        byte mask = data.readByte();
        byte StackType = (byte)((mask & 0xC) >> 2);
        byte CountReqType = (byte)((mask & 0x30) >> 4);
        boolean isCraftable = (mask & 0x40) > 0;
        boolean hasTagCompound = (mask & 0x80) > 0;
        NBTTagCompound d = new NBTTagCompound();
        d.func_74777_a("id", data.readShort());
        d.func_74777_a("Damage", data.readShort());
        d.func_74774_a("Count", (byte)0);
        if (hasTagCompound) {
            int len = data.readInt();
            byte[] bd = new byte[len];
            data.readBytes(bd);
            ByteArrayInputStream di = new ByteArrayInputStream(bd);
            d.func_74782_a("tag", (NBTBase)CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(di)));
        }
        long stackSize = AEItemStack.getPacketValue(StackType, data);
        long countRequestable = AEItemStack.getPacketValue(CountReqType, data);
        ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)d);
        if (itemstack == null) {
            return null;
        }
        AEItemStack aeis = AEItemStack.create(itemstack);
        aeis.stackSize = stackSize;
        aeis.setCountRequestable(countRequestable);
        aeis.setCraftable(isCraftable);
        return aeis;
    }

    @Override
    public boolean sameOre(IAEItemStack is) {
        return OreHelper.instance.sameOre(this, is);
    }

    @Override
    public boolean fuzzyComparison(Object st, FuzzyMode Mode) {
        IAEItemStack o;
        if (st instanceof IAEItemStack) {
            o = (IAEItemStack)st;
            if (this.sameOre(o)) {
                return true;
            }
            if (o.getItem() == this.getItem()) {
                if (this.def.item.func_77645_m()) {
                    ItemStack a = this.getItemStack();
                    ItemStack b = o.getItemStack();
                    try {
                        if (Mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (Mode == FuzzyMode.PERCENT_99) {
                            return a.func_77952_i() > 1 == b.func_77952_i() > 1;
                        }
                        float APercentDamaged = 1.0f - (float)a.func_77952_i() / (float)a.func_77958_k();
                        float BPercentDamaged = 1.0f - (float)b.func_77952_i() / (float)b.func_77958_k();
                        return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
                    }
                    catch (Throwable e) {
                        if (Mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (Mode == FuzzyMode.PERCENT_99) {
                            return a.func_77960_j() > 1 == b.func_77960_j() > 1;
                        }
                        float APercentDamaged = (float)a.func_77960_j() / (float)a.func_77958_k();
                        float BPercentDamaged = (float)b.func_77960_j() / (float)b.func_77958_k();
                        return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
                    }
                }
                return this.getItemDamage() == o.getItemDamage();
            }
        }
        if (st instanceof ItemStack) {
            o = (ItemStack)st;
            OreHelper.instance.sameOre(this, (ItemStack)o);
            if (o.func_77973_b() == this.getItem()) {
                if (this.def.item.func_77645_m()) {
                    ItemStack a = this.getItemStack();
                    IAEItemStack b = o;
                    try {
                        if (Mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (Mode == FuzzyMode.PERCENT_99) {
                            return a.func_77952_i() > 1 == b.func_77952_i() > 1;
                        }
                        float APercentDamaged = 1.0f - (float)a.func_77952_i() / (float)a.func_77958_k();
                        float BPercentDamaged = 1.0f - (float)b.func_77952_i() / (float)b.func_77958_k();
                        return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
                    }
                    catch (Throwable e) {
                        if (Mode == FuzzyMode.IGNORE_ALL) {
                            return true;
                        }
                        if (Mode == FuzzyMode.PERCENT_99) {
                            return a.func_77960_j() > 1 == b.func_77960_j() > 1;
                        }
                        float APercentDamaged = (float)a.func_77960_j() / (float)a.func_77958_k();
                        float BPercentDamaged = (float)b.func_77960_j() / (float)b.func_77958_k();
                        return APercentDamaged > Mode.breakPoint == BPercentDamaged > Mode.breakPoint;
                    }
                }
                return this.getItemDamage() == o.func_77960_j();
            }
        }
        return false;
    }

    public IAEItemStack getLow(FuzzyMode fuzzy, boolean ignoreMeta) {
        AEItemStack bottom = new AEItemStack(this);
        AEItemDef newDef = bottom.def = bottom.def.copy();
        if (ignoreMeta) {
            newDef.damageValue = 0;
            newDef.dspDamage = 0;
            newDef.reHash();
            return bottom;
        }
        if (newDef.item.func_77645_m()) {
            int breakpoint;
            newDef.dspDamage = fuzzy == FuzzyMode.IGNORE_ALL ? 0 : (fuzzy == FuzzyMode.PERCENT_99 ? (this.def.damageValue == 0 ? 0 : 1) : ((breakpoint = fuzzy.calculateBreakPoint(this.def.maxDamage)) <= this.def.dspDamage ? breakpoint : 0));
            newDef.damageValue = newDef.dspDamage;
        }
        newDef.tagCompound = AEItemDef.lowTag;
        newDef.reHash();
        return bottom;
    }

    public IAEItemStack getHigh(FuzzyMode fuzzy, boolean ignoreMeta) {
        AEItemStack top = new AEItemStack(this);
        AEItemDef newDef = top.def = top.def.copy();
        if (ignoreMeta) {
            newDef.damageValue = Integer.MAX_VALUE;
            newDef.dspDamage = Integer.MAX_VALUE;
            newDef.reHash();
            return top;
        }
        if (newDef.item.func_77645_m()) {
            int breakpoint;
            newDef.dspDamage = fuzzy == FuzzyMode.IGNORE_ALL ? this.def.maxDamage + 1 : (fuzzy == FuzzyMode.PERCENT_99 ? (this.def.damageValue == 0 ? 0 : this.def.maxDamage + 1) : (this.def.dspDamage < (breakpoint = fuzzy.calculateBreakPoint(this.def.maxDamage)) ? breakpoint - 1 : this.def.maxDamage + 1));
            newDef.damageValue = newDef.dspDamage;
        }
        newDef.tagCompound = AEItemDef.highTag;
        newDef.reHash();
        return top;
    }

    @Override
    public IAETagCompound getTagCompound() {
        return this.def.tagCompound;
    }

    @Override
    public boolean isSameType(IAEItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return this.def.equals(((AEItemStack)otherStack).def);
    }

    @Override
    public boolean isSameType(ItemStack otherStack) {
        if (otherStack == null) {
            return false;
        }
        return this.def.isItem(otherStack);
    }

    @Override
    public boolean isItem() {
        return true;
    }

    @Override
    public boolean isFluid() {
        return false;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    public boolean isOre() {
        return this.def.isOre != null;
    }
}

