/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.AEApi;
import appeng.api.features.IItemComparison;
import appeng.api.storage.data.IAETagCompound;
import appeng.util.Platform;
import appeng.util.item.SharedSearchObject;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AESharedNBT
extends NBTTagCompound
implements IAETagCompound {
    private Item item;
    private int meta;
    private int hash;
    public SharedSearchObject sso;
    private IItemComparison comp;
    private static WeakHashMap<SharedSearchObject, WeakReference<SharedSearchObject>> sharedTagCompounts = new WeakHashMap();

    public int getHash() {
        return this.hash;
    }

    @Override
    public IItemComparison getSpecialComparison() {
        return this.comp;
    }

    private AESharedNBT(Item itemID, int damageValue) {
        this.item = itemID;
        this.meta = damageValue;
    }

    public AESharedNBT(int fakeValue) {
        this.item = null;
        this.meta = 0;
        this.hash = fakeValue;
    }

    @Override
    public NBTTagCompound getNBTTagCompoundCopy() {
        return (NBTTagCompound)this.func_74737_b();
    }

    public static AESharedNBT createFromCompound(Item itemID, int damageValue, NBTTagCompound c) {
        AESharedNBT x = new AESharedNBT(itemID, damageValue);
        for (String name : c.func_150296_c()) {
            x.func_74782_a(name, c.func_74781_a(name).func_74737_b());
        }
        x.hash = Platform.NBTOrderlessHash((NBTBase)c);
        ItemStack isc = new ItemStack(itemID, 1, damageValue);
        isc.func_77982_d(c);
        x.comp = AEApi.instance().registries().specialComparson().getSpecialComparion(isc);
        return x;
    }

    @Override
    public boolean equals(Object par1Obj) {
        if (par1Obj instanceof AESharedNBT) {
            return this == par1Obj;
        }
        return super.equals(par1Obj);
    }

    public boolean matches(Item itemid2, int meta2, int orderlessHash) {
        return itemid2 == this.item && this.meta == meta2 && this.hash == orderlessHash;
    }

    public boolean comparePreciseWithRegistry(AESharedNBT tagCompound) {
        if (this == tagCompound) {
            return true;
        }
        if (this.comp != null && tagCompound.comp != null) {
            return this.comp.sameAsPrecise(tagCompound.comp);
        }
        return false;
    }

    public boolean compareFuzzyWithRegistry(AESharedNBT tagCompound) {
        if (this == tagCompound) {
            return true;
        }
        if (tagCompound == null) {
            return false;
        }
        if (this.comp == tagCompound.comp) {
            return true;
        }
        if (this.comp != null) {
            return this.comp.sameAsFuzzy(tagCompound.comp);
        }
        return false;
    }

    public static int sharedTagLoad() {
        return sharedTagCompounts.size();
    }

    public static boolean isShared(NBTTagCompound ta) {
        return ta instanceof AESharedNBT;
    }

    public static synchronized NBTTagCompound getSharedTagCompound(NBTTagCompound tagCompound, ItemStack s) {
        SharedSearchObject cg;
        if (tagCompound.func_82582_d()) {
            return null;
        }
        Item itemid = s.func_77973_b();
        int meta = -1;
        if (s.func_77973_b() != null && s.func_77984_f() && s.func_77981_g()) {
            meta = s.func_77960_j();
        }
        if (AESharedNBT.isShared(tagCompound)) {
            return tagCompound;
        }
        SharedSearchObject sso = new SharedSearchObject(itemid, meta, tagCompound);
        WeakReference<SharedSearchObject> c = sharedTagCompounts.get(sso);
        if (c != null && (cg = (SharedSearchObject)c.get()) != null) {
            return cg.shared;
        }
        AESharedNBT clone = AESharedNBT.createFromCompound(itemid, meta, tagCompound);
        sso.compound = (NBTTagCompound)sso.compound.func_74737_b();
        sso.shared = clone;
        clone.sso = sso;
        sharedTagCompounts.put(sso, new WeakReference<SharedSearchObject>(sso));
        return clone;
    }
}

