/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import appeng.util.item.MeanfulIterator;
import appeng.util.item.OreRefrence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public final class ItemList<StackType extends IAEStack>
implements IItemList<StackType> {
    private final TreeMap<StackType, StackType> records = new TreeMap();
    private final Class<? extends IAEStack> clz;
    int iteration = Integer.MIN_VALUE;
    public Throwable stacktrace;

    public ItemList(Class<? extends IAEStack> cla) {
        this.clz = cla;
    }

    private boolean checkStackType(StackType st) {
        if (st == null) {
            return true;
        }
        if (!this.clz.isInstance(st)) {
            throw new RuntimeException("WRONG TYPE - got " + st.getClass().getName() + " expected " + this.clz.getName());
        }
        return false;
    }

    @Override
    public synchronized void add(StackType option) {
        if (this.checkStackType(option)) {
            return;
        }
        IAEStack st = (IAEStack)this.records.get(option);
        if (st != null) {
            st.add(option);
            return;
        }
        Object opt = option.copy();
        this.records.put(opt, opt);
    }

    @Override
    public synchronized void addStorage(StackType option) {
        if (this.checkStackType(option)) {
            return;
        }
        IAEStack st = (IAEStack)this.records.get(option);
        if (st != null) {
            st.incStackSize(option.getStackSize());
            return;
        }
        Object opt = option.copy();
        this.records.put(opt, opt);
    }

    @Override
    public synchronized void addCrafting(StackType option) {
        if (this.checkStackType(option)) {
            return;
        }
        IAEStack st = (IAEStack)this.records.get(option);
        if (st != null) {
            st.setCraftable(true);
            return;
        }
        Object opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(true);
        this.records.put(opt, opt);
    }

    @Override
    public synchronized void addRequestable(StackType option) {
        if (this.checkStackType(option)) {
            return;
        }
        IAEStack st = (IAEStack)this.records.get(option);
        if (st != null) {
            ((IAEItemStack)st).setCountRequestable(((IAEItemStack)st).getCountRequestable() + ((IAEItemStack)option).getCountRequestable());
            return;
        }
        Object opt = option.copy();
        opt.setStackSize(0L);
        opt.setCraftable(false);
        opt.setCountRequestable(opt.getCountRequestable());
        this.records.put(opt, opt);
    }

    @Override
    public synchronized StackType getFirstItem() {
        Iterator i = this.iterator();
        if (i.hasNext()) {
            return (StackType)((IAEStack)i.next());
        }
        return null;
    }

    @Override
    public synchronized void resetStatus() {
        for (IAEStack i : this) {
            i.reset();
        }
    }

    @Override
    public synchronized Iterator iterator() {
        return new MeanfulIterator<StackType>(this.records.values().iterator());
    }

    @Override
    public synchronized StackType findPrecise(StackType i) {
        if (this.checkStackType(i)) {
            return null;
        }
        IAEStack is = (IAEStack)this.records.get(i);
        if (is != null) {
            return (StackType)is;
        }
        return null;
    }

    @Override
    public synchronized int size() {
        return this.records.values().size();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public Collection<StackType> findFuzzyDamage(AEItemStack filter, FuzzyMode fuzzy, boolean ignoreMeta) {
        IAEItemStack low = filter.getLow(fuzzy, ignoreMeta);
        IAEItemStack high = filter.getHigh(fuzzy, ignoreMeta);
        return this.records.subMap(low, true, high, true).descendingMap().values();
    }

    @Override
    public Collection<StackType> findFuzzy(StackType filter, FuzzyMode fuzzy) {
        if (this.checkStackType(filter)) {
            return new ArrayList();
        }
        if (filter instanceof IAEFluidStack) {
            return filter.equals(this) ? Arrays.asList((IAEFluidStack)filter) : Arrays.asList(new IAEFluidStack[0]);
        }
        AEItemStack ais = (AEItemStack)filter;
        if (ais.isOre()) {
            OreRefrence or = ais.def.isOre;
            if (or.getAEEquivilients().size() == 1) {
                IAEItemStack is = or.getAEEquivilients().get(0);
                return this.findFuzzyDamage((AEItemStack)is, fuzzy, is.getItemDamage() == Short.MAX_VALUE);
            }
            LinkedList<StackType> output = new LinkedList<StackType>();
            for (IAEItemStack is : or.getAEEquivilients()) {
                output.addAll(this.findFuzzyDamage((AEItemStack)is, fuzzy, is.getItemDamage() == Short.MAX_VALUE));
            }
            return output;
        }
        return this.findFuzzyDamage(ais, fuzzy, false);
    }
}

