/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.tileentities.TileEntityCrystalMarker;
import am2.blocks.tileentities.TileEntityCrystalMarkerSpellExport;
import am2.blocks.tileentities.TileEntityFlickerHabitat;
import am2.items.ItemsCommonProxy;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCrystalMarker
extends BlockContainer {
    public static final int META_IN = 0;
    public static final int META_OUT = 1;
    public static final int META_LIKE_EXPORT = 2;
    public static final int META_SET_EXPORT = 3;
    public static final int META_REGULATE_EXPORT = 4;
    public static final int META_REGULATE_MULTI = 5;
    public static final int META_SET_IMPORT = 6;
    public static final int META_FINAL_DEST = 7;
    public static final int META_SPELL_EXPORT = 8;
    private int facingHolder = 0;
    private int xCoord = 0;
    private int yCoord = 0;
    private int zCoord = 0;
    public static final String[] crystalMarkerTypes = new String[]{"cm_import", "cm_export", "cm_likeExport", "cm_setExport", "cm_regulateExport", "cm_regulateMulti", "cm_setImport", "cm_final", "cm_spellExport"};

    protected BlockCrystalMarker() {
        super(Material.field_151592_s);
    }

    private int getCrystalTier(int meta) {
        switch (meta) {
            case 0: 
            case 1: 
            case 7: {
                return 0;
            }
            case 2: 
            case 3: 
            case 6: {
                return 1;
            }
            case 4: 
            case 5: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        return 0;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return 3 + this.getCrystalTier(meta);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack((Block)this, 1, 0));
        par3List.add(new ItemStack((Block)this, 1, 1));
        par3List.add(new ItemStack((Block)this, 1, 2));
        par3List.add(new ItemStack((Block)this, 1, 3));
        par3List.add(new ItemStack((Block)this, 1, 4));
        par3List.add(new ItemStack((Block)this, 1, 5));
        par3List.add(new ItemStack((Block)this, 1, 6));
        par3List.add(new ItemStack((Block)this, 1, 7));
        par3List.add(new ItemStack((Block)this, 1, 8));
    }

    public TileEntity func_149915_a(World world, int i) {
        int meta = world.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
        if (meta == 8) {
            return new TileEntityCrystalMarkerSpellExport(meta);
        }
        return new TileEntityCrystalMarker(meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int facing, float impx, float impy, float impz) {
        block10: {
            block9: {
                int operandType = world.func_72805_g(x, y, z);
                if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == ItemsCommonProxy.crystalWrench) {
                    player.func_71038_i();
                    return world.field_72995_K;
                }
                if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == ItemsCommonProxy.spellStaffMagitech) {
                    player.func_71038_i();
                    if (world.field_72995_K) {
                        return true;
                    }
                    if (operandType == 0) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.noPriIn")));
                        return false;
                    }
                    TileEntityCrystalMarker crystalMarkerTE = this.GetTileEntity(world, x, y, z);
                    TileEntityFlickerHabitat elementalAttunerTE = null;
                    if (crystalMarkerTE != null) {
                        int oldPriority = crystalMarkerTE.getPriority();
                        crystalMarkerTE.cyclePriority();
                        AMVector3 elementalAttunerVector = crystalMarkerTE.getElementalAttuner();
                        if (elementalAttunerVector != null && (elementalAttunerTE = this.GetElementalAttunerTileEntity(world, (int)elementalAttunerVector.x, (int)elementalAttunerVector.y, (int)elementalAttunerVector.z)) != null) {
                            elementalAttunerTE.switchMarkerPriority(new AMVector3(x, y, z), oldPriority, crystalMarkerTE.getPriority());
                        }
                        player.func_145747_a((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"am2.tooltip.priSet"), String.format("%d", crystalMarkerTE.getPriority()))));
                    }
                    return false;
                }
                if (operandType == 3) break block9;
                if (operandType == 4) break block9;
                if (operandType == 5) break block9;
                if (operandType != 6) break block10;
            }
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)AMCore.instance, (int)19, (World)world, (int)x, (int)y, (int)z);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, facing, impx, impy, impz);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        this.facingHolder = side;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        return super.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, meta);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityCrystalMarker) {
            ((TileEntityCrystalMarker)te).setFacing(this.facingHolder);
            Block attachedTo = null;
            double minx = 0.0;
            double miny = 0.0;
            double minz = 0.0;
            double maxx = 1.0;
            double maxy = 1.0;
            double maxz = 1.0;
            switch (this.facingHolder) {
                case 0: {
                    attachedTo = world.func_147439_a(x, y + 1, z);
                    break;
                }
                case 1: {
                    attachedTo = world.func_147439_a(x, y - 1, z);
                    break;
                }
                case 2: {
                    attachedTo = world.func_147439_a(x, y, z + 1);
                    break;
                }
                case 3: {
                    attachedTo = world.func_147439_a(x, y, z - 1);
                    break;
                }
                case 4: {
                    attachedTo = world.func_147439_a(x + 1, y, z);
                    break;
                }
                case 5: {
                    attachedTo = world.func_147439_a(x - 1, y, z);
                }
            }
            if (attachedTo != null) {
                minx = attachedTo.func_149704_x();
                miny = attachedTo.func_149665_z();
                minz = attachedTo.func_149706_B();
                maxx = attachedTo.func_149753_y();
                maxy = attachedTo.func_149669_A();
                maxz = attachedTo.func_149693_C();
                ((TileEntityCrystalMarker)te).SetConnectedBoundingBox(minx, miny, minz, maxx, maxy, maxz);
            }
        }
        super.func_149689_a(world, x, y, z, player, itemStack);
    }

    private TileEntityCrystalMarker GetTileEntity(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityCrystalMarker) {
            return (TileEntityCrystalMarker)te;
        }
        return null;
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlock, int oldMeta) {
        AMVector3 elementalAttunerVector;
        TileEntityCrystalMarker crystalMarkerTE = this.GetTileEntity(world, x, y, z);
        TileEntityFlickerHabitat elementalAttunerTE = null;
        if (crystalMarkerTE != null && (elementalAttunerVector = crystalMarkerTE.getElementalAttuner()) != null && (elementalAttunerTE = this.GetElementalAttunerTileEntity(world, (int)elementalAttunerVector.x, (int)elementalAttunerVector.y, (int)elementalAttunerVector.z)) != null) {
            int operandType = world.func_72805_g(x, y, z);
            if (operandType == 0) {
                elementalAttunerTE.removeInMarkerLocation(x, y, z);
            } else if (BlockCrystalMarker.isOutputMarker(operandType)) {
                elementalAttunerTE.removeOutMarkerLocation(x, y, z);
            }
        }
        super.func_149749_a(world, x, y, z, oldBlock, oldMeta);
    }

    private TileEntityFlickerHabitat GetElementalAttunerTileEntity(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityFlickerHabitat) {
            return (TileEntityFlickerHabitat)te;
        }
        return null;
    }

    public int func_149645_b() {
        return BlocksCommonProxy.blockRenderID;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149719_a(IBlockAccess par1iBlockAccess, int x, int y, int z) {
        TileEntity te = par1iBlockAccess.func_147438_o(x, y, z);
        TileEntityCrystalMarker cm = (TileEntityCrystalMarker)te;
        int facing = cm.getFacing();
        switch (facing) {
            case 0: {
                this.func_149676_a(0.35f, (float)(1.0 + cm.GetConnectedBoundingBox().field_72338_b) - 0.1f, 0.32f, 0.65f, (float)(1.0 + cm.GetConnectedBoundingBox().field_72338_b), 0.68f);
                break;
            }
            case 1: {
                this.func_149676_a(0.35f, (float)(-1.0 * (1.0 - cm.GetConnectedBoundingBox().field_72337_e)), 0.3f, 0.65f, (float)(-1.0 * (1.0 - cm.GetConnectedBoundingBox().field_72337_e)) + 0.1f, 0.7f);
                break;
            }
            case 2: {
                this.func_149676_a(0.35f, 0.32f, (float)(1.0 + (1.0 - cm.GetConnectedBoundingBox().field_72334_f)) - 0.1f, 0.65f, 0.68f, (float)(1.0 + (1.0 - cm.GetConnectedBoundingBox().field_72334_f)));
                break;
            }
            case 3: {
                this.func_149676_a(0.35f, 0.32f, (float)(0.0 - cm.GetConnectedBoundingBox().field_72339_c), 0.65f, 0.68f, (float)(0.0 - cm.GetConnectedBoundingBox().field_72339_c) + 0.1f);
                break;
            }
            case 4: {
                this.func_149676_a((float)(1.0 + cm.GetConnectedBoundingBox().field_72340_a) - 0.1f, 0.32f, 0.35f, (float)(1.0 + cm.GetConnectedBoundingBox().field_72340_a), 0.68f, 0.65f);
                break;
            }
            case 5: {
                this.func_149676_a((float)(-1.0 * (1.0 - cm.GetConnectedBoundingBox().field_72336_d)), 0.32f, 0.35f, (float)(-1.0 * (1.0 - cm.GetConnectedBoundingBox().field_72336_d)) + 0.1f, 0.68f, 0.65f);
            }
        }
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockID) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        TileEntityCrystalMarker cm = null;
        boolean mustDrop = false;
        if (te == null || !(te instanceof TileEntityCrystalMarker)) {
            return;
        }
        cm = (TileEntityCrystalMarker)te;
        switch (cm.getFacing()) {
            case 0: {
                mustDrop = world.func_147437_c(x, y + 1, z);
                break;
            }
            case 1: {
                mustDrop = world.func_147437_c(x, y - 1, z);
                break;
            }
            case 2: {
                mustDrop = world.func_147437_c(x, y, z + 1);
                break;
            }
            case 3: {
                mustDrop = world.func_147437_c(x, y, z - 1);
                break;
            }
            case 4: {
                mustDrop = world.func_147437_c(x + 1, y, z);
                break;
            }
            case 5: {
                mustDrop = world.func_147437_c(x - 1, y, z);
            }
        }
        if (mustDrop) {
            Block block = world.func_147439_a(x, y, z);
            ItemStack itemStack = new ItemStack(block, 1, world.func_72805_g(x, y, z));
            EntityItem entityItem = new EntityItem(world, (double)x, (double)y, (double)z, itemStack);
            world.func_72838_d((Entity)entityItem);
            world.func_147468_f(x, y, z);
        }
    }

    public static boolean isOutputMarker(int operandType) {
        return operandType == 1 || operandType == 2 || operandType == 3 || operandType == 4 || operandType == 5 || operandType == 7 || operandType == 8;
    }

    public static boolean isInputMarker(int operandType) {
        return operandType == 0 || operandType == 5 || operandType == 6 || operandType == 8;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public void func_149651_a(IIconRegister p_149651_1_) {
    }
}

