/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.AMCore;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.power.PowerTypes;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.tileentities.TileEntityObelisk;
import am2.buffs.BuffEffectManaRegen;
import am2.buffs.BuffList;
import am2.multiblock.IMultiblockStructureController;
import am2.power.PowerNodeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityCelestialPrism
extends TileEntityObelisk
implements IMultiblockStructureController {
    private MultiblockStructureDefinition.StructureGroup moonstone;
    private int particleCounter = 0;
    private boolean onlyChargeAtNight = false;

    public TileEntityCelestialPrism() {
        super(2500);
        this.powerBase = 1.0f;
        this.structure = new MultiblockStructureDefinition("celestialprism_structure");
        MultiblockStructureDefinition.StructureGroup glass = this.structure.createGroup("caps_glass", 2);
        MultiblockStructureDefinition.StructureGroup gold = this.structure.createGroup("caps_gold", 2);
        MultiblockStructureDefinition.StructureGroup diamond = this.structure.createGroup("caps_diamond", 2);
        this.moonstone = this.structure.createGroup("caps_moonstone", 2);
        this.pillars = this.structure.createGroup("pillars", 4);
        this.caps = new HashMap();
        this.caps.put(glass, Float.valueOf(1.1f));
        this.caps.put(gold, Float.valueOf(1.4f));
        this.caps.put(diamond, Float.valueOf(2.0f));
        this.caps.put(this.moonstone, Float.valueOf(3.0f));
        this.structure.addAllowedBlock(0, 0, 0, BlocksCommonProxy.celestialPrism);
        this.structure.addAllowedBlock(this.pillars, -2, 0, -2, Blocks.field_150371_ca);
        this.structure.addAllowedBlock(this.pillars, -2, 1, -2, Blocks.field_150371_ca);
        this.structure.addAllowedBlock(glass, -2, 2, -2, Blocks.field_150359_w);
        this.structure.addAllowedBlock(gold, -2, 2, -2, Blocks.field_150340_R);
        this.structure.addAllowedBlock(diamond, -2, 2, -2, Blocks.field_150484_ah);
        this.structure.addAllowedBlock(this.moonstone, -2, 2, -2, (Block)BlocksCommonProxy.AMOres, 5);
        this.structure.addAllowedBlock(this.pillars, 2, 0, -2, Blocks.field_150371_ca);
        this.structure.addAllowedBlock(this.pillars, 2, 1, -2, Blocks.field_150371_ca);
        this.structure.addAllowedBlock(glass, 2, 2, -2, Blocks.field_150359_w);
        this.structure.addAllowedBlock(gold, 2, 2, -2, Blocks.field_150340_R);
        this.structure.addAllowedBlock(diamond, 2, 2, -2, Blocks.field_150484_ah);
        this.structure.addAllowedBlock(this.moonstone, 2, 2, -2, (Block)BlocksCommonProxy.AMOres, 5);
        this.structure.addAllowedBlock(this.pillars, -2, 0, 2, Blocks.field_150371_ca);
        this.structure.addAllowedBlock(this.pillars, -2, 1, 2, Blocks.field_150371_ca);
        this.structure.addAllowedBlock(glass, -2, 2, 2, Blocks.field_150359_w);
        this.structure.addAllowedBlock(gold, -2, 2, 2, Blocks.field_150340_R);
        this.structure.addAllowedBlock(diamond, -2, 2, 2, Blocks.field_150484_ah);
        this.structure.addAllowedBlock(this.moonstone, -2, 2, 2, (Block)BlocksCommonProxy.AMOres, 5);
        this.structure.addAllowedBlock(this.pillars, 2, 0, 2, Blocks.field_150371_ca);
        this.structure.addAllowedBlock(this.pillars, 2, 1, 2, Blocks.field_150371_ca);
        this.structure.addAllowedBlock(glass, 2, 2, 2, Blocks.field_150359_w);
        this.structure.addAllowedBlock(gold, 2, 2, 2, Blocks.field_150340_R);
        this.structure.addAllowedBlock(diamond, 2, 2, 2, Blocks.field_150484_ah);
        this.structure.addAllowedBlock(this.moonstone, 2, 2, 2, (Block)BlocksCommonProxy.AMOres, 5);
        this.wizardChalkCircle = this.addWizChalkGroupToStructure(this.structure, 1);
    }

    @Override
    protected void checkNearbyBlockState() {
        ArrayList<MultiblockStructureDefinition.StructureGroup> groups = this.structure.getMatchedGroups(7, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        float capsLevel = 1.0f;
        boolean pillarsFound = false;
        boolean wizChalkFound = false;
        block0: for (MultiblockStructureDefinition.StructureGroup group : groups) {
            if (group == this.pillars) {
                pillarsFound = true;
            } else if (group == this.wizardChalkCircle) {
                wizChalkFound = true;
            }
            for (MultiblockStructureDefinition.StructureGroup cap : this.caps.keySet()) {
                if (group != cap) continue;
                capsLevel = ((Float)this.caps.get(cap)).floatValue();
                if (group == this.moonstone) {
                    this.onlyChargeAtNight = true;
                    continue block0;
                }
                this.onlyChargeAtNight = false;
                continue block0;
            }
        }
        this.powerMultiplier = 1.0f;
        if (wizChalkFound) {
            this.powerMultiplier = 1.25f;
        }
        if (pillarsFound) {
            this.powerMultiplier *= capsLevel;
        }
    }

    private boolean isNight() {
        long ticks = this.field_145850_b.func_72820_D() % 24000L;
        return ticks >= 12500L && ticks <= 23500L;
    }

    @Override
    public void func_145845_h() {
        if (this.surroundingCheckTicks++ % 100 == 0) {
            this.checkNearbyBlockState();
            this.surroundingCheckTicks = 1;
            if (!this.field_145850_b.field_72995_K && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, (float)this.capacity * 0.1f)) {
                List nearbyPlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2)));
                for (EntityPlayer p : nearbyPlayers) {
                    if (p.func_82165_m(BuffList.manaRegen.field_76415_H)) continue;
                    p.func_70690_d((PotionEffect)new BuffEffectManaRegen(600, 1));
                }
            }
        }
        if (this.onlyChargeAtNight == this.isNight()) {
            PowerNodeRegistry.For(this.field_145850_b).insertPower(this, PowerTypes.LIGHT, 0.25f * this.powerMultiplier);
            if (this.field_145850_b.field_72995_K && this.particleCounter++ % 180 == 0) {
                this.particleCounter = 1;
                AMCore.proxy.particleManager.RibbonFromPointToPoint(this.field_145850_b, (float)this.field_145851_c + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_145848_d + this.field_145850_b.field_73012_v.nextFloat() * 2.0f, (float)this.field_145849_e + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_145851_c + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_145848_d + this.field_145850_b.field_73012_v.nextFloat() * 2.0f, (float)this.field_145849_e + this.field_145850_b.field_73012_v.nextFloat());
            }
        }
        super.callSuperUpdate();
    }

    @Override
    public MultiblockStructureDefinition getDefinition() {
        return this.structure;
    }

    @Override
    public boolean canRequestPower() {
        return false;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return type == PowerTypes.LIGHT;
    }

    @Override
    public PowerTypes[] getValidPowerTypes() {
        return new PowerTypes[]{PowerTypes.LIGHT};
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }
}

