/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.api.flickers.IFlickerController;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.math.AMVector3;
import am2.api.spell.enums.Affinity;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import am2.utility.DummyEntityPlayer;
import am2.utility.InventoryUtilities;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FlickerOperatorFelledOak
implements IFlickerFunctionality {
    private DummyEntityPlayer dummyPlayer;
    private static final int radius_horiz = 6;
    private static final int radius_vert = 1;

    void destroyTree(World world, int x, int y, int z, Block block, int meta) {
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    Block localblock = world.func_147439_a(xPos, yPos, zPos);
                    if (block != localblock) continue;
                    meta = world.func_72805_g(xPos, yPos, zPos);
                    if (localblock != block || world.func_72805_g(xPos, yPos, zPos) % 4 != meta % 4) continue;
                    if (block.removedByPlayer(world, (EntityPlayer)this.dummyPlayer, xPos, yPos, zPos)) {
                        block.func_149664_b(world, xPos, yPos, zPos, meta);
                    }
                    block.func_149636_a(world, (EntityPlayer)this.dummyPlayer, xPos, yPos, zPos, meta);
                    block.func_149681_a(world, xPos, yPos, zPos, meta, (EntityPlayer)this.dummyPlayer);
                    this.destroyTree(world, xPos, yPos, zPos, block, meta);
                }
            }
        }
    }

    void beginTreeFelling(World world, int x, int y, int z) {
        Block wood = world.func_147439_a(x, y, z);
        while (wood.isWood((IBlockAccess)world, x, y, z)) {
            wood = world.func_147439_a(x, --y, z);
        }
        if ((wood = world.func_147439_a(x, ++y, z)).isWood((IBlockAccess)world, x, y, z)) {
            int height = y;
            boolean foundTop = false;
            do {
                Block block;
                if ((block = world.func_147439_a(x, ++height, z)) == wood) continue;
                --height;
                foundTop = true;
            } while (!foundTop);
            int numLeaves = 0;
            if (height - y < 50) {
                for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                    for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                        for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                            Block leaves = world.func_147439_a(xPos, yPos, zPos);
                            if (leaves == null || !leaves.isLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                            ++numLeaves;
                        }
                    }
                }
            }
            int meta = world.func_72805_g(x, y, z);
            if (numLeaves > 3) {
                this.destroyTree(world, x, y, z, wood, meta);
            }
            if (!world.field_72995_K) {
                world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)wood) + (world.func_72805_g(x, y, z) << 12));
            }
        }
    }

    private void plantTree(World worldObj, IFlickerController habitat, boolean powered) {
        if (!powered || worldObj.field_72995_K) {
            return;
        }
        ItemStack sapling = this.getSaplingFromNearbyChest(worldObj, habitat);
        if (sapling == null) {
            return;
        }
        AMVector3 plantLoc = this.getPlantLocation(worldObj, habitat, sapling);
        if (plantLoc == null) {
            return;
        }
        this.deductSaplingFromNearbyChest(worldObj, habitat);
        ItemBlock block = (ItemBlock)sapling.func_77973_b();
        worldObj.func_147465_d((int)plantLoc.x, (int)plantLoc.y, (int)plantLoc.z, block.field_150939_a, block.func_77647_b(sapling.func_77960_j()), 3);
    }

    private AMVector3 getPlantLocation(World worldObj, IFlickerController habitat, ItemStack sapling) {
        if (!(sapling.func_77973_b() instanceof ItemBlock)) {
            return null;
        }
        TileEntity te = (TileEntity)habitat;
        byte[] data = habitat.getMetadata(this);
        AMVector3 offset = null;
        if (data == null || data.length == 0) {
            offset = new AMVector3(te.field_145851_c - 6, te.field_145848_d - 1, te.field_145849_e - 6);
        } else {
            AMDataReader reader = new AMDataReader(data, false);
            offset = new AMVector3(reader.getInt(), te.field_145848_d - 1, reader.getInt());
        }
        Block treeBlock = ((ItemBlock)sapling.func_77973_b()).field_150939_a;
        for (int i = (int)offset.x; i <= te.field_145851_c + 6; i += 2) {
            for (int k = (int)offset.z; k <= te.field_145849_e + 6; k += 2) {
                for (int j = (int)offset.y; j <= te.field_145848_d + 1; ++j) {
                    Block block = worldObj.func_147439_a(i, j, k);
                    if (!block.isReplaceable((IBlockAccess)worldObj, i, j, k) || !treeBlock.func_149742_c(worldObj, i, j, k)) continue;
                    AMDataWriter writer = new AMDataWriter();
                    writer.add(i).add(k);
                    habitat.setMetadata(this, writer.generate());
                    return new AMVector3(i, j, k);
                }
            }
        }
        AMDataWriter writer = new AMDataWriter();
        writer.add(te.field_145851_c - 6).add(te.field_145849_e - 6);
        habitat.setMetadata(this, writer.generate());
        return null;
    }

    private ItemStack getSaplingFromNearbyChest(World worldObj, IFlickerController habitat) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int index;
            IInventory inv = this.getOffsetInventory(worldObj, habitat, dir);
            if (inv == null || (index = InventoryUtilities.getInventorySlotIndexFor(inv, new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE))) <= -1) continue;
            ItemStack stack = inv.func_70301_a(index).func_77946_l();
            stack.field_77994_a = 1;
            return stack;
        }
        return null;
    }

    private void deductSaplingFromNearbyChest(World worldObj, IFlickerController habitat) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int index;
            IInventory inv = this.getOffsetInventory(worldObj, habitat, dir);
            if (inv == null || (index = InventoryUtilities.getInventorySlotIndexFor(inv, new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE))) <= -1) continue;
            InventoryUtilities.decrementStackQuantity(inv, index, 1);
            return;
        }
    }

    private IInventory getOffsetInventory(World worldObj, IFlickerController habitat, ForgeDirection direction) {
        TileEntity te = (TileEntity)habitat;
        TileEntity adjacent = worldObj.func_147438_o(te.field_145851_c + direction.offsetX, te.field_145848_d + direction.offsetY, te.field_145849_e + direction.offsetZ);
        if (adjacent != null && adjacent instanceof IInventory) {
            return (IInventory)adjacent;
        }
        return null;
    }

    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 100;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered) {
        int radius = 6;
        this.dummyPlayer = new DummyEntityPlayer(worldObj);
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                Block block = worldObj.func_147439_a(((TileEntity)habitat).field_145851_c + i, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e + j);
                if (block == Blocks.field_150350_a || !block.isWood((IBlockAccess)worldObj, ((TileEntity)habitat).field_145851_c + i, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e + j)) continue;
                if (!worldObj.field_72995_K) {
                    this.beginTreeFelling(worldObj, ((TileEntity)habitat).field_145851_c + i, ((TileEntity)habitat).field_145848_d, ((TileEntity)habitat).field_145849_e + j);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
        boolean hasNatureAugment = false;
        for (Affinity aff : flickers) {
            if (aff != Affinity.NATURE) continue;
            hasNatureAugment = true;
            break;
        }
        if (hasNatureAugment) {
            this.plantTree(worldObj, habitat, powered);
        }
        return this.DoOperation(worldObj, habitat, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        int base = powered ? 300 : 3600;
        float augments = 1.0f;
        for (Affinity aff : flickers) {
            if (aff != Affinity.LIGHTNING) continue;
            augments *= 0.5f;
        }
        return (int)Math.ceil((float)base * augments);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        Object[] objectArray = new Object[15];
        objectArray[0] = "WG ";
        objectArray[1] = "NCL";
        objectArray[2] = " OW";
        objectArray[3] = Character.valueOf('W');
        objectArray[4] = BlocksCommonProxy.witchwoodLog;
        objectArray[5] = Character.valueOf('G');
        objectArray[6] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 6);
        objectArray[7] = Character.valueOf('N');
        objectArray[8] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.NATURE.ordinal());
        objectArray[9] = Character.valueOf('L');
        objectArray[10] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.LIGHTNING.ordinal());
        objectArray[11] = Character.valueOf('G');
        objectArray[12] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 11);
        objectArray[13] = Character.valueOf('G');
        objectArray[14] = new ItemStack((Item)ItemsCommonProxy.bindingCatalyst, 1, 1);
        return objectArray;
    }
}

