/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.api.flickers.IFlickerController;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.spell.enums.Affinity;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import am2.utility.DummyEntityPlayer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class FlickerOperatorFlatLands
implements IFlickerFunctionality {
    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 10;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered) {
        int searchesPerLoop = 12;
        int radius = 6;
        int diameter = radius * 2 + 1;
        if (!worldObj.field_72995_K) {
            boolean actionPerformed = false;
            for (int i = 0; i < searchesPerLoop && !actionPerformed; ++i) {
                int effectX = ((TileEntity)habitat).field_145851_c - radius + worldObj.field_73012_v.nextInt(diameter);
                int effectZ = ((TileEntity)habitat).field_145849_e - radius + worldObj.field_73012_v.nextInt(diameter);
                int effectY = ((TileEntity)habitat).field_145848_d + worldObj.field_73012_v.nextInt(radius);
                if (effectX == ((TileEntity)habitat).field_145851_c && effectY == ((TileEntity)habitat).field_145848_d && effectZ == ((TileEntity)habitat).field_145849_e) {
                    return false;
                }
                Block block = worldObj.func_147439_a(effectX, effectY, effectZ);
                int meta = worldObj.func_72805_g(effectX, effectY, effectZ);
                if (block == null || worldObj.func_147437_c(effectX, effectY, effectZ) || !block.func_149662_c() || block == BlocksCommonProxy.invisibleUtility || !ForgeEventFactory.doPlayerHarvestCheck((EntityPlayer)new DummyEntityPlayer(worldObj), (Block)block, (boolean)true) || !block.removedByPlayer(worldObj, (EntityPlayer)new DummyEntityPlayer(worldObj), effectX, effectY, effectZ)) continue;
                block.func_149664_b(worldObj, effectX, effectY, effectZ, meta);
                block.func_149697_b(worldObj, effectX, effectY, effectZ, meta, 0);
                if (!worldObj.field_72995_K) {
                    worldObj.func_72926_e(2001, effectX, effectY, effectZ, Block.func_149682_b((Block)block) + (worldObj.func_72805_g(effectX, effectY, effectZ) << 12));
                }
                worldObj.func_147478_e(effectX, effectY, effectZ, true);
                actionPerformed = true;
            }
            return actionPerformed;
        }
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
        return this.DoOperation(worldObj, habitat, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return powered ? 1 : 20;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        Object[] objectArray = new Object[15];
        objectArray[0] = "S P";
        objectArray[1] = "ENI";
        objectArray[2] = " R ";
        objectArray[3] = Character.valueOf('S');
        objectArray[4] = Items.field_151037_a;
        objectArray[5] = Character.valueOf('P');
        objectArray[6] = Items.field_151035_b;
        objectArray[7] = Character.valueOf('E');
        objectArray[8] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.EARTH.ordinal());
        objectArray[9] = Character.valueOf('N');
        objectArray[10] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 1);
        objectArray[11] = Character.valueOf('I');
        objectArray[12] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.ICE.ordinal());
        objectArray[13] = Character.valueOf('R');
        objectArray[14] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 0);
        return objectArray;
    }
}

