/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.bosses.AM2Boss;
import am2.bosses.BossActions;
import am2.bosses.ai.EntityAIEnderRush;
import am2.bosses.ai.EntityAIEnderbolt;
import am2.bosses.ai.EntityAIEndertorrent;
import am2.bosses.ai.EntityAIEnderwave;
import am2.bosses.ai.EntityAIOtherworldlyRoar;
import am2.bosses.ai.EntityAIProtect;
import am2.bosses.ai.EntityAIShadowstep;
import am2.buffs.BuffList;
import am2.damage.DamageSources;
import am2.items.ItemsCommonProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import thehippomaster.AnimationAPI.IAnimatedEntity;

public class EntityEnderGuardian
extends AM2Boss
implements IAnimatedEntity {
    private int wingFlapTime = 0;
    private int ticksSinceLastAttack = 0;
    private String lastDamageType = "";
    private int hitCount = 0;
    private AMVector3 spawn;
    private static final int ATTACK_TARGET = 20;

    public EntityEnderGuardian(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 3.0f);
    }

    @Override
    protected void initSpecificAI() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIShadowstep(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEnderwave(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIOtherworldlyRoar(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIProtect(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEnderRush(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEndertorrent(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEnderbolt(this));
    }

    public int func_70658_aO() {
        return 16;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)-1);
    }

    public float func_70047_e() {
        return 2.5f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(490.0);
    }

    @Override
    protected float modifyDamageAmount(DamageSource source, float damageAmt) {
        if (source.func_82725_o()) {
            damageAmt *= 2.0f;
        }
        return damageAmt;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.spawn == null) {
            this.spawn = new AMVector3((Entity)this);
        }
        ++this.wingFlapTime;
        ++this.ticksSinceLastAttack;
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.7999998927116394;
        }
        switch (this.getCurrentAction()) {
            case LONG_CASTING: {
                if (this.getTicksInCurrentAction() != 32) break;
                this.field_70170_p.func_72956_a((Entity)this, "arsmagica2:mob.enderguardian.roar", 1.0f, 1.0f);
                break;
            }
            case CHARGE: {
                if (this.getTicksInCurrentAction() != 0) break;
                this.func_70024_g(0.0, 1.5, 0.0);
                break;
            }
        }
        if (this.shouldFlapWings() && (float)this.wingFlapTime % (50.0f * this.getWingFlapSpeed()) == 0.0f) {
            this.field_70170_p.func_72956_a((Entity)this, "arsmagica2:mob.enderguardian.flap", 1.0f, 1.0f);
        }
    }

    public int getTicksSinceLastAttack() {
        return this.ticksSinceLastAttack;
    }

    public void func_70624_b(EntityLivingBase par1EntityLivingBase) {
        super.func_70624_b(par1EntityLivingBase);
        if (!this.field_70170_p.field_72995_K) {
            if (par1EntityLivingBase != null) {
                this.field_70180_af.func_75692_b(20, (Object)par1EntityLivingBase.func_145782_y());
            } else {
                this.field_70180_af.func_75692_b(20, (Object)-1);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean you = false;
        boolean should = false;
        boolean not = false;
        boolean be = false;
        boolean looking = false;
        boolean here = false;
        boolean cheater = false;
        if (par1DamageSource.func_76364_f() instanceof EntityEnderman) {
            ((EntityEnderman)par1DamageSource.func_76364_f()).func_70097_a((DamageSource)DamageSources.wtfBoom, 5000.0f);
            this.func_70691_i(10.0f);
            return false;
        }
        if (par1DamageSource.field_76373_n.equals("outOfWorld")) {
            if (this.spawn != null) {
                this.func_70107_b(this.spawn.x, this.spawn.y, this.spawn.z);
                this.setCurrentAction(BossActions.IDLE);
                if (!this.field_70170_p.field_72995_K) {
                    AMCore.proxy.addDeferredTargetSet((EntityLiving)this, null);
                }
            } else {
                this.func_70106_y();
            }
            return false;
        }
        this.ticksSinceLastAttack = 0;
        if (!this.field_70170_p.field_72995_K && par1DamageSource.func_76364_f() != null && par1DamageSource.func_76364_f() instanceof EntityPlayer) {
            if (par1DamageSource.field_76373_n == this.lastDamageType) {
                ++this.hitCount;
                if (this.hitCount > 5) {
                    this.func_70691_i(par2 / 4.0f);
                }
                return false;
            }
            this.lastDamageType = par1DamageSource.field_76373_n;
            this.hitCount = 1;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public EntityLivingBase func_70638_az() {
        if (!this.field_70170_p.field_72995_K) {
            return super.func_70638_az();
        }
        return (EntityLivingBase)this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(20));
    }

    @Override
    public void setCurrentAction(BossActions action) {
        this.currentAction = action;
        if (action == BossActions.LONG_CASTING) {
            this.wingFlapTime = 0;
        }
    }

    public int getWingFlapTime() {
        return this.wingFlapTime;
    }

    public float getWingFlapSpeed() {
        switch (this.currentAction) {
            case CASTING: {
                return 0.5f;
            }
            case STRIKE: {
                return 0.4f;
            }
            case CHARGE: {
                if (this.ticksInCurrentAction < 15) {
                    return 0.25f;
                }
                return 0.75f;
            }
        }
        return 0.25f;
    }

    public boolean shouldFlapWings() {
        return this.currentAction != BossActions.LONG_CASTING && this.currentAction != BossActions.SHIELD_BASH;
    }

    public boolean func_82165_m(int par1) {
        if (par1 == BuffList.spellReflect.field_76415_H && (this.currentAction == BossActions.SHIELD_BASH || this.currentAction == BossActions.LONG_CASTING)) {
            return true;
        }
        if (par1 == BuffList.magicShield.field_76415_H && (this.currentAction == BossActions.SHIELD_BASH || this.currentAction == BossActions.LONG_CASTING)) {
            return true;
        }
        return super.func_82165_m(par1);
    }

    public boolean func_70644_a(Potion par1Potion) {
        if (par1Potion == BuffList.spellReflect && (this.currentAction == BossActions.SHIELD_BASH || this.currentAction == BossActions.LONG_CASTING)) {
            return true;
        }
        if (par1Potion == BuffList.magicShield && (this.currentAction == BossActions.SHIELD_BASH || this.currentAction == BossActions.LONG_CASTING)) {
            return true;
        }
        return super.func_70644_a(par1Potion);
    }

    protected String func_70621_aR() {
        return "arsmagica2:mob.enderguardian.hit";
    }

    protected String func_70673_aS() {
        return "arsmagica2:mob.enderguardian.death";
    }

    protected String func_70639_aQ() {
        return "arsmagica2:mob.enderguardian.idle";
    }

    @Override
    public String getAttackSound() {
        return "arsmagica2:mob.enderguardian.attack";
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.rune, 1, 19), 0.0f);
        }
        int i = this.field_70146_Z.nextInt(4);
        for (int j = 0; j < i; ++j) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.essence, 1, 9), 0.0f);
        }
        i = this.field_70146_Z.nextInt(10);
        if (i < 3 && par1) {
            this.func_70099_a(ItemsCommonProxy.enderBootsEnchanted.func_77946_l(), 0.0f);
        }
    }

    public void setAnimID(int id) {
        this.setCurrentAction(BossActions.values()[id]);
        this.ticksInCurrentAction = 0;
    }

    public void setAnimTick(int tick) {
        this.ticksInCurrentAction = tick;
    }

    public int getAnimID() {
        return this.currentAction.ordinal();
    }

    public int getAnimTick() {
        return this.ticksInCurrentAction;
    }

    protected void func_70069_a(float par1) {
    }
}

