/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses.ai;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.bosses.BossActions;
import am2.bosses.EntityLightningGuardian;
import am2.damage.DamageSources;
import am2.playerextensions.ExtendedProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.DamageSource;
import thehippomaster.AnimationAPI.AIAnimation;
import thehippomaster.AnimationAPI.IAnimatedEntity;

public class EntityAILightningRod
extends AIAnimation {
    private int cooldownTicks = 0;
    private AMVector3 startPos;
    private boolean hasAttacked = false;
    private boolean hasThrown = false;
    private boolean hasBolted = false;
    EntityLivingBase target;

    public EntityAILightningRod(IAnimatedEntity entity) {
        super(entity);
        this.func_75248_a(3);
    }

    public int getAnimID() {
        return BossActions.LONG_CASTING.ordinal();
    }

    public boolean isAutomatic() {
        return false;
    }

    public int getDuration() {
        return 173;
    }

    public boolean shouldAnimate() {
        EntityLiving living = this.getEntity();
        if (living.func_110143_aJ() > living.func_110138_aP() * 0.75f || living.func_70638_az() == null || !living.func_70635_at().func_75522_a((Entity)living.func_70638_az())) {
            return false;
        }
        return this.cooldownTicks-- <= 0;
    }

    public void func_75251_c() {
        this.startPos = null;
        this.hasAttacked = false;
        this.hasThrown = false;
        this.hasBolted = false;
        if (this.target != null) {
            ExtendedProperties.For(this.target).setDisableGravity(false);
        }
        this.target = null;
        super.func_75251_c();
    }

    public void func_75246_d() {
        EntityLightningGuardian guardian = (EntityLightningGuardian)this.getEntity();
        float factor = guardian.func_110143_aJ() / guardian.func_110138_aP() + 0.1f;
        this.cooldownTicks = (int)(500.0f * factor);
        int ticks = guardian.getTicksInCurrentAction();
        if (ticks <= 25) {
            this.target = guardian.func_70638_az();
            if (this.target != null) {
                this.startPos = new AMVector3((Entity)this.target);
            }
        } else {
            if (this.target == null || this.target.field_70128_L || this.startPos == null) {
                this.func_75251_c();
                return;
            }
            guardian.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
            if (ticks > 85 && ticks <= 150 && !guardian.field_70170_p.field_72995_K && ticks % 20 == 0) {
                guardian.field_70170_p.func_72956_a((Entity)guardian, "arsmagica2:mob.lightningguardian.lightning_rod_1", 1.0f, guardian.func_70681_au().nextFloat() * 0.5f + 0.5f);
            }
            if (ticks > 25 && ticks <= 85) {
                this.forcePosition(this.target, this.startPos.x, (double)this.startPos.y + (double)(ticks - 25) * 0.1, this.startPos.z);
                ExtendedProperties.For(this.target).setDisableGravity(true);
                if (!guardian.field_70170_p.field_72995_K && ticks == 30) {
                    guardian.field_70170_p.func_72956_a((Entity)guardian, "arsmagica2:mob.lightningguardian.lightning_rod_start", 1.0f, guardian.func_70681_au().nextFloat() * 0.5f + 0.5f);
                }
            } else if (ticks > 85 && ticks <= 105) {
                this.forcePosition(this.target, this.startPos.x, this.startPos.y + 6.0f, this.startPos.z);
            } else if (ticks > 105 && ticks <= 150) {
                this.forcePosition(this.target, this.startPos.x, this.startPos.y + 6.0f, this.startPos.z);
                if (ticks > 115) {
                    this.hasAttacked = true;
                    this.target.func_70097_a((DamageSource)DamageSources.causeEntityLightningDamage((EntityLivingBase)guardian), 3.0f);
                }
                AMCore.proxy.particleManager.BoltFromEntityToEntity(guardian.field_70170_p, (Entity)guardian, (Entity)guardian, (Entity)this.target, 0);
                if (!guardian.field_70170_p.field_72995_K && ticks % 20 == 0) {
                    guardian.field_70170_p.func_72956_a((Entity)guardian, "arsmagica2:mob.lightningguardian.idle", 1.0f, guardian.func_70681_au().nextFloat() * 0.5f + 0.5f);
                }
            } else if (ticks > 150 && ticks <= 158) {
                if (!this.hasThrown) {
                    this.target.func_70024_g(0.0, -3.0, 0.0);
                    this.target.field_70143_R = 5.0f;
                    ExtendedProperties.For(this.target).setDisableGravity(false);
                    this.hasThrown = true;
                }
            } else if (ticks > 165 && !this.hasBolted) {
                this.hasBolted = true;
                EntityLightningBolt bolt = new EntityLightningBolt(guardian.field_70170_p, this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
                bolt.func_70107_b(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
                guardian.field_70170_p.func_72942_c((Entity)bolt);
            }
        }
    }

    private void forcePosition(EntityLivingBase target, double x, double y, double z) {
        target.func_70634_a(x, y, z);
    }
}

