/*
 * Decompiled with CFR 0.152.
 */
package am2.entities;

import am2.entities.EntityDarkMage;
import am2.entities.EntityManaVortex;
import am2.entities.SpawnBlacklists;
import am2.entities.ai.EntityAIAllyManaLink;
import am2.entities.ai.EntityAIRangedAttackSpell;
import am2.entities.ai.selectors.LightMageEntitySelector;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import am2.playerextensions.SkillData;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import am2.texture.ResourceManager;
import am2.utility.EntityUtilities;
import am2.utility.NPCSpells;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityLightMage
extends EntityCreature {
    int hp;
    private static ItemStack diminishedHeldItem = new ItemStack((Item)ItemsCommonProxy.bookAffinity, 1, 2);
    private static ItemStack normalHeldItem = new ItemStack((Item)ItemsCommonProxy.bookAffinity, 1, 7);
    private static ItemStack augmentedHeldItem = new ItemStack((Item)ItemsCommonProxy.bookAffinity, 1, 5);
    private boolean hasUpdated = false;
    public static final int DW_MAGE_SKIN = 20;
    public static final int DW_MAGE_BOOK = 21;

    public EntityLightMage(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.0f);
        this.hp = this.field_70146_Z.nextInt(10) + 12;
        this.initAI();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)(this.field_70146_Z.nextInt(12) + 1));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(22.0);
    }

    public ItemStack func_70694_bm() {
        int cm = this.field_70180_af.func_75679_c(21);
        if (cm == 0) {
            return diminishedHeldItem;
        }
        if (cm == 1) {
            return normalHeldItem;
        }
        return augmentedHeldItem;
    }

    private void initAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)this.MovementSpeed()));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityManaVortex.class, 10.0f, (double)this.MovementSpeed(), (double)this.ActionSpeed()));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAllyManaLink(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRangedAttackSpell(this, this.MovementSpeed(), 20, NPCSpells.instance.lightMage_DiminishedAttack));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityDarkMage.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlime.class, 0, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true, false, (IEntitySelector)LightMageEntitySelector.instance));
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.hasUpdated = true;
        ExtendedProperties.For((EntityLivingBase)this).forceSync();
        this.field_70180_af.func_75692_b(20, (Object)par1nbtTagCompound.func_74762_e("am2_lm_skin"));
        this.field_70180_af.func_75692_b(21, (Object)par1nbtTagCompound.func_74762_e("am2_lm_book"));
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("am2_lm_skin", this.field_70180_af.func_75679_c(20));
        par1nbtTagCompound.func_74768_a("am2_lm_book", this.field_70180_af.func_75679_c(21));
    }

    public int func_70658_aO() {
        return 1;
    }

    protected float MovementSpeed() {
        return 0.4f;
    }

    protected float ActionSpeed() {
        return 0.5f;
    }

    public boolean func_70650_aV() {
        return true;
    }

    private int getAverageNearbyPlayerMagicLevel() {
        if (this.field_70170_p == null) {
            return 0;
        }
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(250.0, 250.0, 250.0));
        if (players.size() == 0) {
            return 0;
        }
        int avgLvl = 0;
        for (EntityPlayer player : players) {
            avgLvl += ExtendedProperties.For((EntityLivingBase)player).getMagicLevel();
        }
        return (int)Math.ceil(avgLvl / players.size());
    }

    public boolean func_70601_bi() {
        if (!SpawnBlacklists.entityCanSpawnHere(this.field_70165_t, this.field_70161_v, this.field_70170_p, (EntityLivingBase)this)) {
            return false;
        }
        if (this.getAverageNearbyPlayerMagicLevel() < 8) {
            return false;
        }
        int avgLevel = this.getAverageNearbyPlayerMagicLevel();
        IAttributeInstance attributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (avgLevel == 0) {
            ExtendedProperties.For((EntityLivingBase)this).setMagicLevelWithMana(10);
            if (this.field_70146_Z.nextInt(100) < 10) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRangedAttackSpell(this, this.MovementSpeed(), 40, NPCSpells.instance.lightMage_NormalAttack));
                this.field_70180_af.func_75692_b(21, (Object)1);
            }
        } else {
            ExtendedProperties.For((EntityLivingBase)this).setMagicLevelWithMana(10 + this.field_70146_Z.nextInt(avgLevel));
            int levelRand = this.field_70146_Z.nextInt(avgLevel * 2);
            if (levelRand > 60) {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRangedAttackSpell(this, this.MovementSpeed(), 100, NPCSpells.instance.lightMage_AugmentedAttack));
                this.field_70180_af.func_75692_b(21, (Object)2);
            }
            if (levelRand > 30) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRangedAttackSpell(this, this.MovementSpeed(), 40, NPCSpells.instance.lightMage_NormalAttack));
                this.field_70180_af.func_75692_b(21, (Object)1);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            ExtendedProperties.For((EntityLivingBase)this).setFullSync();
        }
        this.hasUpdated = true;
        return this.isValidLightLevel() && super.func_70601_bi();
    }

    protected boolean isValidLightLevel() {
        int var3;
        int var2;
        int var1 = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72972_b(EnumSkyBlock.Sky, var1, var2 = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), var3 = MathHelper.func_76128_c((double)this.field_70161_v)) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int var4 = this.field_70170_p.func_72957_l(var1, var2, var3);
        if (this.field_70170_p.func_72911_I()) {
            int var5 = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            var4 = this.field_70170_p.func_72957_l(var1, var2, var3);
            this.field_70170_p.field_73008_k = var5;
        }
        return var4 <= this.field_70146_Z.nextInt(8);
    }

    protected void func_70600_l(int par1) {
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1 && this.func_70681_au().nextDouble() < 0.2) {
            for (int j = 0; j < this.func_70681_au().nextInt(3); ++j) {
                this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.rune, 1, this.func_70681_au().nextInt(16)), 0.0f);
            }
        }
        if (par1 && this.func_70681_au().nextDouble() < 0.2) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.spellParchment, 1, 0), 0.0f);
        }
        if (par1 && this.func_70681_au().nextDouble() < 0.05) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.spellBook, 1, 0), 0.0f);
        }
    }

    protected boolean func_70085_c(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemNameTag) {
            return false;
        }
        if (SkillData.For(player).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("MageBandI")))) {
            if (EntityUtilities.isSummon((EntityLivingBase)this)) {
                player.func_145747_a((IChatComponent)new ChatComponentText(String.format("\u00a7o%s", StatCollector.func_74838_a((String)"am2.npc.partyleave"))));
                EntityUtilities.revertAI(this);
            } else if (ExtendedProperties.For((EntityLivingBase)player).getCanHaveMoreSummons()) {
                if (ExtendedProperties.For((EntityLivingBase)player).getMagicLevel() - 5 >= ExtendedProperties.For((EntityLivingBase)this).getMagicLevel()) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(String.format("\u00a7o%s", StatCollector.func_74838_a((String)"am2.npc.partyjoin"))));
                    EntityUtilities.setOwner((EntityLivingBase)this, (EntityLivingBase)player);
                    EntityUtilities.makeSummon_PlayerFaction(this, player, true);
                    EntityUtilities.setSummonDuration((EntityLivingBase)this, -1);
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(String.format("\u00a7o%s", StatCollector.func_74838_a((String)"am2.npc.partyrefuse"))));
                }
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(String.format("\u00a7o%s", StatCollector.func_74838_a((String)"am2.npc.partyfull"))));
            }
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentText(String.format("\u00a7o%s", StatCollector.func_74838_a((String)"am2.npc.nopartyskill"))));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        return ResourceManager.getMobTexturePath(String.format("light_mages/light_mage_%d.png", this.field_70180_af.func_75679_c(20)));
    }
}

