/*
 * Decompiled with CFR 0.152.
 */
package am2.lore;

import am2.guis.GuiArcaneCompendium;
import am2.lore.ArcaneCompendium;
import am2.lore.CompendiumEntryType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CompendiumEntry
implements Comparable<CompendiumEntry> {
    protected CompendiumEntryType type;
    protected String name;
    protected String description;
    protected String id;
    protected int order;
    protected CompendiumEntry parent;
    protected boolean isLocked;
    protected boolean isNew;
    protected ArrayList<CompendiumEntry> subItems;
    protected ArrayList<String> relatedItems;

    public CompendiumEntry(CompendiumEntryType type) {
        this.type = type;
        this.order = -1;
        this.subItems = new ArrayList();
        this.relatedItems = new ArrayList();
        this.isLocked = true;
    }

    protected CompendiumEntry setParent(CompendiumEntry parent) {
        this.parent = parent;
        return this;
    }

    public final String getID() {
        return this.id;
    }

    public final boolean isLocked() {
        return this.isLocked;
    }

    public final boolean isNew() {
        return this.isNew;
    }

    public final void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public final void setIsLocked(boolean locked) {
        this.isLocked = locked;
    }

    public final String getName() {
        return this.name;
    }

    public final String getName(String subItemID) {
        for (CompendiumEntry entry : this.subItems) {
            if (!entry.getID().equals(subItemID)) continue;
            return entry.getName();
        }
        return this.name;
    }

    public final String getDescription() {
        if ((this.description == null || this.description.equals("")) && this.parent != null) {
            return this.parent.getDescription();
        }
        return this.description;
    }

    public final String getDescription(String subItemID) {
        for (CompendiumEntry entry : this.subItems) {
            if (!entry.getID().equals(subItemID)) continue;
            return this.description + " " + "!l" + " " + "!l" + " " + entry.getDescription();
        }
        return this.getDescription();
    }

    public final String getParentSection() {
        return this.type.getCategoryName();
    }

    public final String getTagName() {
        return this.type.getNodeName();
    }

    public final CompendiumEntry getParent() {
        return this.parent;
    }

    protected abstract void parseEx(Node var1);

    public void parse(Node node) {
        Node idNode = node.getAttributes().getNamedItem("id");
        this.id = idNode != null ? idNode.getNodeValue() : "unknown";
        Node orderNode = node.getAttributes().getNamedItem("order");
        this.order = orderNode != null ? Integer.parseInt(orderNode.getNodeValue()) : -1;
        Node lockableNode = node.getAttributes().getNamedItem("unlocked");
        this.isLocked = lockableNode != null ? !Boolean.parseBoolean(lockableNode.getNodeValue()) : true;
        Node newNode = node.getAttributes().getNamedItem("new");
        this.isNew = newNode != null ? Boolean.parseBoolean(newNode.getNodeValue()) : true;
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName() == "name") {
                this.name = childNode.getTextContent();
                continue;
            }
            if (childNode.getNodeName() == "desc") {
                this.description = childNode.getTextContent();
                continue;
            }
            if (childNode.getNodeName() == "relatedEntries") {
                String[] relatedItems;
                for (String s : relatedItems = childNode.getTextContent().split(",")) {
                    this.relatedItems.add(s.trim());
                }
                continue;
            }
            if (!childNode.getNodeName().equals("subitem")) continue;
            CompendiumEntry subItem = null;
            try {
                subItem = (CompendiumEntry)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            subItem.parse(childNode);
            subItem.setParent(this);
            this.subItems.add(subItem);
            ArcaneCompendium.instance.addAlias(subItem.getID(), this.getID());
        }
        this.parseEx(node);
    }

    public boolean hasSubItems() {
        return this.subItems.size() > 0;
    }

    public CompendiumEntry[] getSubItems() {
        return this.subItems.toArray(new CompendiumEntry[this.subItems.size()]);
    }

    public CompendiumEntry[] getRelatedItems() {
        ArrayList<CompendiumEntry> relations = new ArrayList<CompendiumEntry>();
        for (String s : this.relatedItems) {
            CompendiumEntry e = ArcaneCompendium.instance.getEntry(s);
            if (e == null || e == this) continue;
            relations.add(e);
        }
        return relations.toArray(new CompendiumEntry[relations.size()]);
    }

    public GuiArcaneCompendium getCompendiumGui(String searchID) {
        int meta = -1;
        if (searchID.indexOf(64) > -1) {
            String[] split = searchID.split("@");
            searchID = split[0];
            try {
                meta = Integer.parseInt(split[1]);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return this.getCompendiumGui(searchID, meta);
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract GuiArcaneCompendium getCompendiumGui(String var1, int var2);

    public abstract ItemStack getRepresentItemStack(String var1, int var2);

    @Override
    public int compareTo(CompendiumEntry arg0) {
        if (arg0 == null) {
            return 1;
        }
        if (this.order > -1 && arg0.order > -1) {
            return this.order > arg0.order ? 1 : (this.order < arg0.order ? -1 : 0);
        }
        if (this.name != null && arg0.name != null) {
            return this.name.compareTo(arg0.name);
        }
        if (this.id != null && arg0.id != null) {
            return this.id.compareTo(arg0.id);
        }
        return -1;
    }
}

