/*
 * Decompiled with CFR 0.152.
 */
package am2.preloader;

import am2.preloader.AM2PreloaderContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.lang.reflect.Field;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BytecodeTransformers
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("am2.armor.ItemMageHood") && AM2PreloaderContainer.foundThaumcraft) {
            FMLRelaunchLog.info((String)("AMCore >> Altering definition of " + transformedName + " to be thaumcraft compatible."), (Object[])new Object[0]);
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            cn.interfaces.add("thaumcraft/api/IGoggles");
            cn.interfaces.add("thaumcraft/api/nodes/IRevealer");
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            bytes = cw.toByteArray();
        } else if (transformedName.equals("net.minecraft.client.renderer.EntityRenderer")) {
            FMLRelaunchLog.info((String)("AMCore >> Altering definition of " + transformedName), (Object[])new Object[0]);
            bytes = this.alterEntityRenderer(bytes);
        } else if (transformedName.equals("net.minecraft.client.entity.EntityPlayerSP")) {
            FMLRelaunchLog.info((String)("AMCore >> Altering definition of " + transformedName), (Object[])new Object[0]);
            bytes = this.alterEntityPlayerSP(bytes);
        } else if (transformedName.equals("net.minecraft.entity.EntityPlayerMP")) {
            FMLRelaunchLog.info((String)("AMCore >> Altering definition of " + transformedName), (Object[])new Object[0]);
            bytes = this.alterEntityPlayerMP(bytes);
        } else if (transformedName.equals("net.minecraft.network.NetServerHandler")) {
            FMLRelaunchLog.info((String)("AMCore >> Altering definition of " + transformedName), (Object[])new Object[0]);
            bytes = this.alterNetServerHandler(bytes);
        } else if (transformedName.equals("net.minecraft.client.renderer.entity.RendererLivingEntity")) {
            FMLRelaunchLog.info((String)("AMCore >> Altering definition of " + transformedName), (Object[])new Object[0]);
            bytes = this.alterRendererLivingEntity(bytes);
        } else if (transformedName.equals("net.minecraft.world.World")) {
            FMLRelaunchLog.info((String)("AMCore >> Altering definition of " + transformedName), (Object[])new Object[0]);
            bytes = this.alterWorld(bytes);
        }
        return bytes;
    }

    private byte[] alterRendererLivingEntity(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("a") || !mn.desc.equals("(Lsv;DDDFF)V")) continue;
            AbstractInsnNode target = null;
            FMLRelaunchLog.fine((String)("AMCore >> Located target method " + mn.name + mn.desc), (Object[])new Object[0]);
            for (AbstractInsnNode node : mn.instructions) {
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.name.equals("a") || !method.desc.equals("(Lsv;DDD)V")) continue;
                target = node;
                break;
            }
            if (target == null) continue;
            VarInsnNode aLoad = new VarInsnNode(25, 1);
            MethodInsnNode callout = new MethodInsnNode(184, "am2/utility/RenderUtilities", "setupShrinkRender", "(Lnet/minecraft/entity/EntityLivingBase;)V");
            mn.instructions.insert(target, (AbstractInsnNode)aLoad);
            mn.instructions.insert((AbstractInsnNode)aLoad, (AbstractInsnNode)callout);
            FMLRelaunchLog.fine((String)"AMCore >> Success!  Inserted opcodes!", (Object[])new Object[0]);
            break;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterEntityRenderer(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode mn : cn.methods) {
            if (mn.name.equals("a") && mn.desc.equals("(FI)V")) {
                MethodInsnNode callout;
                VarInsnNode floatset;
                AbstractInsnNode orientCameraNode = null;
                AbstractInsnNode gluPerspectiveNode = null;
                FMLRelaunchLog.fine((String)("AMCore >> Located target method " + mn.name + mn.desc), (Object[])new Object[0]);
                for (AbstractInsnNode node : mn.instructions) {
                    if (node instanceof MethodInsnNode) {
                        MethodInsnNode method = (MethodInsnNode)node;
                        if (orientCameraNode == null && method.name.equals("g") && method.desc.equals("(F)V")) {
                            FMLRelaunchLog.fine((String)("AMCore >> Located target method insn node: " + method.name + method.desc), (Object[])new Object[0]);
                            orientCameraNode = node;
                            continue;
                        }
                        if (gluPerspectiveNode == null && method.name.equals("gluPerspective") && method.desc.equals("(FFFF)V")) {
                            FMLRelaunchLog.fine((String)("AMCore >> Located target method insn node: " + method.name + method.desc), (Object[])new Object[0]);
                            gluPerspectiveNode = node;
                            continue;
                        }
                    }
                    if (orientCameraNode == null || gluPerspectiveNode == null) continue;
                    break;
                }
                if (orientCameraNode != null) {
                    floatset = new VarInsnNode(23, 1);
                    callout = new MethodInsnNode(184, "am2/guis/AMGuiHelper", "shiftView", "(F)V");
                    mn.instructions.insert(orientCameraNode, (AbstractInsnNode)callout);
                    mn.instructions.insert(orientCameraNode, (AbstractInsnNode)floatset);
                    FMLRelaunchLog.fine((String)"AMCore >> Success!  Inserted callout function op (shift)!", (Object[])new Object[0]);
                }
                if (gluPerspectiveNode == null) continue;
                floatset = new VarInsnNode(23, 1);
                callout = new MethodInsnNode(184, "am2/guis/AMGuiHelper", "flipView", "(F)V");
                mn.instructions.insert(gluPerspectiveNode, (AbstractInsnNode)callout);
                mn.instructions.insert(gluPerspectiveNode, (AbstractInsnNode)floatset);
                FMLRelaunchLog.fine((String)"AMCore >> Success!  Inserted callout function op (flip)!", (Object[])new Object[0]);
                continue;
            }
            if (!mn.name.equals("b") || !mn.desc.equals("(F)V")) continue;
            AbstractInsnNode target = null;
            FMLRelaunchLog.fine((String)("AMCore >> Located target method " + mn.name + mn.desc), (Object[])new Object[0]);
            ListIterator instructions = mn.instructions.iterator();
            AbstractInsnNode node = null;
            boolean mouseFound = false;
            while (instructions.hasNext()) {
                node = (AbstractInsnNode)instructions.next();
                if (!mouseFound) {
                    if (!(node instanceof LdcInsnNode) || !((LdcInsnNode)node).cst.equals("mouse")) continue;
                    mouseFound = true;
                    continue;
                }
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.name.equals("a") || !method.desc.equals("(Ljava/lang/String;)V")) continue;
                FMLRelaunchLog.fine((String)("AMCore >> Located target method insn node: " + method.name + method.desc), (Object[])new Object[0]);
                target = node;
                break;
            }
            if (target == null) continue;
            int iRegister = AM2PreloaderContainer.foundOptifine ? 3 : 2;
            VarInsnNode aLoad = new VarInsnNode(25, 0);
            VarInsnNode fLoad = new VarInsnNode(23, 1);
            VarInsnNode iLoad = new VarInsnNode(21, iRegister);
            MethodInsnNode callout = new MethodInsnNode(184, "am2/guis/AMGuiHelper", "overrideMouseInput", "(Lnet/minecraft/client/renderer/EntityRenderer;FZ)Z");
            VarInsnNode iStore = new VarInsnNode(54, iRegister);
            mn.instructions.insert(target, (AbstractInsnNode)iStore);
            mn.instructions.insert(target, (AbstractInsnNode)callout);
            mn.instructions.insert(target, (AbstractInsnNode)iLoad);
            mn.instructions.insert(target, (AbstractInsnNode)fLoad);
            mn.instructions.insert(target, (AbstractInsnNode)aLoad);
            FMLRelaunchLog.fine((String)"AMCore >> Success!  Inserted opcodes!", (Object[])new Object[0]);
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterEntityPlayerSP(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("e") || !mn.desc.equals("()V")) continue;
            AbstractInsnNode target = null;
            FMLRelaunchLog.fine((String)("AMCore >> Located target method " + mn.name + mn.desc), (Object[])new Object[0]);
            ListIterator instructions = mn.instructions.iterator();
            while (instructions.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)instructions.next();
                if (!(node instanceof VarInsnNode) || ((VarInsnNode)node).getOpcode() != 25 || !((node = (AbstractInsnNode)instructions.next()) instanceof FieldInsnNode) || ((FieldInsnNode)node).getOpcode() != 180 || !((node = (AbstractInsnNode)instructions.next()) instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.name.equals("a") || !method.desc.equals("()V")) continue;
                FMLRelaunchLog.fine((String)("AMCore >> Located target method insn node: " + method.name + method.desc), (Object[])new Object[0]);
                target = node;
                break;
            }
            if (target == null) continue;
            MethodInsnNode callout = new MethodInsnNode(184, "am2/guis/AMGuiHelper", "overrideKeyboardInput", "()V");
            mn.instructions.insert(target, (AbstractInsnNode)callout);
            FMLRelaunchLog.fine((String)"AMCore >> Success!  Inserted operations!", (Object[])new Object[0]);
            break;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterWorld(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("a") || !mn.desc.equals("(Lsa;Ljava/lang/String;FF)V")) continue;
            AbstractInsnNode target = null;
            FMLRelaunchLog.fine((String)("AMCore >> Located target method " + mn.name + mn.desc), (Object[])new Object[0]);
            ListIterator instructions = mn.instructions.iterator();
            while (instructions.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)instructions.next();
                if (!(node instanceof VarInsnNode) || ((VarInsnNode)node).getOpcode() != 25 || ((VarInsnNode)node).var != 5) continue;
                AbstractInsnNode potentialMatch = node;
                node = (AbstractInsnNode)instructions.next();
                if (!(node instanceof FieldInsnNode) || ((FieldInsnNode)node).getOpcode() != 180 || !((FieldInsnNode)node).name.equals("name") || !((FieldInsnNode)node).desc.equals("Ljava/lang/String;") || !((FieldInsnNode)node).owner.equals("net/minecraftforge/event/entity/PlaySoundAtEntityEvent")) continue;
                FMLRelaunchLog.fine((String)("AMCore >> Located target method insn node: " + ((FieldInsnNode)node).name + ((FieldInsnNode)node).desc), (Object[])new Object[0]);
                target = potentialMatch;
                break;
            }
            if (target == null) continue;
            VarInsnNode aload1 = new VarInsnNode(25, 1);
            VarInsnNode fload4 = new VarInsnNode(23, 4);
            MethodInsnNode callout = new MethodInsnNode(184, "am2/utility/EntityUtilities", "modifySoundPitch", "(Lsa;F)F");
            VarInsnNode fstore4 = new VarInsnNode(56, 4);
            mn.instructions.insertBefore(target, (AbstractInsnNode)aload1);
            mn.instructions.insertBefore(target, (AbstractInsnNode)fload4);
            mn.instructions.insertBefore(target, (AbstractInsnNode)callout);
            mn.instructions.insertBefore(target, (AbstractInsnNode)fstore4);
            FMLRelaunchLog.fine((String)"AMCore >> Success!  Inserted operations!", (Object[])new Object[0]);
            break;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterEntityPlayerMP(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode mn : cn.methods) {
            FMLLog.info((String)"%s %s", (Object[])new Object[]{mn.name, mn.desc});
            if (!mn.name.equals("b_") || !mn.desc.equals("(Luf;)V")) continue;
            AbstractInsnNode target = null;
            FMLRelaunchLog.fine((String)("AMCore >> Located target method " + mn.name + mn.desc), (Object[])new Object[0]);
            for (AbstractInsnNode node : mn.instructions) {
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.name.equals("e") || !method.desc.equals("(Lnn;)V")) continue;
                target = method.getPrevious().getPrevious().getPrevious();
                break;
            }
            if (target == null) continue;
            FieldInsnNode proxyGet = new FieldInsnNode(178, "am2/AMCore", "proxy", "Lam2/proxy/CommonProxy");
            FieldInsnNode fieldGet = new FieldInsnNode(180, "am2/proxy/CommonProxy", "playerTracker", "Lam2/PlayerTracker");
            VarInsnNode aLoad = new VarInsnNode(25, 0);
            MethodInsnNode callout = new MethodInsnNode(182, "am2/PlayerTracker", "onPlayerDeath", "(Luf;)V");
            mn.instructions.insertBefore(target, (AbstractInsnNode)proxyGet);
            mn.instructions.insertBefore(target, (AbstractInsnNode)fieldGet);
            mn.instructions.insertBefore(target, (AbstractInsnNode)aLoad);
            mn.instructions.insertBefore(target, (AbstractInsnNode)callout);
            FMLRelaunchLog.fine((String)"AMCore >> Success!  Inserted opcodes!", (Object[])new Object[0]);
        }
        return bytes;
    }

    private byte[] alterNetServerHandler(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("a") || !mn.desc.equals("(Leu;)V")) continue;
            AbstractInsnNode target = null;
            FMLRelaunchLog.fine((String)("AMCore >> Located target method " + mn.name + mn.desc), (Object[])new Object[0]);
            ListIterator instructions = mn.instructions.iterator();
            while (instructions.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)instructions.next();
                if (!(node instanceof VarInsnNode) || ((VarInsnNode)node).var != 1 || ((VarInsnNode)node).getOpcode() != 25 || !((node = (AbstractInsnNode)instructions.next()) instanceof FieldInsnNode) || !this.matchFieldNode((FieldInsnNode)node, 180, "eu", "d", "D") || !((node = (AbstractInsnNode)instructions.next()) instanceof VarInsnNode) || ((VarInsnNode)node).var != 1 || ((VarInsnNode)node).getOpcode() != 25 || !((node = (AbstractInsnNode)instructions.next()) instanceof FieldInsnNode) || !this.matchFieldNode((FieldInsnNode)node, 180, "eu", "b", "D") || !((node = (AbstractInsnNode)instructions.next()) instanceof InsnNode) || ((InsnNode)node).getOpcode() != 103 || !((node = (AbstractInsnNode)instructions.next()) instanceof VarInsnNode) || ((VarInsnNode)node).var != 13 || ((VarInsnNode)node).getOpcode() != 57) continue;
                target = node;
                break;
            }
            if (target == null) continue;
            LdcInsnNode ldc = new LdcInsnNode((Object)1.5);
            VarInsnNode dstore13 = new VarInsnNode(57, 13);
            mn.instructions.insert(target, (AbstractInsnNode)ldc);
            mn.instructions.insert((AbstractInsnNode)ldc, (AbstractInsnNode)dstore13);
            FMLRelaunchLog.fine((String)"AMCore >> Success!  Inserted opcodes!", (Object[])new Object[0]);
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private boolean matchFieldNode(FieldInsnNode node, int opcode, String owner, String name, String desc) {
        return node.getOpcode() == opcode && node.owner.equals(owner) && node.name.equals(name) && node.desc.equals(desc);
    }

    private void debugPrintInsns(MethodNode mn) {
        ListIterator it = mn.instructions.iterator();
        FMLRelaunchLog.fine((String)"AMCore >> Beginning dump of Insns for %s %s", (Object[])new Object[]{mn.name, mn.desc});
        FMLRelaunchLog.fine((String)"================================================================================", (Object[])new Object[0]);
        FMLRelaunchLog.log((Level)Level.INFO, (String)"", (Object[])new Object[0]);
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            String className = node.toString().split("@")[0];
            className = className.substring(className.lastIndexOf(".") + 1);
            if (node instanceof VarInsnNode) {
                FMLRelaunchLog.log((Level)Level.INFO, (String)(this.opcodeToString(node.getOpcode()) + " " + ((VarInsnNode)node).var), (Object[])new Object[0]);
                continue;
            }
            if (node instanceof FieldInsnNode) {
                FMLRelaunchLog.log((Level)Level.INFO, (String)(this.opcodeToString(node.getOpcode()) + " " + ((FieldInsnNode)node).owner + "/" + ((FieldInsnNode)node).name + " (" + ((FieldInsnNode)node).desc + ")"), (Object[])new Object[0]);
                continue;
            }
            if (node instanceof MethodInsnNode) {
                FMLRelaunchLog.log((Level)Level.INFO, (String)(this.opcodeToString(node.getOpcode()) + " " + ((MethodInsnNode)node).owner + "/" + ((MethodInsnNode)node).name + " " + ((MethodInsnNode)node).desc), (Object[])new Object[0]);
                continue;
            }
            FMLRelaunchLog.log((Level)Level.INFO, (String)(className + " >> " + this.opcodeToString(node.getOpcode())), (Object[])new Object[0]);
        }
        FMLRelaunchLog.fine((String)"================================================================================", (Object[])new Object[0]);
        FMLRelaunchLog.fine((String)"AMCore >> End", (Object[])new Object[0]);
    }

    private String opcodeToString(int opcode) {
        Field[] fields;
        for (Field f : fields = Opcodes.class.getFields()) {
            if (f.getType() != Integer.class && f.getType() != Integer.TYPE) continue;
            try {
                if (f.getInt(null) != opcode) continue;
                return f.getName();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return "OPCODE_UNKNOWN";
    }
}

