/*
 * Decompiled with CFR 0.152.
 */
package am2.spell;

import am2.AMCore;
import am2.api.SkillTreeEntry;
import am2.api.spell.ISkillTreeManager;
import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.enums.SkillPointTypes;
import am2.api.spell.enums.SkillTrees;
import am2.spell.SkillManager;
import cpw.mods.fml.common.FMLLog;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;

public class SkillTreeManager
implements ISkillTreeManager {
    private final ArrayList<SkillTreeEntry> offenseTree = new ArrayList();
    private final ArrayList<SkillTreeEntry> defenseTree = new ArrayList();
    private final ArrayList<SkillTreeEntry> utilityTree = new ArrayList();
    private final ArrayList<SkillTreeEntry> talentTree = new ArrayList();
    private final HashMap<Integer, SkillPointTypes> skillPointTypeList = new HashMap();
    private int highestSkillDepth = 0;
    public static final SkillTreeManager instance = new SkillTreeManager();

    private SkillTreeManager() {
    }

    public SkillPointTypes getSkillPointTypeForPart(ISkillTreeEntry part) {
        int id = SkillManager.instance.getShiftedPartID(part);
        return this.getSkillPointTypeForPart(id);
    }

    public SkillPointTypes getSkillPointTypeForPart(int id) {
        return this.skillPointTypeList.get(id);
    }

    @Override
    public void RegisterPart(ISkillTreeEntry item, int x, int y, SkillTrees tree, SkillPointTypes requiredPoint, ISkillTreeEntry ... prerequisites) {
        ArrayList<SkillTreeEntry> treeListing = tree == SkillTrees.Defense ? this.defenseTree : (tree == SkillTrees.Offense ? this.offenseTree : (tree == SkillTrees.Utility ? this.utilityTree : this.talentTree));
        ArrayList<SkillTreeEntry> locatedPrerequisites = new ArrayList<SkillTreeEntry>();
        if (prerequisites != null && prerequisites.length > 0) {
            block0: for (ISkillTreeEntry prerequisite : prerequisites) {
                for (SkillTreeEntry entry : treeListing) {
                    if (entry.registeredItem != prerequisite) continue;
                    locatedPrerequisites.add(entry);
                    continue block0;
                }
            }
            if (locatedPrerequisites.size() == 0) {
                throw new InvalidParameterException(String.format("Unable to locate one or more prerequisite items in the specified tree (%s).", tree.toString()));
            }
        }
        boolean enabled = true;
        if (item == null) {
            item = SkillManager.instance.missingComponent;
        } else {
            enabled = AMCore.skillConfig.isSkillEnabled(SkillManager.instance.getSkillName(item));
        }
        SkillTreeEntry newEntry = new SkillTreeEntry(x, y, tree, locatedPrerequisites.toArray(new SkillTreeEntry[locatedPrerequisites.size()]), item, enabled);
        treeListing.add(newEntry);
        this.skillPointTypeList.put(SkillManager.instance.getShiftedPartID(item), requiredPoint);
    }

    public ArrayList<SkillTreeEntry> getTree(SkillTrees tree) {
        ArrayList<SkillTreeEntry> safeCopy = new ArrayList<SkillTreeEntry>();
        switch (tree) {
            case Defense: {
                safeCopy.addAll(this.defenseTree);
                break;
            }
            case Offense: {
                safeCopy.addAll(this.offenseTree);
                break;
            }
            case Utility: {
                safeCopy.addAll(this.utilityTree);
                break;
            }
            case Talents: {
                safeCopy.addAll(this.talentTree);
            }
        }
        return safeCopy;
    }

    public SkillTreeEntry getSkillTreeEntry(ISkillTreeEntry part) {
        ISkillTreeEntry item;
        ArrayList<SkillTreeEntry> treeEntries = instance.getTree(SkillTrees.Offense);
        for (SkillTreeEntry st_entry : treeEntries) {
            item = st_entry.registeredItem;
            if (item == null || item != part) continue;
            return st_entry;
        }
        treeEntries = instance.getTree(SkillTrees.Defense);
        for (SkillTreeEntry st_entry : treeEntries) {
            item = st_entry.registeredItem;
            if (item == null || item != part) continue;
            return st_entry;
        }
        treeEntries = instance.getTree(SkillTrees.Utility);
        for (SkillTreeEntry st_entry : treeEntries) {
            item = st_entry.registeredItem;
            if (item == null || item != part) continue;
            return st_entry;
        }
        treeEntries = instance.getTree(SkillTrees.Talents);
        for (SkillTreeEntry st_entry : treeEntries) {
            item = st_entry.registeredItem;
            if (item == null || item != part) continue;
            return st_entry;
        }
        return null;
    }

    public void init() {
        this.offenseTree.clear();
        this.RegisterPart(SkillManager.instance.getSkill("Projectile"), 300, 45, SkillTrees.Offense, SkillPointTypes.BLUE, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("PhysicalDamage"), 300, 90, SkillTrees.Offense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Projectile"));
        this.RegisterPart(SkillManager.instance.getSkill("Gravity"), 255, 70, SkillTrees.Offense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Projectile"));
        this.RegisterPart(SkillManager.instance.getSkill("Bounce"), 345, 70, SkillTrees.Offense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Projectile"));
        this.RegisterPart(SkillManager.instance.getSkill("FireDamage"), 210, 135, SkillTrees.Offense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("PhysicalDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("LightningDamage"), 255, 135, SkillTrees.Offense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("FireDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("Ignition"), 165, 135, SkillTrees.Offense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("FireDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("Forge"), 120, 135, SkillTrees.Offense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Ignition"));
        this.RegisterPart(SkillManager.instance.getSkill("Contingency_Fire"), 165, 180, SkillTrees.Offense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Ignition"));
        this.RegisterPart(SkillManager.instance.getSkill("MagicDamage"), 390, 135, SkillTrees.Offense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("PhysicalDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("FrostDamage"), 345, 135, SkillTrees.Offense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("MagicDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("Drown"), 435, 135, SkillTrees.Offense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("MagicDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("Blind"), 233, 180, SkillTrees.Offense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("FireDamage"), SkillManager.instance.getSkill("LightningDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("AoE"), 300, 180, SkillTrees.Offense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("PhysicalDamage"), SkillManager.instance.getSkill("FrostDamage"), SkillManager.instance.getSkill("FireDamage"), SkillManager.instance.getSkill("LightningDamage"), SkillManager.instance.getSkill("MagicDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("Freeze"), 345, 180, SkillTrees.Offense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("FrostDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("Knockback"), 390, 180, SkillTrees.Offense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("MagicDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("Solar"), 210, 225, SkillTrees.Offense, SkillPointTypes.RED, SkillManager.instance.getSkill("Blind"));
        this.RegisterPart(SkillManager.instance.getSkill("Storm"), 255, 225, SkillTrees.Offense, SkillPointTypes.RED, SkillManager.instance.getSkill("LightningDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("AstralDistortion"), 367, 215, SkillTrees.Offense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("MagicDamage"), SkillManager.instance.getSkill("FrostDamage"));
        this.RegisterPart(SkillManager.instance.getSkill("Silence"), 345, 245, SkillTrees.Offense, SkillPointTypes.RED, SkillManager.instance.getSkill("AstralDistortion"));
        this.RegisterPart(SkillManager.instance.getSkill("Fling"), 390, 245, SkillTrees.Offense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Knockback"));
        this.RegisterPart(SkillManager.instance.getSkill("VelocityAdded"), 390, 290, SkillTrees.Offense, SkillPointTypes.RED, SkillManager.instance.getSkill("Fling"));
        this.RegisterPart(SkillManager.instance.getSkill("WateryGrave"), 435, 245, SkillTrees.Offense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Drown"));
        this.RegisterPart(SkillManager.instance.getSkill("Piercing"), 323, 215, SkillTrees.Offense, SkillPointTypes.RED, SkillManager.instance.getSkill("Freeze"));
        this.RegisterPart(SkillManager.instance.getSkill("Beam"), 300, 270, SkillTrees.Offense, SkillPointTypes.RED, SkillManager.instance.getSkill("AoE"));
        this.RegisterPart(SkillManager.instance.getSkill("Damage"), 300, 315, SkillTrees.Offense, SkillPointTypes.RED, SkillManager.instance.getSkill("Beam"));
        this.RegisterPart(SkillManager.instance.getSkill("Fury"), 255, 315, SkillTrees.Offense, SkillPointTypes.RED, SkillManager.instance.getSkill("Beam"), SkillManager.instance.getSkill("Storm"));
        this.RegisterPart(SkillManager.instance.getSkill("Wave"), 367, 315, SkillTrees.Offense, SkillPointTypes.RED, SkillManager.instance.getSkill("Beam"), SkillManager.instance.getSkill("Fling"));
        this.RegisterPart(SkillManager.instance.getSkill("Blizzard"), 75, 45, SkillTrees.Offense, SkillPointTypes.SILVER, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("FallingStar"), 75, 90, SkillTrees.Offense, SkillPointTypes.SILVER, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("FireRain"), 75, 135, SkillTrees.Offense, SkillPointTypes.SILVER, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("Dismembering"), 75, 180, SkillTrees.Offense, SkillPointTypes.SILVER, new ISkillTreeEntry[0]);
        this.defenseTree.clear();
        this.RegisterPart(SkillManager.instance.getSkill("Self"), 267, 45, SkillTrees.Defense, SkillPointTypes.BLUE, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("Leap"), 222, 90, SkillTrees.Defense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Self"));
        this.RegisterPart(SkillManager.instance.getSkill("Regeneration"), 357, 90, SkillTrees.Defense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Self"));
        this.RegisterPart(SkillManager.instance.getSkill("Shrink"), 402, 90, SkillTrees.Defense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Regeneration"));
        this.RegisterPart(SkillManager.instance.getSkill("Slowfall"), 222, 135, SkillTrees.Defense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Leap"));
        this.RegisterPart(SkillManager.instance.getSkill("Heal"), 357, 135, SkillTrees.Defense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Regeneration"));
        this.RegisterPart(SkillManager.instance.getSkill("LifeTap"), 312, 135, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Heal"));
        this.RegisterPart(SkillManager.instance.getSkill("Healing"), 402, 135, SkillTrees.Defense, SkillPointTypes.RED, SkillManager.instance.getSkill("Heal"));
        this.RegisterPart(SkillManager.instance.getSkill("Summon"), 267, 135, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("LifeTap"));
        this.RegisterPart(SkillManager.instance.getSkill("Contingency_Damage"), 447, 180, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Healing"));
        this.RegisterPart(SkillManager.instance.getSkill("Haste"), 177, 155, SkillTrees.Defense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Slowfall"));
        this.RegisterPart(SkillManager.instance.getSkill("Slow"), 132, 155, SkillTrees.Defense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Slowfall"));
        this.RegisterPart(SkillManager.instance.getSkill("GravityWell"), 222, 180, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Slowfall"));
        this.RegisterPart(SkillManager.instance.getSkill("LifeDrain"), 312, 180, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("LifeTap"));
        this.RegisterPart(SkillManager.instance.getSkill("Dispel"), 357, 180, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Heal"));
        this.RegisterPart(SkillManager.instance.getSkill("Contingency_Fall"), 267, 180, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("GravityWell"));
        this.RegisterPart(SkillManager.instance.getSkill("SwiftSwim"), 177, 200, SkillTrees.Defense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Haste"));
        this.RegisterPart(SkillManager.instance.getSkill("Repel"), 132, 200, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Slow"));
        this.RegisterPart(SkillManager.instance.getSkill("Levitate"), 222, 225, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("GravityWell"));
        this.RegisterPart(SkillManager.instance.getSkill("ManaDrain"), 312, 225, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("LifeDrain"));
        this.RegisterPart(SkillManager.instance.getSkill("Zone"), 357, 225, SkillTrees.Defense, SkillPointTypes.RED, SkillManager.instance.getSkill("Dispel"));
        this.RegisterPart(SkillManager.instance.getSkill("Wall"), 87, 200, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Repel"));
        this.RegisterPart(SkillManager.instance.getSkill("Accelerate"), 177, 245, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("SwiftSwim"));
        this.RegisterPart(SkillManager.instance.getSkill("Entangle"), 132, 245, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Repel"));
        this.RegisterPart(SkillManager.instance.getSkill("Appropriation"), 87, 245, SkillTrees.Defense, SkillPointTypes.RED, SkillManager.instance.getSkill("Entangle"));
        this.RegisterPart(SkillManager.instance.getSkill("Flight"), 222, 270, SkillTrees.Defense, SkillPointTypes.RED, SkillManager.instance.getSkill("Levitate"));
        this.RegisterPart(SkillManager.instance.getSkill("Shield"), 357, 270, SkillTrees.Defense, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Zone"));
        this.RegisterPart(SkillManager.instance.getSkill("Contingency_Health"), 402, 270, SkillTrees.Defense, SkillPointTypes.RED, SkillManager.instance.getSkill("Shield"));
        this.RegisterPart(SkillManager.instance.getSkill("Rune"), 157, 315, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Accelerate"), SkillManager.instance.getSkill("Entangle"));
        this.RegisterPart(SkillManager.instance.getSkill("RuneProcs"), 157, 360, SkillTrees.Defense, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Rune"));
        this.RegisterPart(SkillManager.instance.getSkill("Speed"), 202, 315, SkillTrees.Defense, SkillPointTypes.RED, SkillManager.instance.getSkill("Accelerate"), SkillManager.instance.getSkill("Flight"));
        this.RegisterPart(SkillManager.instance.getSkill("Reflect"), 357, 315, SkillTrees.Defense, SkillPointTypes.RED, SkillManager.instance.getSkill("Shield"));
        this.RegisterPart(SkillManager.instance.getSkill("ChronoAnchor"), 312, 315, SkillTrees.Defense, SkillPointTypes.RED, SkillManager.instance.getSkill("Reflect"));
        this.RegisterPart(SkillManager.instance.getSkill("Duration"), 312, 360, SkillTrees.Defense, SkillPointTypes.RED, SkillManager.instance.getSkill("ChronoAnchor"));
        this.RegisterPart(SkillManager.instance.getSkill("ManaLink"), 30, 45, SkillTrees.Defense, SkillPointTypes.SILVER, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("ManaShield"), 30, 90, SkillTrees.Defense, SkillPointTypes.SILVER, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("BuffPower"), 30, 135, SkillTrees.Defense, SkillPointTypes.SILVER, new ISkillTreeEntry[0]);
        this.utilityTree.clear();
        this.RegisterPart(SkillManager.instance.getSkill("Touch"), 275, 75, SkillTrees.Utility, SkillPointTypes.BLUE, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("Dig"), 275, 120, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Touch"));
        this.RegisterPart(SkillManager.instance.getSkill("WizardsAutumn"), 315, 120, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Dig"));
        this.RegisterPart(SkillManager.instance.getSkill("TargetNonSolid"), 230, 75, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Touch"));
        this.RegisterPart(SkillManager.instance.getSkill("PlaceBlock"), 185, 93, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Dig"));
        this.RegisterPart(SkillManager.instance.getSkill("FeatherTouch"), 230, 137, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Dig"));
        this.RegisterPart(SkillManager.instance.getSkill("MiningPower"), 185, 137, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("FeatherTouch"));
        this.RegisterPart(SkillManager.instance.getSkill("Light"), 275, 165, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Dig"));
        this.RegisterPart(SkillManager.instance.getSkill("NightVision"), 185, 165, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Light"));
        this.RegisterPart(SkillManager.instance.getSkill("Binding"), 275, 210, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Light"));
        this.RegisterPart(SkillManager.instance.getSkill("Disarm"), 230, 210, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Binding"));
        this.RegisterPart(SkillManager.instance.getSkill("Charm"), 315, 235, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Binding"));
        this.RegisterPart(SkillManager.instance.getSkill("TrueSight"), 185, 210, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("NightVision"));
        this.RegisterPart(SkillManager.instance.getSkill("Lunar"), 145, 210, SkillTrees.Utility, SkillPointTypes.RED, SkillManager.instance.getSkill("TrueSight"));
        this.RegisterPart(SkillManager.instance.getSkill("HarvestPlants"), 365, 120, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Binding"));
        this.RegisterPart(SkillManager.instance.getSkill("Plow"), 365, 165, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Binding"));
        this.RegisterPart(SkillManager.instance.getSkill("Plant"), 365, 210, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Binding"));
        this.RegisterPart(SkillManager.instance.getSkill("CreateWater"), 365, 255, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Binding"));
        this.RegisterPart(SkillManager.instance.getSkill("Drought"), 365, 300, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Binding"));
        this.RegisterPart(SkillManager.instance.getSkill("BanishRain"), 365, 345, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Drought"));
        this.RegisterPart(SkillManager.instance.getSkill("WaterBreathing"), 410, 345, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Drought"));
        this.RegisterPart(SkillManager.instance.getSkill("Grow"), 410, 210, SkillTrees.Utility, SkillPointTypes.RED, SkillManager.instance.getSkill("Drought"), SkillManager.instance.getSkill("CreateWater"), SkillManager.instance.getSkill("Plant"), SkillManager.instance.getSkill("Plow"), SkillManager.instance.getSkill("HarvestPlants"));
        this.RegisterPart(SkillManager.instance.getSkill("Chain"), 455, 210, SkillTrees.Utility, SkillPointTypes.RED, SkillManager.instance.getSkill("Grow"));
        this.RegisterPart(SkillManager.instance.getSkill("Rift"), 275, 255, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Binding"));
        this.RegisterPart(SkillManager.instance.getSkill("Invisibility"), 185, 255, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("TrueSight"));
        this.RegisterPart(SkillManager.instance.getSkill("RandomTeleport"), 185, 300, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Invisibility"));
        this.RegisterPart(SkillManager.instance.getSkill("Attract"), 245, 300, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Rift"));
        this.RegisterPart(SkillManager.instance.getSkill("Telekinesis"), 305, 300, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Rift"));
        this.RegisterPart(SkillManager.instance.getSkill("Blink"), 185, 345, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("RandomTeleport"));
        this.RegisterPart(SkillManager.instance.getSkill("Range"), 140, 345, SkillTrees.Utility, SkillPointTypes.RED, SkillManager.instance.getSkill("Blink"));
        this.RegisterPart(SkillManager.instance.getSkill("Channel"), 275, 345, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Attract"), SkillManager.instance.getSkill("Telekinesis"));
        this.RegisterPart(SkillManager.instance.getSkill("Radius"), 275, 390, SkillTrees.Utility, SkillPointTypes.RED, SkillManager.instance.getSkill("Channel"));
        this.RegisterPart(SkillManager.instance.getSkill("Transplace"), 185, 390, SkillTrees.Utility, SkillPointTypes.BLUE, SkillManager.instance.getSkill("Blink"));
        this.RegisterPart(SkillManager.instance.getSkill("Mark"), 155, 435, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Transplace"));
        this.RegisterPart(SkillManager.instance.getSkill("Recall"), 215, 435, SkillTrees.Utility, SkillPointTypes.GREEN, SkillManager.instance.getSkill("Transplace"));
        this.RegisterPart(SkillManager.instance.getSkill("DivineIntervention"), 172, 480, SkillTrees.Utility, SkillPointTypes.RED, SkillManager.instance.getSkill("Recall"), SkillManager.instance.getSkill("Mark"));
        this.RegisterPart(SkillManager.instance.getSkill("EnderIntervention"), 198, 480, SkillTrees.Utility, SkillPointTypes.RED, SkillManager.instance.getSkill("Recall"), SkillManager.instance.getSkill("Mark"));
        this.RegisterPart(SkillManager.instance.getSkill("Contingency_Death"), 198, 524, SkillTrees.Utility, SkillPointTypes.RED, SkillManager.instance.getSkill("EnderIntervention"));
        this.RegisterPart(SkillManager.instance.getSkill("Daylight"), 75, 45, SkillTrees.Utility, SkillPointTypes.SILVER, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("Moonrise"), 75, 90, SkillTrees.Utility, SkillPointTypes.SILVER, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("Prosperity"), 75, 135, SkillTrees.Utility, SkillPointTypes.SILVER, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("ManaRegenI"), 275, 75, SkillTrees.Talents, SkillPointTypes.BLUE, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("Colour"), 230, 75, SkillTrees.Talents, SkillPointTypes.BLUE, new ISkillTreeEntry[0]);
        this.RegisterPart(SkillManager.instance.getSkill("AffinityGains"), 365, 120, SkillTrees.Talents, SkillPointTypes.BLUE, SkillManager.instance.getSkill("ManaRegenI"));
        this.RegisterPart(SkillManager.instance.getSkill("ManaRegenII"), 275, 120, SkillTrees.Talents, SkillPointTypes.GREEN, SkillManager.instance.getSkill("ManaRegenI"));
        this.RegisterPart(SkillManager.instance.getSkill("SpellMotion"), 230, 120, SkillTrees.Talents, SkillPointTypes.GREEN, SkillManager.instance.getSkill("ManaRegenII"));
        this.RegisterPart(SkillManager.instance.getSkill("AugmentedCasting"), 230, 165, SkillTrees.Talents, SkillPointTypes.RED, SkillManager.instance.getSkill("SpellMotion"));
        this.RegisterPart(SkillManager.instance.getSkill("ManaRegenIII"), 275, 165, SkillTrees.Talents, SkillPointTypes.RED, SkillManager.instance.getSkill("ManaRegenII"));
        this.RegisterPart(SkillManager.instance.getSkill("ExtraSummon"), 230, 210, SkillTrees.Talents, SkillPointTypes.RED, SkillManager.instance.getSkill("AugmentedCasting"));
        this.RegisterPart(SkillManager.instance.getSkill("MageBandI"), 320, 120, SkillTrees.Talents, SkillPointTypes.GREEN, SkillManager.instance.getSkill("ManaRegenI"));
        this.RegisterPart(SkillManager.instance.getSkill("MageBandII"), 320, 165, SkillTrees.Talents, SkillPointTypes.RED, SkillManager.instance.getSkill("MageBandI"));
        this.calculateHighestOverallTier();
        this.checkAllPartIDs(SkillManager.instance.getAllShapes());
        this.checkAllPartIDs(SkillManager.instance.getAllComponents());
        this.checkAllPartIDs(SkillManager.instance.getAllModifiers());
        this.checkAllPartIDs(SkillManager.instance.getAllTalents());
        AMCore.skillConfig.save();
    }

    public int[] getDisabledSkillIDs() {
        ArrayList<Integer> disableds = new ArrayList<Integer>();
        for (SkillTreeEntry entry : this.offenseTree) {
            if (entry.enabled) continue;
            disableds.add(SkillManager.instance.getShiftedPartID(entry.registeredItem));
        }
        for (SkillTreeEntry entry : this.defenseTree) {
            if (entry.enabled) continue;
            disableds.add(SkillManager.instance.getShiftedPartID(entry.registeredItem));
        }
        for (SkillTreeEntry entry : this.utilityTree) {
            if (entry.enabled) continue;
            disableds.add(SkillManager.instance.getShiftedPartID(entry.registeredItem));
        }
        for (SkillTreeEntry entry : this.talentTree) {
            if (entry.enabled) continue;
            disableds.add(SkillManager.instance.getShiftedPartID(entry.registeredItem));
        }
        int[] toReturn = new int[disableds.size()];
        for (int i = 0; i < disableds.size(); ++i) {
            toReturn[i] = (Integer)disableds.get(i);
        }
        return toReturn;
    }

    private void checkAllPartIDs(ArrayList<Integer> partIDs) {
        for (Integer i : partIDs) {
            ISkillTreeEntry part = SkillManager.instance.getSkill(i);
            if (this.getSkillTreeEntry(part) != null) continue;
            FMLLog.info((String)("Ars Magica 2 >> Unregistered spell part in skill trees: " + part.toString()), (Object[])new Object[0]);
        }
    }

    private void calculateHighestOverallTier() {
        int offense = this.calculateHighestTier(this.offenseTree);
        int defense = this.calculateHighestTier(this.defenseTree);
        int utility = this.calculateHighestTier(this.utilityTree);
        this.highestSkillDepth = Math.max(offense, Math.max(defense, utility));
    }

    private int calculateHighestTier(ArrayList<SkillTreeEntry> tree) {
        int highest = 0;
        for (SkillTreeEntry entry : tree) {
            if (entry.tier <= highest) continue;
            highest = entry.tier;
        }
        return highest;
    }

    public int getHighestTier() {
        return this.highestSkillDepth;
    }

    public void disableAllSkillsIn(int[] disabledSkills) {
        for (SkillTreeEntry entry : this.offenseTree) {
            entry.enabled = true;
        }
        for (SkillTreeEntry entry : this.defenseTree) {
            entry.enabled = true;
        }
        for (SkillTreeEntry entry : this.utilityTree) {
            entry.enabled = true;
        }
        for (SkillTreeEntry entry : this.talentTree) {
            entry.enabled = true;
        }
        for (int i : disabledSkills) {
            SkillTreeEntry entry = this.getSkillTreeEntry(SkillManager.instance.getSkill(i));
            if (entry != null) {
                entry.enabled = false;
                FMLLog.info((String)"Ars Magica 2 >> Disabling %s as per server configs", (Object[])new Object[]{SkillManager.instance.getSkillName(entry.registeredItem)});
                continue;
            }
            FMLLog.warning((String)"Ars Magica 2 >> could not disable skill ID %d as per server configs!", (Object[])new Object[0]);
        }
    }

    public boolean isSkillDisabled(ISkillTreeEntry component) {
        SkillTreeEntry entry = this.getSkillTreeEntry(component);
        if (entry == null) {
            return false;
        }
        return !entry.enabled;
    }
}

