/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.damage.DamageSources;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Drown
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase) || target instanceof EntityIronGolem) {
            return false;
        }
        if (((EntityLivingBase)target).func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            return false;
        }
        float baseDamage = 12.0f;
        double damage = SpellUtils.instance.getModifiedDouble_Add(baseDamage, stack, caster, target, world, 0, SpellModifiers.DAMAGE);
        return SpellHelper.instance.attackTargetSpecial(stack, target, DamageSources.causeEntityDrownDamage(caster), SpellUtils.instance.modifyDamage(caster, (float)damage));
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 80.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 20.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "bubbles", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 0.5, 1.0);
            particle.func_70024_g(rand.nextDouble() * 0.2 - 0.1, rand.nextDouble() * 0.2, rand.nextDouble() * 0.2 - 0.1);
            particle.setAffectedByGravity();
            particle.setDontRequireControllers();
            particle.setMaxAge(5);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.WATER);
    }

    @Override
    public int getID() {
        return 62;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[5];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 2);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 0);
        objectArray[2] = Items.field_151131_as;
        objectArray[3] = Items.field_151007_F;
        objectArray[4] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 5);
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }
}

