/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.buffs.BuffList;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.utility.DimensionUtilities;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class EnderIntervention
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (world.field_72995_K || !(target instanceof EntityLivingBase)) {
            return true;
        }
        if (((EntityLivingBase)target).func_82165_m(BuffList.astralDistortion.field_76415_H)) {
            if (target instanceof EntityPlayer) {
                ((EntityPlayer)target).func_145747_a((IChatComponent)new ChatComponentText("The distortion around you prevents you from teleporting"));
            }
            return true;
        }
        if (target.field_71093_bK == 1) {
            if (target instanceof EntityPlayer) {
                ((EntityPlayer)target).func_145747_a((IChatComponent)new ChatComponentText("Nothing happens..."));
            }
            return true;
        }
        if (target.field_71093_bK == -1) {
            if (target instanceof EntityPlayer) {
                ((EntityPlayer)target).func_145747_a((IChatComponent)new ChatComponentText("You are already in the nether."));
            }
            return false;
        }
        DimensionUtilities.doDimensionTransfer((EntityLivingBase)target, -1);
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 400.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return new ItemStack[]{new ItemStack((Item)ItemsCommonProxy.essence, 1, 9)};
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 100; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "ghost", x, y - 1.0, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 2.0, 1.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.1f, 1, false));
            particle.setMaxAge(25 + rand.nextInt(10));
            particle.setRGBColorF(0.7f, 0.2f, 0.2f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.ENDER);
    }

    @Override
    public int getID() {
        return 13;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[5];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 13);
        objectArray[1] = Blocks.field_150343_Z;
        objectArray[2] = Blocks.field_150343_Z;
        objectArray[3] = Items.field_151033_d;
        objectArray[4] = Items.field_151079_bi;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.4f;
    }
}

