/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.renderer;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import erogenousbeef.bigreactors.api.data.ReactantData;
import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.block.BlockFuelRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class SimpleRendererFuelRod
implements ISimpleBlockRenderingHandler {
    private static final float FLUID_RENDER_OFFSET_MAX = 0.05f;
    private static final float FLUID_RENDER_OFFSET_MIN = 0.45f;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntityReactorFuelRod fuelRod;
        if (!(block instanceof BlockFuelRod)) {
            return false;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        BlockFuelRod blockFuelRod = (BlockFuelRod)block;
        boolean renderTop = block.func_149646_a(world, x, y + 1, z, 0);
        boolean renderBottom = block.func_149646_a(world, x, y - 1, z, 0);
        boolean renderedFuelOnTop = false;
        boolean renderedFuelOnBottom = false;
        boolean[] renderSides = new boolean[]{block.func_149646_a(world, x, y, z - 1, 2), block.func_149646_a(world, x, y, z + 1, 3), block.func_149646_a(world, x - 1, y, z, 4), block.func_149646_a(world, x + 1, y, z, 5)};
        if (!(renderTop || renderBottom || renderSides[0] || renderSides[1] || renderSides[2] || renderSides[3])) {
            return false;
        }
        boolean rendered = false;
        int blockMetadata = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorFuelRod && (fuelRod = (TileEntityReactorFuelRod)te).isConnected()) {
            MultiblockReactor reactor = (MultiblockReactor)fuelRod.getMultiblockController();
            int fuelAmount = reactor.getFuelAmount();
            int wasteAmount = reactor.getWasteAmount();
            int totalFluid = fuelAmount + wasteAmount;
            int capacity = reactor.getCapacity();
            if (capacity > 0 && totalFluid > 0) {
                int wasteColor;
                float fluidColumnOffsetFromCenter = -1.0f;
                IIcon iconBottom = null;
                IIcon iconSide = null;
                float blue = 1.0f;
                float green = 1.0f;
                float red = 1.0f;
                iconSide = BigReactors.fluidFuelColumn.getFlowingIcon();
                iconBottom = BigReactors.fluidFuelColumn.getStillIcon();
                ReactantData fuelData = Reactants.getReactant(reactor.getFuelType());
                ReactantData wasteData = Reactants.getReactant(reactor.getWasteType());
                int fuelColor = fuelData != null ? fuelData.getColor() : 12368464;
                int n = wasteColor = wasteData != null ? wasteData.getColor() : 5083829;
                if (fuelAmount == 0) {
                    red = SimpleRendererFuelRod.unpackR(wasteColor);
                    green = SimpleRendererFuelRod.unpackG(wasteColor);
                    blue = SimpleRendererFuelRod.unpackB(wasteColor);
                } else if (fuelAmount >= totalFluid) {
                    red = SimpleRendererFuelRod.unpackR(fuelColor);
                    green = SimpleRendererFuelRod.unpackG(fuelColor);
                    blue = SimpleRendererFuelRod.unpackB(fuelColor);
                } else {
                    float proportion = (float)fuelAmount / (float)totalFluid;
                    float fuelR = SimpleRendererFuelRod.unpackR(fuelColor);
                    float fuelG = SimpleRendererFuelRod.unpackG(fuelColor);
                    float fuelB = SimpleRendererFuelRod.unpackB(fuelColor);
                    float wasteR = SimpleRendererFuelRod.unpackR(wasteColor);
                    float wasteG = SimpleRendererFuelRod.unpackG(wasteColor);
                    float wasteB = SimpleRendererFuelRod.unpackB(wasteColor);
                    red = SimpleRendererFuelRod.lerp(wasteR, fuelR, proportion);
                    green = SimpleRendererFuelRod.lerp(wasteG, fuelG, proportion);
                    blue = SimpleRendererFuelRod.lerp(wasteB, fuelB, proportion);
                }
                float pctFilled = Math.min(1.0f, Math.max(0.0f, (float)totalFluid / (float)capacity));
                fluidColumnOffsetFromCenter = SimpleRendererFuelRod.lerp(0.45f, 0.05f, pctFilled);
                if (iconSide != null && iconBottom != null) {
                    tessellator.func_78369_a(red, green, blue, 0.75f);
                    tessellator.func_78380_c(world.func_72802_i(x, y, z, 15));
                    renderer.func_147757_a(iconBottom);
                    float xzMin = fluidColumnOffsetFromCenter;
                    float xzMax = 1.0f - fluidColumnOffsetFromCenter;
                    renderer.func_147782_a((double)xzMin, (double)0.01f, (double)xzMin, (double)xzMax, (double)0.99f, (double)xzMax);
                    if (renderer.field_147837_f || renderBottom) {
                        rendered = true;
                        renderer.func_147768_a(block, (double)x, (double)y, (double)z, iconBottom);
                    }
                    if (renderer.field_147837_f || renderTop) {
                        rendered = true;
                        renderer.func_147806_b(block, (double)x, (double)y, (double)z, iconBottom);
                    }
                    renderer.func_147757_a(iconSide);
                    renderer.func_147782_a((double)xzMin, 0.0, (double)xzMin, (double)xzMax, 1.0, (double)xzMax);
                    if (renderer.field_147837_f || renderSides[0]) {
                        rendered = true;
                        renderer.func_147761_c(block, (double)x, (double)y, (double)z, iconSide);
                    }
                    if (renderer.field_147837_f || renderSides[1]) {
                        rendered = true;
                        renderer.func_147734_d(block, (double)x, (double)y, (double)z, iconSide);
                    }
                    if (renderer.field_147837_f || renderSides[2]) {
                        rendered = true;
                        renderer.func_147798_e(block, (double)x, (double)y, (double)z, iconSide);
                    }
                    if (renderer.field_147837_f || renderSides[3]) {
                        rendered = true;
                        renderer.func_147764_f(block, (double)x, (double)y, (double)z, iconSide);
                    }
                }
            }
        }
        tessellator.func_78370_a(255, 255, 255, 255);
        renderer.func_147775_a(block);
        renderer.func_147757_a(null);
        if (!renderedFuelOnBottom && (renderer.field_147837_f || renderBottom)) {
            rendered = true;
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            renderer.func_147768_a(block, (double)x, (double)y, (double)z, block.func_149691_a(0, blockMetadata));
        }
        if (renderer.field_147837_f || renderTop) {
            rendered = true;
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            renderer.func_147806_b(block, (double)x, (double)y, (double)z, block.func_149691_a(1, blockMetadata));
        }
        if (renderer.field_147837_f || renderSides[0]) {
            rendered = true;
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            renderer.func_147761_c(block, (double)x, (double)y, (double)z, block.func_149691_a(2, blockMetadata));
        }
        if (renderer.field_147837_f || renderSides[1]) {
            rendered = true;
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            renderer.func_147734_d(block, (double)x, (double)y, (double)z, block.func_149691_a(3, blockMetadata));
        }
        if (renderer.field_147837_f || renderSides[2]) {
            rendered = true;
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            renderer.func_147798_e(block, (double)x, (double)y, (double)z, block.func_149691_a(4, blockMetadata));
        }
        if (renderer.field_147837_f || renderSides[3]) {
            rendered = true;
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            renderer.func_147764_f(block, (double)x, (double)y, (double)z, block.func_149691_a(5, blockMetadata));
        }
        return rendered;
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return true;
    }

    public int getRenderId() {
        return BlockFuelRod.renderId;
    }

    protected static float unpackR(int rgb) {
        return (float)(rgb >> 16 & 0xFF) / 255.0f;
    }

    protected static float unpackG(int rgb) {
        return (float)(rgb >> 8 & 0xFF) / 255.0f;
    }

    protected static float unpackB(int rgb) {
        return (float)(rgb & 0xFF) / 255.0f;
    }

    protected static float lerp(float min, float max, float value) {
        return min + (max - min) * value;
    }
}

