/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorGlass;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartGlass;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.multiblock.IMultiblockPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMultiblockGlass
extends BlockContainer {
    public static final int METADATA_REACTOR = 0;
    public static final int METADATA_TURBINE = 1;
    private static String[] subBlocks = new String[]{"reactor", "turbine"};
    private IIcon[][] icons = new IIcon[subBlocks.length][16];
    private IIcon transparentIcon;

    public BlockMultiblockGlass(Material material) {
        super(material);
        this.func_149672_a(field_149778_k);
        this.func_149711_c(2.0f);
        this.func_149663_c("multiblockGlass");
        this.func_149658_d("bigreactors:multiblockGlass");
        this.func_149647_a(BigReactors.TAB);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileEntityReactorGlass();
            }
            case 1: {
                return new TileEntityTurbinePartGlass();
            }
        }
        throw new IllegalArgumentException("Unrecognized metadata");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.transparentIcon = par1IconRegister.func_94245_a("bigreactors:" + this.func_149739_a() + ".transparent");
        for (int metadata = 0; metadata < subBlocks.length; ++metadata) {
            for (int i = 0; i < 16; ++i) {
                this.icons[metadata][i] = par1IconRegister.func_94245_a("bigreactors:" + this.func_149739_a() + "." + subBlocks[metadata] + "." + Integer.toString(i));
            }
        }
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        ForgeDirection[] dirsToCheck = StaticUtils.neighborsBySide[side];
        Block myBlock = blockAccess.func_147439_a(x, y, z);
        int myBlockMetadata = blockAccess.func_72805_g(x, y, z);
        ForgeDirection out = ForgeDirection.getOrientation((int)side);
        if (blockAccess.func_147439_a(x + out.offsetX, y + out.offsetY, z + out.offsetZ) == myBlock && blockAccess.func_72805_g(x + out.offsetX, y + out.offsetY, z + out.offsetZ) == myBlockMetadata) {
            return this.transparentIcon;
        }
        int iconIdx = 0;
        for (int i = 0; i < dirsToCheck.length; ++i) {
            ForgeDirection dir = dirsToCheck[i];
            if (blockAccess.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != myBlock || blockAccess.func_72805_g(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != myBlockMetadata) continue;
            iconIdx |= 1 << i;
        }
        return this.icons[myBlockMetadata][iconIdx];
    }

    public IIcon func_149691_a(int side, int metadata) {
        return this.icons[metadata][0];
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public ItemStack getItemStack(String name) {
        int metadata = -1;
        for (int i = 0; i < subBlocks.length; ++i) {
            if (!subBlocks[i].equals(name)) continue;
            metadata = i;
            break;
        }
        if (metadata < 0) {
            throw new IllegalArgumentException("Unable to find a block with the name " + name);
        }
        return new ItemStack((Block)this, 1, metadata);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < subBlocks.length; ++i) {
            par3List.add(new ItemStack((Block)this, 1, i));
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity te;
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K && player.func_71045_bC() == null && (te = world.func_147438_o(x, y, z)) instanceof IMultiblockPart) {
            MultiblockControllerBase controller = ((IMultiblockPart)te).getMultiblockController();
            if (controller == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText(String.format("SERIOUS ERROR - server part @ %d, %d, %d has no controller!", x, y, z)));
            } else {
                MultiblockValidationException e = controller.getLastValidationException();
                if (e != null) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(e.getMessage()));
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

